function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/*jshint browser: true, debug: true */
define(['baja!', 'Promise', 'underscore', 'nmodule/js/rc/asyncUtils/promiseMux', 'bajaux/registry/RegistryEntry', 'nmodule/webEditors/rc/servlets/registry'], function (baja, Promise, _, promiseMux, RegistryEntry, registry) {
  'use strict';
  /**
   * Wait this many milliseconds for additional requests to come in before
   * making the post up to the station servlets.
   *
   * @inner
   * @constant
   * @type {Number}
   */

  var POST_DELAY = 20;

  function muxedFetchAgents() {
    return promiseMux({
      exec: function exec(typeSpecs) {
        var batch = new baja.comm.Batch(),
            prom = Promise.all([registry.getTypeInfo(typeSpecs, {
          batch: batch
        }), registry.getAgentOnInfo(typeSpecs, {
          is: 'web:IJavaScript',
          batch: batch
        })]);
        batch.commit();
        return prom.then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 2),
              typeArray = _ref2[0],
              agentArrays = _ref2[1];

          return _.map(typeSpecs, function (typeSpec, i) {
            return [typeArray[i], agentArrays[i]];
          });
        });
      },
      cache: true,
      delay: POST_DELAY
    });
  }

  var fetchAgents = muxedFetchAgents(); ////////////////////////////////////////////////////////////////
  // Utility functions
  ////////////////////////////////////////////////////////////////

  /**
   * Retrieve JSON data from the registry for the requested type specs.
   *
   * @inner
   * @param {Array.<String|Type>} typeSpecs
   * @returns {Promise} promise to be resolved with an array containing two
   * objects: the first for direct type information, the second for agent-on
   * information.
   */

  function retrieveJson(typeSpecs) {
    return Promise.all(_.map(typeSpecs, fetchAgents)).then(function (arrays) {
      //each POST resolves an array with two elements
      var typeObj = {},
          agentObj = {};

      _.each(typeSpecs, function (typeSpec, i) {
        var arr = arrays[i];
        typeObj[typeSpec] = arr[0];
        agentObj[typeSpec] = arr[1];
      });

      return [typeObj, agentObj];
    });
  }
  /**
   * Given a JSON object retrieved from one of the registry servlets, build up
   * a registry entry that can be stored in the field editor registry.
   *
   * @inner
   * @param {{ js: {id: string, deps: Array.<string> }, interfaces: Array.<string> }} jsonObj
   * @returns {module:bajaux/registry/RegistryEntry}
   */


  function toEntry(jsonObj) {
    var js = jsonObj.js;

    if (js) {
      return new RegistryEntry({
        rjs: js.id,
        deps: js.deps,
        tags: jsonObj.interfaces
      });
    }
  }
  /**
   * Makes the call to the registry servlets to retrieve the type info, then
   * assemble that type info into `RegistryEntry`s.
   *
   * @inner
   * @param {Array.<String>} typeSpecs
   * @returns {Promise} promise to be resolved with a two-dimensional
   * array of registry entries. First dimension corresponds to the type specs
   * passed in, second dimension is entries per type spec.
   */


  function retrieveEntries(typeSpecs) {
    return retrieveJson(typeSpecs).then(function (_ref3) {
      var _ref4 = _slicedToArray(_ref3, 2),
          typeJson = _ref4[0],
          agentJson = _ref4[1];

      //typeJson: typeSpec -> { interfaces: [], js: { deps: [], id: '', type: '', wd: true  } }
      //agentJson: typeSpec -> [ { interfaces: [], js: { deps: [], id: '', type: '', wd: true } } ]
      return _.map(typeSpecs, function (typeSpec) {
        var typeObj = typeJson[typeSpec],
            typeEntry = typeObj && toEntry(typeObj),
            agentArr = agentJson[typeSpec] || [],
            agentEntries = _.map(agentArr, toEntry);

        return _.compact(typeEntry ? [typeEntry].concat(agentEntries) : agentEntries);
      });
    });
  }

  function findMatching(entries, params) {
    return _.filter(entries, function (entry) {
      return entry.matches(params);
    });
  } ////////////////////////////////////////////////////////////////
  // Exports
  ////////////////////////////////////////////////////////////////

  /**
   * API Status: **Private**
   *
   * Module for retrieving type and agent information from the station and
   * assembling it into entries to be stored in the local station registry.
   *
   * This module calls out to
   * {@link module:nmodule/webEditors/rc/servlets/registry|registry} module,
   * which does the direct HTTP communications with the server. Think of that
   * one as a low-level registry interop module, with this one doing the work
   * of orchestrating multiple calls to it and packaging the raw data returned
   * into nice, usable results.
   *
   * @exports nmodule/webEditors/rc/fe/registry/servletViews
   */


  var exports = {};
  /**
   * Retrieve the default registry entry for the given type spec. This will be
   * whatever appears first in the agent list for that type, that matches the
   * requested parameters.
   *
   * @param {String} typeSpec
   * @param {Object} [params]
   * @returns {Promise} promise to be resolved with a
   * {@link module:bajaux/registry/RegistryEntry|RegistryEntry},
   * or `undefined` if none matching
   */

  exports.getDefaultEntry = function (typeSpec, params) {
    return exports.getEntries(typeSpec).then(function (entries) {
      return findMatching(entries, params)[0];
    });
  };
  /**
   * Retrieve registry entries for all `BIJavaScript` agent registrations on
   * the given type (including the type itself, if it is `BIJavaScript`).
   *
   * @param {String|Array.<String>} typeSpec
   * @returns {Promise} promise to be resolved with an array of
   * `RegistryEntry`s
   */


  exports.getEntries = function (typeSpec) {
    var isArray = Array.isArray(typeSpec),
        typeSpecs = isArray ? typeSpec : Array.prototype.slice.call(arguments);
    return retrieveEntries(typeSpecs).then(function (arrays) {
      if (!isArray && typeSpecs.length === 1) {
        return arrays[0];
      }

      return arrays;
    });
  };
  /**
   * Delete all cached promises, causing future requests to always call back
   * up to the station. Note that these promises will be wiped on page reload
   * anyway. Mostly for test purposes.
   *
   * @private
   */


  exports.$clear = function () {
    fetchAgents = muxedFetchAgents();
  };

  return exports;
});
