function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/registry/impl/AgentRegistry
 */
define(['Promise', 'underscore', 'nmodule/webEditors/rc/fe/baja/util/typeUtils', 'bajaux/registry/Registry', 'nmodule/webEditors/rc/fe/registry/servletViews'], function (Promise, _, typeUtils, Registry, servletViews) {
  'use strict';

  var getSuperTypeChain = typeUtils.getSuperTypeChain,
      importTypes = typeUtils.importTypes,
      FORM_FACTORS = ['web:IFormFactorMini', 'web:IFormFactorCompact', 'web:IFormFactorMax']; ////////////////////////////////////////////////////////////////
  // Support functions
  ////////////////////////////////////////////////////////////////

  function isFormFactor(t) {
    return _.contains(FORM_FACTORS, t);
  }

  function containsFormFactor(tags) {
    return !!_.find(tags, isFormFactor);
  } ////////////////////////////////////////////////////////////////
  // Exports
  ////////////////////////////////////////////////////////////////

  /**
   * A registry for retrieving, storing, and querying information about
   * RequireJS modules registered on baja TypeSpecs. This information will be
   * retrieved directly from the station registry as `web:IJavaScript` classes
   * registered as agents on other Types.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/fe/registry/impl/AgentRegistry
   * @extends module:bajaux/registry/Registry
   */


  var AgentRegistry = /*#__PURE__*/function (_Registry) {
    _inherits(AgentRegistry, _Registry);

    var _super = _createSuper(AgentRegistry);

    function AgentRegistry() {
      var _this;

      _classCallCheck(this, AgentRegistry);

      _this = _super.apply(this, arguments);
      _this.$fetchedStatus = {};
      return _this;
    }

    return AgentRegistry;
  }(Registry);
  /**
   * Sanitize registration parameters. In particular, if registering with a
   * form factor interface like `web:IFormFactorMini`, ensure that the
   * `web:IFormFactor` superinterface is included so that the entry will be
   * returned on future queries for `web:IFormFactor`. This is necessary
   * because the `RegAgentOnTypeServlet` et al do not include superinterfaces,
   * only those explicitly declared on the class.
   *
   * @private
   * @param {Object} params registration params
   * @returns {Object} sanitized params
   */


  AgentRegistry.$processParamsForRegistration = function (params) {
    var tags = params && params.tags;

    if (tags && containsFormFactor(tags) && !_.contains(tags, 'web:IFormFactor')) {
      params.tags = tags.concat(['web:IFormFactor']);
    }

    return params;
  };
  /**
   * Check to see if information about the given type spec has already been
   * queried from the station.
   *
   * @private
   * @param {Type|String} typeSpec
   * @returns {Boolean}
   */


  AgentRegistry.prototype.$isFetched = function (typeSpec) {
    return this.$fetchedStatus[typeSpec];
  };
  /**
   * Mark the given type spec as having been queried from the station: no more
   * calls to the registry servlet will be performed for this type spec. (Note
   * that since we added registry info to BajaScript, this no longer saves any
   * actual network traffic; but prevents types from double-registering.)
   *
   * @private
   * @param {Type|String} typeSpec
   */


  AgentRegistry.prototype.$markFetched = function (typeSpec) {
    //TODO: should i be able to un-mark a type so it gets re-fetched?
    this.$fetchedStatus[typeSpec] = true;
  };
  /**
   * Perform the work of fetching all `web:IJavaScript` data down from the
   * station and storing it. After this is complete, the data can be queried
   * and used without ever having to query the station about this type spec
   * again.
   *
   * @private
   * @param {Type} type
   * @returns {Promise} promise to be resolved after all data has been fetched
   * and stored. No data is returned from this function - query the type spec
   * afterwards using the usual `queryAll` etc. If the type has already been
   * fetched, this promise will be immediately resolved without doing any work.
   */


  AgentRegistry.prototype.$pullFromStation = function (type) {
    var that = this,
        stationReg = that.getLocal(),
        toFetch;

    if (that.$isFetched(type)) {
      return Promise.resolve();
    }

    toFetch = _.filter(getSuperTypeChain(type), function (superType) {
      return !that.$isFetched(superType);
    });
    return servletViews.getEntries(toFetch).then(function (arraysOfEntries) {
      _.each(arraysOfEntries, function (entries, i) {
        var typeSpec = toFetch[i];

        if (that.$isFetched(typeSpec)) {
          return;
        }

        _.each(entries.reverse(), function (entry) {
          stationReg.register(typeSpec, AgentRegistry.$processParamsForRegistration({
            deps: entry.getJsDependencies(),
            tags: entry.getTags(),
            rjs: entry.getJsId()
          }));
          that.$markFetched(typeSpec);
        });
      });
    }).then(function () {
      that.emit('changed');
    });
  };
  /**
   * Prepare for a registry query by ensuring that the type is imported and
   * that we've retrieved and preloaded all necessary agent registration info
   * from the station.
   *
   * @private
   * @param {String} typeSpec
   * @returns {Promise} promise to be resolved, with the imported type,
   * after all info is preloaded
   */


  AgentRegistry.prototype.$preQuery = function (typeSpec) {
    var that = this;
    return importTypes(typeSpec).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 1),
          t = _ref2[0];

      return that.$pullFromStation(t).then(function () {
        return t;
      });
    });
  };
  /**
   * Query all entries from the station that match the given type spec and
   * parameters. The results will be retrieved using the station's agent
   * registration information if needed. Note that results from supertypes
   * will not be included.
   *
   * @param {Type|String} typeSpec
   * @param {Object} params query parameters
   * @returns {Promise} promise to be resolved with an array of
   * `RegistryEntry` objects, or empty if none found; rejected if the station
   * could not be successfully queried for registry info
   */


  AgentRegistry.prototype.queryAll = function (typeSpec, params) {
    var that = this;
    return that.$preQuery(typeSpec).then(function () {
      return that.getLocal().queryAll(typeSpec, params);
    });
  };
  /**
   * Perform a query on the registry and return only the first matching
   * `RegistryEntry`. (This would be the default view, default menu agent, etc.)
   *
   * @param {Type|String} typeSpec
   * @param {Object} params query parameters
   * @returns {Promise} promise to be resolved with a `RegistryEntry`
   * object, or `undefined` if none found; rejected if the station could not
   * be successfully queried for registry info
   */


  AgentRegistry.prototype.queryFirst = function (typeSpec, params) {
    var that = this;
    return that.$preQuery(typeSpec).then(function () {
      return that.getLocal().queryFirst(typeSpec, params);
    });
  };

  return AgentRegistry;
});
