function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/*global niagara: false */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/registry/StationRegistry
 */
define(['log!nmodule.webEditors.rc.fe.registry.StationRegistry', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/baja/util/typeUtils', 'bajaux/registry/Registry', 'nmodule/webEditors/rc/fe/registry/impl/AgentRegistry', 'bajaux/registry/impl/JsRegistry', 'nmodule/webEditors/rc/util/storageUtil'], function (log, Promise, _, typeUtils, Registry, AgentRegistry, JsRegistry, storageUtil) {
  'use strict';

  var instance,
      empty = {},
      getSuperTypeChain = typeUtils.getSuperTypeChain,
      importTypes = typeUtils.importTypes,
      logError = log.severe.bind(log),
      AUTO_SAVE_INTERVAL = 500,
      LOCAL_STORAGE_KEY = 'fe.registry'; ////////////////////////////////////////////////////////////////
  // Support functions
  ////////////////////////////////////////////////////////////////

  /**
   * Get the `niagara.env` object or a new blank object if not found.
   *
   * @inner
   * @returns {Object}
   */

  function getEnv() {
    return typeof niagara !== 'undefined' && niagara.env || empty;
  } //TODO: can't this be made public on BajaScript?

  /**
   * Get the last build date from the station registry.
   *
   * @inner
   * @returns {Date} last build date or `undefined` if it could not be found
   */


  function getRegistryBuildDate() {
    var ts = getEnv().regLastBuildTime;
    return ts && new Date(ts);
  }
  /**
   * Query all registry entries for the entire supertype chain from both the
   * station and local registries, and resolve results as one big flattened
   * array.
   *
   * @inner
   * @param {module:nmodule/webEditors/rc/fe/registry/impl/AgentRegistry} agentReg
   * @param {module:bajaux/registry/impl/JsRegistry} localReg
   * @param {Type} type
   * @param {Object} params query parameters
   * @returns {Promise} promise to be resolved with array of matching
   * `RegistryEntry`s.
   */


  function queryAllSupertypes(agentReg, localReg, type, params) {
    return Promise.all(_.map(getSuperTypeChain(type), function (type) {
      var typeSpec = type.getTypeSpec();
      return Promise.all([agentReg.queryAll(typeSpec, params), localReg.queryAll(typeSpec, params)]);
    })).then(function (arrays) {
      var entries = _.flatten(arrays); //raw JsRegistry returns them in reverse order: most recent last.
      //we want most recent first. also, remove duplicates before returning.
      //entries considered duplicate if the same RequireJS module ID.


      return _.uniq(entries, _.property('$rjs')).reverse();
    });
  }
  /**
   * Query the first matching registry entry from both the station and local
   * registries, walking up the supertype chain as necessary until one is
   * found. (Local registration will trump station registration.)
   *
   * @inner
   * @param {module:nmodule/webEditors/rc/fe/registry/impl/AgentRegistry} agentReg
   * @param {module:bajaux/registry/impl/JsRegistry} localReg
   * @param {Array.<Type>} chain the supertype chain, most specific type first
   * @param {Object} params query parameters
   * @returns {Promise} Promise to be resolved with matching `RegistryEntry`,
   * or undefined if none found
   */


  function queryFirstFromSupertypes(agentReg, localReg, chain, params) {
    if (!chain.length) {
      return Promise.resolve();
    }

    return Promise.all([localReg.queryFirst(chain[0], params), agentReg.queryFirst(chain[0], params)]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
          localEntry = _ref2[0],
          agentEntry = _ref2[1];

      return localEntry || agentEntry || queryFirstFromSupertypes(agentReg, localReg, chain.slice(1), params);
    });
  }
  /**
   * Check to see if the registry object retrieved from local storage is still
   * valid and ready to be reused. If so, the AgentRegistry instance will
   * be rebuilt from it - otherwise it will be created blank and all data
   * re-downloaded from the station.
   *
   * In order to still be valid, the saved registry data needs to not be older
   * than the last time the station registry was rebuilt, and the same user
   * needs to be logged on using the same profile.
   *
   * @private
   * @param {Object} obj
   * @returns {Boolean}
   */


  function $stillValid(obj) {
    obj = obj || {};
    var stationBuildDate = getRegistryBuildDate(),
        myBuildDate = obj.regLastBuildTime,
        stationBuildTime = stationBuildDate && stationBuildDate.getTime(),
        myBuildTime = myBuildDate && new Date(myBuildDate).getTime(),
        env = getEnv();
    return !!(stationBuildTime && myBuildTime === stationBuildTime && env.user === obj.user && env.profile === obj.profile);
  } ////////////////////////////////////////////////////////////////
  // Exports
  ////////////////////////////////////////////////////////////////

  /**
   * A registry for retrieving, storing, and querying information about
   * RequireJS modules registered on baja TypeSpecs. This information can be
   * registered locally just in the browser (independent of the station
   * registry) or retrieved directly from the station as `web:IJavaScript`
   * classes and agents.
   *
   * Entries retrieved using this registry will have all relevant interface
   * type specs (e.g. `web:IFormFactorMax`, `webEditors:IJavaScriptMenuAgent`,
   * etc.) as tags and can be queried as such.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/fe/registry/StationRegistry
   * @extends module:bajaux/registry/Registry
   */


  var StationRegistry = /*#__PURE__*/function (_Registry) {
    _inherits(StationRegistry, _Registry);

    var _super = _createSuper(StationRegistry);

    function StationRegistry() {
      var _this;

      _classCallCheck(this, StationRegistry);

      _this = _super.apply(this, arguments);
      _this.$agentReg = new AgentRegistry();
      return _this;
    }

    return StationRegistry;
  }(Registry);

  StationRegistry.$stillValid = $stillValid;
  /**
   * Return a single, shared instance that is suitable for querying the
   * registry from any other module. It will be reconstituted from local
   * storage (key: `fe.registry`) upon first access, and saved periodically
   * upon modification.
   *
   * @returns {module:nmodule/webEditors/rc/fe/registry/StationRegistry}
   */

  StationRegistry.getInstance = function () {
    if (instance) {
      return instance;
    }

    var storage = storageUtil.getLocalStorage(),
        json;

    try {
      json = storage.getItem(LOCAL_STORAGE_KEY);
    } catch (e) {}

    var obj = json && JSON.parse(json);
    instance = new StationRegistry($stillValid(obj) && obj.db);
    instance.on('changed', _.throttle(function () {
      var env = getEnv();

      try {
        storage.setItem(LOCAL_STORAGE_KEY, JSON.stringify({
          db: instance.toJSON(),
          regLastBuildTime: new Date(),
          user: env.user,
          profile: env.profile
        }));
      } catch (e) {
        logError(e);
      }
    }, AUTO_SAVE_INTERVAL));
    return instance;
  };
  /**
   * Register the given type spec locally, sanitizing the input parameters.
   *
   * @param {String} typeSpec
   * @param {module:bajaux/registry/Registry~QueryParams} params
   * query parameters/metadata for this entry
   * @returns {Promise} promise to be resolved after registration is complete
   */


  StationRegistry.prototype.register = function (typeSpec, params) {
    return Registry.prototype.register.call(this, typeSpec, AgentRegistry.$processParamsForRegistration(params));
  };
  /**
   * Query all entries matching the given type spec and parameters. The
   * entries resolved will all match the given parameters, but their order
   * follows certain rules:
   *
   * - Entries from the station are of a lower priority than entries registered
   *   locally
   * - Entries from the station are returned in agent-registration order -
   *   priority is respected *a la* the view selection dropdown in Workbench
   * - Entries registered on a supertype are of a lower priority than entries
   *   registered on a subtype
   * - Entries registered earlier are of a lower priority than entries
   *   registered later
   *
   * The highest priority entries are first in the resolved array (index 0).
   * It follows that the default matching entry is at index 0, so this
   * RequireJS module would be suitable for a default view to show upon
   * hyperlinking to an ORD, for example.
   *
   * @param {Type|String} typeSpec
   * @param {module:bajaux/registry/Registry~QueryParams} params
   * @returns {Promise} promise to be resolved with an array of
   * `RegistryEntry` objects, or empty if none found; rejected if the station
   * could not be successfully queried for registry info
   */


  StationRegistry.prototype.queryAll = function (typeSpec, params) {
    var that = this;
    return importTypes(typeSpec).then(function (_ref3) {
      var _ref4 = _slicedToArray(_ref3, 1),
          type = _ref4[0];

      return queryAllSupertypes(that.$agentReg, that.getLocal(), type, params);
    });
  };
  /**
   * Perform a query on the registry and return only the first matching
   * `RegistryEntry`. (This would be the default view, default menu agent, etc.)
   *
   * @param {Type|String} typeSpec
   * @param {module:bajaux/registry/Registry~QueryParams} params
   * @returns {Promise} promise to be resolved with a `RegistryEntry`
   * object, or `undefined` if none found; rejected if the station could not
   * be successfully queried for registry info
   */


  StationRegistry.prototype.queryFirst = function (typeSpec, params) {
    var that = this;
    return importTypes(typeSpec).then(function (_ref5) {
      var _ref6 = _slicedToArray(_ref5, 1),
          type = _ref6[0];

      var localReg = that.getLocal(),
          agentReg = that.$agentReg,
          chain = getSuperTypeChain(type).reverse();
      return queryFirstFromSupertypes(agentReg, localReg, chain, params);
    });
  };
  /**
   * Clear out local registry information. This will cause all future queries
   * to this registry to re-fetch registry info from the station.
   *
   * Emits a `changed` tinyevent.
   *
   * @private
   */


  StationRegistry.prototype.$clear = function () {
    this.$localReg = new JsRegistry();
    this.$agentReg = new AgentRegistry();
    this.$fetchedStatus = {}; //clear underscore memoization caches

    this.$clearMemoization();
    this.emit('changed');
  };

  return StationRegistry;
});
