function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/registry/NiagaraWidgetManager
 */
define(['baja!', 'log!nmodule.webEditors.rc.fe.registry.NiagaraWidgetManager', 'bajaux/Properties', 'bajaux/lifecycle/WidgetManager', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/feUtils', 'nmodule/webEditors/rc/fe/baja/ComplexSlotEditor', 'nmodule/webEditors/rc/fe/baja/DisplayOnlyEditor', 'nmodule/webEditors/rc/fe/baja/util/facetsUtils', 'nmodule/webEditors/rc/fe/baja/util/typeUtils'], function (baja, log, Properties, WidgetManager, Promise, _, feUtils, ComplexSlotEditor, DisplayOnlyEditor, facetsUtils, typeUtils) {
  'use strict';

  var logWarning = log.warning.bind(log);
  var extend = _.extend;
  var toProperties = facetsUtils.toProperties;
  var deriveSpecifiedConstructor = feUtils.deriveSpecifiedConstructor,
      getFormFactors = feUtils.getFormFactors,
      toRegistryQuery = feUtils.toRegistryQuery;
  var importTypes = typeUtils.importTypes,
      isComplex = typeUtils.isComplex,
      isType = typeUtils.isType;
  /**
   * Performs widget lookups and lifecycle management that are specific to
   * Niagara; it will be aware of Niagara-specific functionality like looking
   * up widgets via agent registrations in the Niagara registry, and
   * instantiating widgets that operate on Slots on Complexes.
   *
   * @private
   * @class
   * @extends module:bajaux/lifecycle/WidgetManager
   * @alias module:nmodule/webEditors/rc/fe/registry/NiagaraWidgetManager
   */

  return /*#__PURE__*/function (_WidgetManager) {
    _inherits(NiagaraWidgetManager, _WidgetManager);

    var _super = _createSuper(NiagaraWidgetManager);

    function NiagaraWidgetManager() {
      _classCallCheck(this, NiagaraWidgetManager);

      return _super.apply(this, arguments);
    }

    _createClass(NiagaraWidgetManager, [{
      key: "buildContext",
      value: function buildContext(params) {
        var _this = this;

        params = _.extend({}, params, {
          properties: Properties.extend({
            timeFormat: baja.getTimeFormatPattern(),
            unitConversion: baja.getUnitConversion()
          }, params.properties, toProperties(params.facets)).toObject()
        });
        return Promise.resolve(getValue(params)).then(function (value) {
          return _get(_getPrototypeOf(NiagaraWidgetManager.prototype), "buildContext", _this).call(_this, params).then(function (cx) {
            var constructorParams = cx.constructorParams;
            extend(constructorParams, params);

            if (typeof cx.value === 'undefined') {
              cx.value = value;
            }

            return cx;
          });
        });
      }
      /**
       * If the `complex` and `slot` params were passed in, we will instantiate a
       * `ComplexSlotEditor`. If no widget constructor is provided, default to a
       * `DisplayOnlyEditor`.
       *
       * @param buildContext
       * @returns {module:bajaux/Widget|Promise.<module:bajaux/Widget>}
       */

    }, {
      key: "instantiate",
      value: function instantiate(buildContext) {
        var constructorParams = buildContext.constructorParams,
            widgetConstructor = buildContext.widgetConstructor;
        var Ctor = widgetConstructor || DisplayOnlyEditor;

        var _ref = constructorParams || {},
            complex = _ref.complex,
            slot = _ref.slot;

        if (complex && slot) {
          //we're editing a slot on a component.
          return ComplexSlotEditor.make(Ctor, constructorParams);
        }

        return !widgetConstructor ? new Ctor(constructorParams) : _get(_getPrototypeOf(NiagaraWidgetManager.prototype), "instantiate", this).call(this, buildContext);
      }
      /**
       * In Niagara world, in addition to the normal `WidgetManager` behavior,
       * the `type` parameter may be a TypeSpec, or the constructor may be defined
       * by a `uxFieldEditor` property.
       *
       * @param {object} params
       * @returns {Promise.<Function>|undefined} the configured constructor,
       * if present
       */

    }, {
      key: "deriveConfiguredConstructor",
      value: function deriveConfiguredConstructor(params) {
        if (isType(params.type)) {
          //if it's a Niagara type, we know the constructor must be resolved from the registry
          return this.resolveFromRegistry(params);
        }

        return Promise.resolve(_get(_getPrototypeOf(NiagaraWidgetManager.prototype), "deriveConfiguredConstructor", this).call(this, params)).then(function (ctor) {
          return ctor || deriveSpecifiedConstructor(params);
        });
      }
      /**
       * Looks up the widget constructor by checking the loaded value for a
       * Niagara type, and checking the associated agent registrations in the
       * Niagara registry.
       *
       * @param {object} params
       * @returns {Promise<Function>}
       */

    }, {
      key: "resolveFromRegistry",
      value: function resolveFromRegistry(params) {
        var _this2 = this;

        //if we get here, there's no type and no uxFieldEditor facet.
        //at this point, the editor resolved from the registry is basically
        //unpredictable, and without a formFactor, it might not fit in your
        //DOM element.
        if (getFormFactors(params).length === 0) {
          logWarning(new Error('without formFactor(s) parameter, constructed ' + 'editor will be of undetermined form factor'));
        }

        return getValue(params).then(function (value) {
          if (baja.hasType(value)) {
            return _this2.$registry.resolveFirst(value.getType(), toRegistryQuery(params));
          }
        });
      }
    }]);

    return NiagaraWidgetManager;
  }(WidgetManager);
  /**
   * @private
   * @param {Object} params
   * @returns {Promise} promise to be resolved with an array containing the
   * value and type to use
   */

  function getValue(params) {
    var type = params.type,
        complex = params.complex,
        slot = params.slot,
        value = params.value; //if type is given as a type spec string, or as an actual Type object

    if (isType(type)) {
      return importTypes(type).then(function () {
        return baja.$(type);
      });
    } else {
      if (complex && slot) {
        if (!isComplex(complex)) {
          return reject('complex was not actually baja:Complex');
        } else if (!complex.has(slot)) {
          return reject('slot ' + slot + ' does not exist on given Complex');
        } else {
          slot = complex.getSlot(slot);

          if (slot.isProperty()) {
            if (typeof value === 'undefined') {
              value = complex.get(slot);
            }

            if (!baja.hasType(value) || !value.getType().is(slot.getType())) {
              return reject('given value does not match slot type');
            }

            return resolve(value);
          } else {
            return resolve(slot);
          }
        }
      } else {
        return resolve(value);
      }
    }
  }
  /**
   * @returns {Promise.<*>}
   */


  function resolve(obj) {
    return Promise.resolve(obj);
  }
  /**
   * @param {String} err
   * @returns {Promise.<Error>}
   */


  function reject(err) {
    return Promise.reject(new Error(err));
  }
});
