function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */
define(['baja!', 'baja!control:PriorityLevel', 'lex!baja,control', 'Promise', 'nmodule/webEditors/rc/fe/baja/util/rangeUtils'], function (baja, types, lexs, Promise, rangeUtils) {
  'use strict';

  var bajaLex = lexs[0],
      controlLex = lexs[1],
      getEnumRangeDisplay = rangeUtils.getEnumRangeDisplay;
  var lexKeys = ['Status.disabled', 'Status.fault', 'Status.down', 'Status.alarm', 'Status.stale', 'Status.overridden', 'Status.null', 'Status.unackedAlarm'];
  var ACTIVE_LEVEL = 'activeLevel';
  /**
   * API Status: **Private**
   * @exports nmodule/webEditors/rc/fe/baja/util/statusUtils
   */

  var exports = {}; //TODO: baja.lex does not document module param
  //TODO: BStatus gets a lot of its toString from BBitString - do we need to support that?

  function statusBitsToString(bits) {
    var statuses, i;

    if (bits === 0) {
      statuses = [bajaLex.get('Status.ok')];
    } else {
      statuses = [];

      for (i = 0; i < lexKeys.length; i++) {
        if (bits & 1 << i) {
          statuses.push(bajaLex.get(lexKeys[i]));
        }
      }
    }

    return '{' + statuses.join(',') + '}';
  }
  /**
   * `DynamicEnum`s don't have display tags, but `FrozenEnum`s do. This function
   * converts a `DynamicEnum` backed by a `PriorityLevel` into the corresponding
   * display tag, pulling it from the `control` lexicon in the case of
   * `fallback`. Other Simple values just get toStringed.
   *
   * @private
   * @inner
   * @param {baja.Simple} activeLevel
   * @returns {String}
   * @see BPriorityLevel.getDisplayTag()
   */


  function activeLevelToString(activeLevel) {
    return '@ ' + (toPriorityLevelString(activeLevel) || activeLevel);
  } //TODO: this needs to be a PriorityLevel type extension (NCCB-24257)


  function toPriorityLevelString(priorityLevel) {
    if (!baja.hasType(priorityLevel, 'baja:DynamicEnum')) {
      return null;
    }

    var frozen = priorityLevel.getRange().getFrozenType();

    if (frozen && frozen.is('control:PriorityLevel')) {
      var frozenEnum = baja.$('control:PriorityLevel').get(priorityLevel.getOrdinal());
      return frozenEnum.getTag() === 'fallback' ? controlLex.get('def') : frozenEnum.getDisplayTag();
    }
  }

  function facetsToString(facets) {
    var keys = facets.getKeys(),
        key,
        value,
        a = [],
        i;

    for (i = 0; i < keys.length; i++) {
      key = keys[i];
      value = facets.get(key);

      if (key === ACTIVE_LEVEL) {
        a.push(activeLevelToString(value));
      } else if (value === true) {
        a.push(key);
      } else {
        a.push(key + '=' + value);
      }
    }

    return a.join(' ');
  }

  function simpleToString(simple, obj) {
    switch (String(simple.getType())) {
      case 'baja:Boolean':
        var text = obj[simple ? 'trueText' : 'falseText'];
        return text ? baja.Format.format(text) : bajaLex.get(String(simple));

      case 'baja:Double':
        return simple.toString(obj);

      case 'baja:DynamicEnum':
        return getEnumRangeDisplay(simple.getOrdinal(), obj.range || simple.getRange());

      case 'baja:String':
        return simple;

      default:
        return String(simple);
    }
  }
  /**
   * Converts a `baja.Status` to a display string in a similar way to `BStatus`.
   *
   * @param {baja.Status|Number} status the status to encode (a bit string in
   * the form of a number will be converted to a `baja.Status`)
   * @returns {Promise} promise to be resolved with the toString-ed
   * status, or rejected if the input was invalid
   */


  exports.statusToString = function statusToString(status) {
    if (typeof status === 'number') {
      status = baja.Status.make(status);
    }

    if (!baja.hasType(status, 'baja:Status')) {
      return Promise.reject(new Error('baja:Status or number required'));
    }

    var str = statusBitsToString(status.getBits()),
        facets = status.getFacets();

    if (facets && facets !== baja.Facets.DEFAULT) {
      str += ' ' + facetsToString(facets);
    }

    return Promise.resolve(str);
  }; //TODO: remove 90% of this and use baja.Simple#toString(cx)

  /**
   * Resolve a human-readable string value for a `StatusValue`.
   *
   * Supports `trueText` and `falseText` for booleans, `range` for enums,
   * and all properties (`precision` etc.) that are supported by `numberUtils`.
   *
   * @param {baja.Struct} statusValue a `baja:StatusValue`
   * @param {Object} [config] properties to use to format the `value` property
   * @returns {*}
   */


  exports.statusValueToString = function (statusValue, config) {
    if (!baja.hasType(statusValue, 'baja:StatusValue')) {
      return Promise.reject(new Error('baja:StatusValue required'));
    }

    var status = statusValue.get('status'),
        value = statusValue.get('value');
    return Promise.all([status.isNull() ? '-' : simpleToString(value, config || {}), exports.statusToString(status)]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
          valueString = _ref2[0],
          statusString = _ref2[1];

      return valueString + ' ' + statusString;
    });
  };

  return exports;
});
