function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/compat/CompositeAbsTimeEditor
 */
define(['baja!', 'bajaScript/baja/obj/dateTimeUtil', 'jquery', 'Promise', 'bajaux/events', 'bajaux/Widget', 'nmodule/webEditors/rc/fe/baja/BaseEditor'], function (baja, dateTimeUtil, $, Promise, events, Widget, BaseEditor) {
  'use strict';

  var MODIFY_EVENT = events.MODIFY_EVENT,
      getDateOnlyFormat = dateTimeUtil.getDateOnlyFormat,
      DEFAULT_TIME_FORMAT = dateTimeUtil.DEFAULT_TIME_FORMAT,
      TIMEZONE_PROPERTY = "TimeZone";

  function getIndexOfFirstDateCharacter(timeFormat) {
    for (var dateIndex = 0; dateIndex < timeFormat.length; dateIndex++) {
      if (timeFormat[dateIndex] === 'D' || timeFormat[dateIndex] === 'M' || timeFormat[dateIndex] === 'Y' || timeFormat[dateIndex] === 'w' || timeFormat[dateIndex] === 'W') {
        return dateIndex;
      }
    }

    return -1;
  }

  function getIndexOfFirstTimeCharacter(timeFormat) {
    for (var timeIndex = 0; timeIndex < timeFormat.length; timeIndex++) {
      if (timeFormat[timeIndex] === 'h' || timeFormat[timeIndex] === 'H' || timeFormat[timeIndex] === 's' || timeFormat[timeIndex] === 'm') {
        return timeIndex;
      }
    }

    return -1;
  }
  /**
   * Determines if the provided timeFormat starts with the time format.
   * @param {string} timeFormat
   * @returns {boolean} true if it start with a time, false otherwise
   */


  function isStartOfDateFormatTime(timeFormat) {
    if (!timeFormat) {
      return false;
    }

    var firstTimeCharacter = getIndexOfFirstTimeCharacter(timeFormat),
        firstDateCharacter = getIndexOfFirstDateCharacter(timeFormat);

    if (firstTimeCharacter === -1) {
      return false;
    } else if (firstDateCharacter === -1) {
      return true;
    } else {
      return firstDateCharacter > firstTimeCharacter;
    }
  }
  /**
   * Editor for working with `baja:AbsTime` values. Splits the date and time
   * parts of the `AbsTime` into two separate field editors, using whichever
   * default editor is registered on those two types.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/fe/baja/compat/CompositeAbsTimeEditor
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   */


  var CompositeAbsTimeEditor = function CompositeAbsTimeEditor(params) {
    BaseEditor.apply(this, arguments);
  };

  CompositeAbsTimeEditor.prototype = Object.create(BaseEditor.prototype);
  CompositeAbsTimeEditor.prototype.constructor = CompositeAbsTimeEditor;
  /**
   * Get the field editor for the date part.
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/BaseEditor}
   */

  CompositeAbsTimeEditor.prototype.$getDateEditor = function () {
    return Widget["in"](this.jq().children('.date'));
  };
  /**
   * Get the field editor for the time part.
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/BaseEditor}
   */


  CompositeAbsTimeEditor.prototype.$getTimeEditor = function () {
    return Widget["in"](this.jq().children('.time'));
  };
  /**
   * Get the "null" label.
   *
   * @private
   * @returns {JQuery}
   */


  CompositeAbsTimeEditor.prototype.$getNullLabel = function () {
    return this.jq().children('label');
  };
  /**
   * When a new value is loaded or the readonly status changes, update the DOM
   * so that it reads "null" if `baja.AbsTime.DEFAULT` is loaded and the editor
   * is readonly.
   */


  CompositeAbsTimeEditor.prototype.$updateNullReadonly = function () {
    var that = this,
        nullReadonly = that.isReadonly() && baja.AbsTime.DEFAULT.equals(that.value());
    that.jq().children('.date').toggle(!nullReadonly && this.$shouldShowDate());
    that.jq().children('.time').toggle(!nullReadonly && this.$shouldShowTime());
    that.$getNullLabel().toggle(nullReadonly);
  };
  /**
   * @private
   * @returns {boolean} true if properties are such that time should be shown
   */


  CompositeAbsTimeEditor.prototype.$shouldShowTime = function () {
    return this.properties().getValue('showTime') !== false;
  };
  /**
   * @private
   * @returns {boolean} true if properties are such that date should be shown
   */


  CompositeAbsTimeEditor.prototype.$shouldShowDate = function () {
    var props = this.properties();
    return props.getValue('showDate') !== false && !!getDateOnlyFormat(props.getValue('timeFormat') || DEFAULT_TIME_FORMAT);
  };
  /**
   * @private
   * @returns {boolean} true if properties are such that timezone should be shown
   */


  CompositeAbsTimeEditor.prototype.$shouldShowTimeZone = function () {
    var props = this.properties();
    var timeFormat = props.getValue('timeFormat');
    return props.getValue('showTimeZone') !== false && (!timeFormat || timeFormat.indexOf('z') !== -1);
  };
  /**
   * Updates the timezone displayed if timezone property set
   * @private
   * @param {baja.AbsTime} value
   */


  CompositeAbsTimeEditor.prototype.$updateDisplayedTimeZone = function (value) {
    var that = this,
        timezoneDisplay = '';
    return that.$resolveTimeZone().then(function (timezone) {
      if (timezone) {
        var isDst = dateTimeUtil.isDstActive(new Date(value.valueOf()), timezone);
        timezoneDisplay = timezone.getShortDisplayName(isDst);
      }

      that.jq().find(".timezone").text(timezoneDisplay);
    });
  };
  /**
   * Resolves the timezone for this editor.
   * @private
   * @returns {Promise.<module:baja/obj/TimeZone>}
   */


  CompositeAbsTimeEditor.prototype.$resolveTimeZone = function () {
    var timezoneString = this.properties().getValue(TIMEZONE_PROPERTY),
        propTimezone = timezoneString && baja.TimeZone.DEFAULT.decodeFromString(timezoneString),
        timezoneId = propTimezone && propTimezone.getId();

    if (!timezoneId) {
      timezoneId = dateTimeUtil.getEnvTimeZoneId();
    }

    if (timezoneId) {
      return baja.TimeZoneDatabase.get().then(function (database) {
        return database.getTimeZone(timezoneId);
      });
    } else {
      return Promise.resolve();
    }
  };
  /**
   * Initialize two field editors for the date and time part of the `AbsTime`.
   *
   * @param {JQuery} dom
   * @returns {Promise}
   */


  CompositeAbsTimeEditor.prototype.doInitialize = function (dom) {
    var that = this,
        props = that.properties(),
        showDate = this.$shouldShowDate(),
        showTime = this.$shouldShowTime(),
        showTimeZone = this.$shouldShowTimeZone(); // unlike CompositeTimeEditor, CompositeAbsTimeEditor's default is to
    // not show the seconds editor

    if (!props.getValue('showSeconds') && !props.getValue('showMilliseconds')) {
      props.add('showSeconds', false);
    }

    dom.on(MODIFY_EVENT, '.editor', function (event) {
      that.setModified(true);
      that.read().then(function (value) {
        return that.$updateDisplayedTimeZone(value);
      })["catch"](baja.error);
      return false;
    });
    dom.append('<label style="display:none;">null</label>');
    return Promise.all([that.makeChildFor({
      value: baja.Date.DEFAULT,
      properties: props,
      formFactor: 'mini'
    }), that.makeChildFor({
      value: baja.Time.DEFAULT,
      properties: props,
      formFactor: 'mini'
    })]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
          dateEd = _ref2[0],
          timeEd = _ref2[1];

      var dateDiv = $('<div class="date"/>'),
          timeDiv = $('<div class="time"/>'),
          timeZoneDiv = $('<div class="timezone"></div>'),
          timeFormat = props.getValue('timeFormat');

      if (isStartOfDateFormatTime(timeFormat)) {
        timeDiv.appendTo(dom);
        dateDiv.appendTo(dom);
      } else {
        dateDiv.appendTo(dom);
        timeDiv.appendTo(dom);
      }

      timeZoneDiv.appendTo(dom);

      if (!showDate) {
        dateDiv.hide();
      }

      if (!showTime) {
        timeDiv.hide();
      }

      if (!showTimeZone) {
        timeZoneDiv.hide();
      }

      return Promise.all([dateEd.initialize(dateDiv), timeEd.initialize(timeDiv)]);
    });
  };
  /**
   * Load the date and time part of the `AbsTime` into the two field editors.
   *
   * @param {baja.AbsTime} value
   * @returns {Promise}
   */


  CompositeAbsTimeEditor.prototype.doLoad = function (value) {
    this.$updateNullReadonly();
    return Promise.all([this.$getDateEditor().load(value.getDate()), this.$getTimeEditor().load(value.getTime()), this.$updateDisplayedTimeZone(value)]);
  };
  /**
   * Read the date and time editors and assemble their values into an `AbsTime`
   * instance.
   *
   * @returns {Promise} promise to be resolved with an `AbsTime`
   */


  CompositeAbsTimeEditor.prototype.doRead = function () {
    var value = this.value(),
        offset = value && value.getOffset() || 0;
    return Promise.all([this.$getDateEditor().read(), this.$getTimeEditor().read(), this.$resolveTimeZone()]).then(function (_ref3) {
      var _ref4 = _slicedToArray(_ref3, 3),
          date = _ref4[0],
          time = _ref4[1],
          timezone = _ref4[2];

      if (timezone) {
        var dstTestAbsTime = baja.AbsTime.make({
          date: date,
          time: time,
          offset: timezone.getUtcOffset()
        });
        offset = dateTimeUtil.getUtcOffsetInTimeZone(new Date(dstTestAbsTime.valueOf()), timezone) * 60000;
      }

      return baja.AbsTime.make({
        date: date,
        time: time,
        offset: offset
      });
    });
  };
  /**
   * Set child editors readonly/writable.
   *
   * @param {Boolean} readonly
   * @returns {Promise}
   */


  CompositeAbsTimeEditor.prototype.doReadonly = function (readonly) {
    this.$updateNullReadonly();
    return this.getChildEditors().setAllReadonly(readonly);
  };
  /**
   * Set child editors enabled/disabled.
   *
   * @param {Boolean} enabled
   * @returns {Promise}
   */


  CompositeAbsTimeEditor.prototype.doEnabled = function (enabled) {
    return this.getChildEditors().setAllEnabled(enabled);
  };
  /**
   * Destroy the child editors.
   *
   * @returns {Promise}
   */


  CompositeAbsTimeEditor.prototype.doDestroy = function () {
    return this.getChildEditors().destroyAll();
  };

  return CompositeAbsTimeEditor;
});
