/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author JJ Frankovich
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/UnmountedPasswordEditor
 */
define(['nmodule/webEditors/rc/fe/baja/PasswordEditor'], function (PasswordEditor) {
  'use strict';
  /**
   * A UnmountedPasswordEditor will provide a PasswordEditor for an unmounted component an won't attempt
   * to use RPC to save the password station side.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/PasswordEditor
   * @alias module:nmodule/webEditors/rc/fe/baja/UnmountedPasswordEditor
   */

  var UnmountedPasswordEditor = function UnmountedPasswordEditor(params) {
    var that = this;
    PasswordEditor.apply(that, arguments);
  };

  UnmountedPasswordEditor.prototype = Object.create(PasswordEditor.prototype);
  UnmountedPasswordEditor.prototype.constructor = UnmountedPasswordEditor;
  /**
   * Saving a `UnmountedPasswordEditor` doesn't do anything for saveToComplex.
   * @returns {undefined}
   */

  UnmountedPasswordEditor.prototype.saveToComplex = function () {
    //do not call super
    return undefined;
  };

  return UnmountedPasswordEditor;
});
