function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/TypeSpecEditor
 */
define(['baja!', 'log!nmodule.webEditors.rc.fe.baja.TypeSpecEditor', 'jquery', 'Promise', 'underscore', 'bajaux/events', 'bajaux/mixin/batchLoadMixin', 'nmodule/webEditors/rc/fe/BaseWidget', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/baja/util/typeUtils', 'nmodule/webEditors/rc/servlets/registry', 'nmodule/webEditors/rc/wb/options/MruButton', 'nmodule/webEditors/rc/wb/options/MruOptions'], function (baja, log, $, Promise, _, events, batchLoadMixin, BaseWidget, OrderedMapEditor, BaseEditor, typeUtils, registry, MruButton, MruOptions) {
  'use strict';

  var MODIFY_EVENT = events.MODIFY_EVENT,
      VALUE_READY_EVENT = BaseWidget.VALUE_READY_EVENT,
      importTypes = typeUtils.importTypes,
      toTypeSpec = typeUtils.toTypeSpec,
      logError = log.severe.bind(log),
      ALLOW_NULL_FACET = 'allowNull',
      NULL_TYPE_SPEC = toTypeSpec('null'),
      SHOW_ABSTRACT_FACET = 'showAbstract',
      SHOW_INTERFACE_FACET = 'showInterface',
      TARGET_TYPE_FACET = 'targetType',
      MRU_NAME = 'typeSpecFE';
  /**
   * Retrieves a list of all modules from the server and resolves it as a
   * `baja.OrderedMap`.
   *
   * @inner
   * @param {Object} params parameters to be sent to the module list servlet
   * @param {Boolean} [allowBlank] true if blank should be a valid type spec
   * to select
   * @returns {Promise} promise to be resolved with a `baja.OrderedMap`
   * containing the requested modules
   */

  function getAllModulesAsOrderedMap(params, allowBlank) {
    return registry.getModules(params).then(function (list) {
      var map = new baja.OrderedMap();

      if (allowBlank) {
        map.put('', undefined);
      }

      _.each(list, function (item) {
        map.put(item.m, item);
      });

      return map;
    });
  }
  /**
   * Retrieves a list of types from the server and resolves it as a
   * `baja.OrderedMap`.
   *
   * @inner
   * @param {String} module the module whose types we want
   * @param {Object} params parameters for the type query (`showAbstract`,
   * `showInterface`, `targetType`)
   * @param {baja.comm.Batch} [params.batch]
   * @returns {Promise} promise to be resolved with a `baja.OrderedMap`
   * containing the requested types, or `undefined` if no module specified
   */


  function getTypesAsOrderedMap(module, params) {
    if (!module || module === 'null') {
      return Promise.resolve();
    }

    return registry.getTypes(_.extend(params, {
      modules: [module]
    })).then(function (types) {
      var map = new baja.OrderedMap();

      _.each(types, function (item) {
        map.put(item.type.split(':')[1], item.type);
      });

      return map;
    });
  }

  function getRequestParams(ed) {
    var props = ed.properties(),
        showInterface = props.getValue(SHOW_INTERFACE_FACET),
        showAbstract = props.getValue(SHOW_ABSTRACT_FACET) || false,
        targetType = props.getValue(TARGET_TYPE_FACET),
        params = {
      withTypesOnly: true,
      showInterface: showInterface,
      showAbstract: showAbstract
    };

    if (targetType) {
      params.targetType = targetType;
    } //TODO: mruAutoSave


    return params;
  }
  /**
   * A field editor for working with `TypeSpec`s. Retrieves modules and types
   * down from the server and presents them to the user as dropdowns for
   * selection.
   *
   * Supports the following Properties:
   *
   * - `allowNull`: set to `true` to allow a null type spec to be selected
   *   (default: `false`)
   * - `showAbstract`: set to `false` to exclude abstract types from the list
   *   (default: `false`)
   * - `showInterface`: set to `false` to exclude interfaces from the list
   *   (default: `true`)
   * - `targetType`: set to a type spec (String) to only show types that are
   *   a subtype of that type
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/StringEditor
   * @alias module:nmodule/webEditors/rc/fe/baja/TypeSpecEditor
   */


  var TypeSpecEditor = function TypeSpecEditor(params) {
    var that = this;
    BaseEditor.call(that, $.extend({
      keyName: 'TypeSpecEditor'
    }, params));
    that.on(VALUE_READY_EVENT, function (typeSpec) {
      return that.$saveMru(typeSpec);
    });
  };

  TypeSpecEditor.prototype = Object.create(BaseEditor.prototype);
  TypeSpecEditor.prototype.constructor = TypeSpecEditor;
  /**
   * Get the jQuery element containing the module selector.
   * @private
   * @returns {jQuery}
   */

  TypeSpecEditor.prototype.$getModuleElement = function () {
    return this.jq().children('.module');
  };
  /**
   * Get the jQuery element containing the type selector.
   * @private
   * @returns {jQuery}
   */


  TypeSpecEditor.prototype.$getTypeElement = function () {
    return this.jq().children('.type');
  };
  /**
   * Get the jQuery element containing the "use null" checkbox.
   * @private
   * @returns {*}
   */


  TypeSpecEditor.prototype.$getNullElement = function () {
    return this.jq().children('.isNull');
  };
  /**
   * Get the `OrderedMapEditor` used to select the module.
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/OrderedMapEditor}
   */


  TypeSpecEditor.prototype.$getModuleEditor = function () {
    return this.$getModuleElement().data('widget');
  };
  /**
   * Get the `OrderedMapEditor` used to select the type.
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/OrderedMapEditor}
   */


  TypeSpecEditor.prototype.$getTypeEditor = function () {
    return this.$getTypeElement().data('widget');
  };
  /**
   * Get the `BooleanEditor` used to select a null type spec.
   * @private
   * @returns {*}
   */


  TypeSpecEditor.prototype.$getNullEditor = function () {
    return this.$getNullElement().data('widget');
  };
  /**
   * Return true if this editor should allow a null type spec to be selected.
   * @private
   * @returns {Boolean}
   */


  TypeSpecEditor.prototype.$isAllowNull = function () {
    return this.properties().getValue(ALLOW_NULL_FACET);
  };
  /**
   * Set the desired module as selected in the module list. Will then retrieve
   * a list of types for that module and load them asynchronously into the
   * type editor.
   *
   * @private
   * @param {String} module The module name from the type spec currently
   * being loaded. This might be "null" if loading a null type spec,
   * in which case no types will be retrieved and the type editor will not be
   * touched.
   * @param {String} [selectedKey] the desired key to be selected in the type
   * list. This should be the type name (Component), not the full type spec
   * (baja:Component).
   * @returns {Promise} promise to be resolved when the module is
   * selected and the list of types has been retrieved from the server and
   * loaded
   */


  TypeSpecEditor.prototype.$setSelectedModule = function (module, selectedKey) {
    return this.$setTypeMap(getTypesAsOrderedMap(module, getRequestParams(this)), selectedKey);
  };
  /**
   * Set the current set of available types.
   *
   * @private
   * @param {baja.OrderedMap|Promise} typeMap an OrderedMap of type specs
   * (as returned by `getTypesAsOrderedMap`, or promise to be resolved with
   * same. If the promise rejects (e.g. for an unknown module), this will reload
   * the type dropdown with the types from the first module in the module
   * dropdown.
   * @param {String} selectedKey the type name to preselect
   * @returns {Promise} promise to be resolved when the list of types has been
   * fully loaded into the dropdown
   */


  TypeSpecEditor.prototype.$setTypeMap = function (typeMap, selectedKey) {
    var that = this,
        typeEditor = that.$getTypeEditor();
    return Promise.all([typeMap, typeEditor.load(new baja.OrderedMap())]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 1),
          typeMap = _ref2[0];

      return typeMap && typeEditor.load(typeMap, {
        selectedKey: selectedKey
      });
    })["catch"](function () {
      //the requested module was not found (probably due to migrating
      //a station - so just load the types for the first module in the list
      var modules = that.$getModuleEditor().value(),
          first = modules.get(modules.getKeys()[0]).m;
      return that.$setSelectedModule(first);
    });
  };
  /**
   * Updates enabled status of the module/type dropdowns based on whether
   * the "use null" checkbox is checked.
   *
   * @private
   * @returns {Promise}
   */


  TypeSpecEditor.prototype.$updateDropdowns = function () {
    var that = this;

    if (!that.isEnabled() || that.isReadonly()) {
      return Promise.resolve();
    }

    return Promise.resolve(that.$isAllowNull() && that.$getNullEditor().read()).then(function (isNull) {
      return Promise.all([that.$getModuleEditor().setEnabled(!isNull), that.$getTypeEditor().setEnabled(!isNull)]);
    });
  };
  /**
   * @private
   * @returns {module:nmodule/webEditors/rc/wb/options/MruButton}
   */


  TypeSpecEditor.prototype.$getMruButton = function () {
    return this.jq().children('.mru').data('widget');
  };
  /**
   * Build an `MruButton` for this `TypeSpecEditor`.
   * @private
   * @param {module:nmodule/webEditors/rc/wb/options/MruOptions} options
   * @param {jQuery} dom element where the `MruButton` goes
   * @returns {Promise}
   */


  TypeSpecEditor.prototype.$buildMruButton = function (options, dom) {
    var that = this,
        select = function select(str) {
      return that.load(toTypeSpec(str));
    };

    return that.buildChildFor({
      value: {
        options: options,
        select: select
      },
      type: MruButton,
      dom: dom
    });
  };
  /**
   * Instantiates `OrderedMapEditor`s for the module and type lists, retrieves
   * the module list from the server and loads it in. Arms event handlers to
   * ensure that the type list gets updated whenever a new module is selected.
   *
   * @param {JQuery} dom
   * @returns {Promise}
   */


  TypeSpecEditor.prototype.doInitialize = function (dom) {
    var that = this,
        moduleEditor = new OrderedMapEditor({
      properties: {
        sortKeys: true
      }
    }),
        typeEditor = new OrderedMapEditor({
      properties: {
        sortKeys: true
      }
    });
    dom.on(MODIFY_EVENT, '.module', function () {
      that.$setSelectedModule(moduleEditor.getSelectedKey()).then(function () {
        return that.setModified(true) || null;
      })["catch"](logError);
      return false;
    });
    dom.on(MODIFY_EVENT, '.type', function () {
      that.setModified(true);
      return false;
    });
    dom.on(MODIFY_EVENT, '.isNull', function () {
      that.$updateDropdowns()["catch"](logError);
      that.setModified(true);
      return false;
    });
    return Promise.all([getAllModulesAsOrderedMap(getRequestParams(that)), that.buildChildFor({
      value: false,
      dom: $('<span class="isNull"/>').css('display', that.$isAllowNull() ? '' : 'none').appendTo(dom),
      properties: {
        trueText: 'null',
        falseText: 'null'
      },
      formFactor: 'mini'
    }), moduleEditor.initialize($('<span class="module"/>').appendTo(dom)), typeEditor.initialize($('<span class="type"/>').appendTo(dom)), !baja.isOffline() && MruOptions.make(MRU_NAME).then(function (options) {
      return that.$buildMruButton(options, $('<span class="mru"/>').appendTo(dom));
    })]).then(function (_ref3) {
      var _ref4 = _slicedToArray(_ref3, 1),
          moduleMap = _ref4[0];

      return moduleEditor.load(moduleMap);
    });
  };
  /**
   * Set the selected values in the module and type selectors to reflect the
   * given type spec. Accepts a raw String type spec or the BajaScript
   * representation of it (currently a `baja.DefaultSimple`).
   *
   * @param {baja.String|baja.DefaultSimple} typeSpec
   * @param {Object} [params]
   * @param {baja.comm.Batch} [params.batch]
   * @returns {Promise}
   */


  TypeSpecEditor.prototype.doLoad = function (typeSpec, params) {
    if (!baja.hasType(typeSpec, 'baja:TypeSpec')) {
      throw new Error('TypeSpec required');
    }

    var that = this,
        allowNull = that.$isAllowNull(),
        split = String(typeSpec).split(':'),
        module = split[0],
        type = split[1],
        moduleEditor = that.$getModuleEditor(),
        nullEditor = that.$getNullEditor(),
        batch = params && params.batch,
        progressCallback = params && params.progressCallback,
        requestParams = _.extend(getRequestParams(that), {
      batch: batch
    }),
        typeMap = getTypesAsOrderedMap(module, requestParams),
        //may resolve or reject
    getModules = getAllModulesAsOrderedMap(requestParams, module === 'null');

    if (progressCallback) {
      progressCallback(batchLoadMixin.COMMIT_READY);
    }

    return getModules.then(function (modules) {
      return moduleEditor.load(modules);
    }).then(function () {
      if (allowNull && String(typeSpec) === 'null') {
        return nullEditor.load(true).then(function () {
          return that.$updateDropdowns();
        });
      } else {
        return Promise.all([nullEditor.load(false), module !== 'null' && moduleEditor.$getSelect().val(module), that.$setTypeMap(typeMap, type)]).then(function () {
          return that.$updateDropdowns();
        });
      }
    });
  };
  /**
   * Reads the contents of the module and type selectors, imports that type
   * spec using BajaScript, and resolves it.
   *
   * @returns {Promise} promise to be resolved with the imported type
   * spec, or rejected if the string in the text field is not a valid Type
   */


  TypeSpecEditor.prototype.doRead = function () {
    return Promise.all([this.$getNullEditor().read(), this.$getTypeEditor().read()]).then(function (_ref5) {
      var _ref6 = _slicedToArray(_ref5, 2),
          isNull = _ref6[0],
          type = _ref6[1];

      if (isNull || !type) {
        return NULL_TYPE_SPEC;
      }

      return importTypes(type).then(function () {
        return toTypeSpec(type);
      });
    });
  };

  TypeSpecEditor.prototype.$saveMru = function (typeSpec) {
    var that = this;

    if (baja.isOffline()) {
      return Promise.resolve();
    }

    return MruOptions.make(MRU_NAME).then(function (mru) {
      mru.add(typeSpec.encodeToString());
      return Promise.all([mru.save(), that.$getMruButton().setOptions(mru)]);
    });
  };
  /**
   * When this editor is saved, add the selected type spec to the TypeSpecEditor
   * MRU history.
   * @param {baja.DefaultSimple} typeSpec
   * @returns {Promise}
   */


  TypeSpecEditor.prototype.doSave = function (typeSpec) {
    return this.$saveMru(typeSpec);
  };
  /**
   * Enables/disables null editor and dropdowns.
   *
   * @param {Boolean} enabled
   * @returns {Promise}
   */


  TypeSpecEditor.prototype.doEnabled = function (enabled) {
    return this.getChildEditors().setAllEnabled(enabled);
  };
  /**
   * Readonlies/writables null editor and dropdowns.
   *
   * @param {Boolean} readonly
   * @returns {Promise}
   */


  TypeSpecEditor.prototype.doReadonly = function (readonly) {
    return this.getChildEditors().setAllReadonly(readonly);
  };
  /**
   * Destroy child editors.
   *
   * @returns {Promise}
   */


  TypeSpecEditor.prototype.doDestroy = function () {
    return this.getChildEditors().destroyAll();
  };

  return TypeSpecEditor;
});
