function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/TypeConfigEditor
 */
define(['baja!', 'log!nmodule.webEditors.rc.fe.baja.TypeConfigEditor', 'bajaux/events', 'jquery', 'Promise', 'underscore', 'nmodule/js/rc/switchboard/switchboard', 'nmodule/webEditors/rc/fe/baja/util/typeUtils', 'nmodule/webEditors/rc/wb/PropertySheet', 'nmodule/webEditors/rc/wb/PropertySheetRow', 'nmodule/webEditors/rc/servlets/typeConfig'], function (baja, log, events, $, Promise, _, switchboard, typeUtils, PropertySheet, PropertySheetRow, typeConfig) {
  'use strict';

  var getConfigurableInfo = typeConfig.getConfigurableInfo,
      getTypeConfigInfo = typeConfig.getTypeConfigInfo;
  var importTypes = typeUtils.importTypes,
      toTypeSpec = typeUtils.toTypeSpec;
  var MODIFY_EVENT = events.MODIFY_EVENT;
  var logError = log.severe.bind(log);
  var NULL_CONFIG = {
    config: []
  };
  /**
   * Editor for working with `TypeConfig`s. As of 8/25/2014 it works just barely
   * well enough to handle web profiles in the user manager and as such should
   * be considered private, probably-broken API.
   *
   * It makes use of two station-side services:
   *
   * - `com.tridium.webeditors.servlets.TypeConfigServlet`: for retrieving
   *   information about `TypeConfig` and `IConfigurable` classes that are not
   *   supported in BajaScript directly.
   * - `com.tridium.webeditors.ssc.BTypeConfigSSCHandler': for saving changes.
   *   The `IConfigurable` data will be sent to the station packaged in a
   *   `BComponent` and applied to the `TypeConfig` using `syncFrom`.
   *   Theoretically, this should work with other `BTypeConfig`s that use the
   *   default implementation of `syncFrom`, by my confidence level is low.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/fe/baja/TypeConfigEditor
   * @extends module:nmodule/webEditors/rc/wb/PropertySheet
   */

  var TypeConfigEditor = /*#__PURE__*/function (_PropertySheet) {
    _inherits(TypeConfigEditor, _PropertySheet);

    var _super = _createSuper(TypeConfigEditor);

    function TypeConfigEditor(params) {
      var _this;

      _classCallCheck(this, TypeConfigEditor);

      _this = _super.call(this, $.extend(true, {
        module: 'webEditors',
        keyName: 'TypeConfigEditor'
      }, params));
      switchboard(_assertThisInitialized(_this), {
        '$getConfigForIConfigurable': {
          allow: 'oneAtATime',
          onRepeat: 'queue'
        },
        'read': {
          notWhile: '$rebuild',
          onRepeat: 'queue'
        }
      });
      /**
       * The default type spec to use when the loaded TypeConfig does not have
       * a type spec specified (e.g. it's a brand new TypeConfig like
       * `baja.$('web:WebProfileConfig')`). Defaults to null, which will not work -
       * but will be retrieved from the servlet in `$preloadTypeConfigInfo`.
       *
       * @private
       * @field
       * @type baja.Value
       */

      _this.$defaultType = toTypeSpec('null');
      return _this;
    }
    /**
     * Ensure that all slots and config keys are shown and made editable whenever
     * a new `IConfigurable` type spec is chosen.
     *
     * @param {JQuery} dom
     * @returns {Promise}
     */


    _createClass(TypeConfigEditor, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this2 = this;

        dom.on(MODIFY_EVENT, '.slot-typeSpec', function () {
          _this2.$rebuild()["catch"](logError);
        });
        return PropertySheet.prototype.doInitialize.apply(this, arguments);
      }
      /**
       * Load editors for all slots and config keys for the given `TypeConfig`.
       *
       * @param {baja.Component} value the `baja:TypeConfig` to load
       * @returns {Promise}
       */

    }, {
      key: "doLoad",
      value: function doLoad(value) {
        var _this3 = this;

        return this.$preloadTypeConfigInfo().then(function () {
          // NCCB-37571: preload the type spec slot on a second load. otherwise
          // we'll be retrieving the type config info for the previously loaded
          // type config. see $getConfigForIConfigurable/$getLoadedType.
          var typeSpecEd = _this3.$getTypeSpecEditor();

          return typeSpecEd && typeSpecEd.load(value.get('typeSpec'));
        }).then(function () {
          return PropertySheet.prototype.doLoad.call(_this3, value);
        }).then(function () {
          var typeSpecEd = _this3.$getTypeSpecEditor();

          return validateTypeSpec(typeSpecEd.value()).then(function (valid) {
            if (!valid) {
              return typeSpecEd.load(toTypeSpec(_this3.$defaultType));
            }
          });
        });
      }
      /**
       * Resolve a new `TypeConfig` instance of the same type as the one currently
       * loaded, with all current keys applied to it.
       *
       * @returns {Promise}
       */

    }, {
      key: "doRead",
      value: function doRead() {
        return this.$applyKeysToConfig(baja.$(this.value().getType()));
      }
      /**
       * Apply entered type config values to the loaded TypeConfig.
       *
       * @returns {Promise}
       */

    }, {
      key: "doSave",
      value: function doSave() {
        return this.$applyKeysToConfig(this.value(), true);
      }
      /**
       * Create the `CompositeBuilder` for the `TypeConfigEditor`. This builder
       * will assemble its sub-editors by calling out for information about the
       * currently loaded `TypeConfig` and `IConfigurable` classes, as necessary.
       *
       * @returns {module:nmodule/webEditors/rc/fe/config/ComplexCompositeBuilder}
       */

    }, {
      key: "makeBuilder",
      value: function makeBuilder() {
        var _this4 = this;

        var builder = PropertySheet.prototype.makeBuilder.apply(this, arguments),
            getConfigFor = builder.getConfigFor,
            getDisplayNameFor = builder.getDisplayNameFor,
            getIconFor = builder.getIconFor,
            $loadFor = builder.$loadFor;
        /**
         * All frozen slots on the `TypeConfig`, plus all config keys from the
         * currently selected `IConfigurable`.
         *
         * @returns {Promise} promise to be resolved with an array of keys
         */

        builder.getKeys = function () {
          var typeConfig = builder.getDataSource();
          return _this4.$getConfigForIConfigurable().then(function (obj) {
            var frozenNames = typeConfig.getSlots().frozen().toArray().map(String),
                configNames = _.map(obj.config, _.property('key'));

            return frozenNames.concat(configNames);
          });
        };
        /**
         * For slots from the `TypeConfig`, use the typical `PropertySheet` editor
         * config. Since `PropertySheet` doesn't deal with arbitrary keys from
         * `IConfigurable`s, configure these editors using information from
         * `TypeConfigServlet`.
         *
         * @param {String} key
         * @returns {Promise} promise to be resolved with a config object
         */


        builder.getConfigFor = function (key) {
          var typeConfig = builder.getDataSource();

          if (typeConfig.has(key) && typeConfig.getSlot(key).isFrozen()) {
            return getConfigFor.call(builder, key);
          }

          return _this4.$getConfigObject(key).then(function (obj) {
            return _.extend(_.omit(obj, 'facets'), {
              type: PropertySheetRow,
              data: {
                builder: builder,
                key: key
              },
              properties: _.extend(obj.facets.toObject(), {
                alt: _this4.properties().getValue('alt')
              })
            });
          });
        };
        /**
         * Use the slot display name if the `TypeConfig` has that slot; otherwise
         * use the display name from the `TypeConfigServlet`.
         *
         * @param {String} key
         * @returns {Promise} promise to be resolved with a display name
         */


        builder.getDisplayNameFor = function (key) {
          var typeConfig = builder.getDataSource();

          if (typeConfig.has(key) && typeConfig.getSlot(key).isFrozen()) {
            return getDisplayNameFor.call(builder, key);
          }

          return _this4.$getConfigObject(key).then(function (obj) {
            return obj && obj.displayName;
          });
        };
        /**
         * Use the slot icon if the `TypeConfig` has that slot; otherwise use the
         * icon from the default value provided by the `TypeConfigServlet`.
         *
         * @param {String} key
         * @returns {Promise} promise to be resolved with an icon URI
         */


        builder.getIconFor = function (key) {
          var typeConfig = builder.getDataSource();

          if (typeConfig.has(key)) {
            return getIconFor.call(builder, key);
          }

          return _this4.$getConfigObject(key).then(function (obj) {
            return obj && obj.value.getType().getIcon().getImageUris()[0];
          });
        };
        /**
         * Use the slot value if the `TypeConfig` has that slot; otherwise use the
         * default value from the `TypeConfigServlet`.
         *
         * @param {String} key
         * @returns {Promise} promise to be resolved with a value to load
         */


        builder.getValueFor = function (key) {
          var typeConfig = builder.getDataSource();

          if (typeConfig.has(key)) {
            return Promise.resolve(typeConfig.get(key));
          }

          return _this4.$getConfigObject(key).then(function (obj) {
            return obj && obj.value;
          });
        }; // TODO: why does BTypeConfig need to do this in the first place?
        // TODO: perhaps a "don't overwrite modified editors" flag to CompositeBuilder

        /**
         * `BTypeConfig#syncFrom` ensures that all values applied from the
         * `IConfigurable` get the READONLY flag. `BTypeConfigFE` then ignores this
         * flag and makes everything editable.
         *
         * This is dumb. But ensure that these editors get flipped from readonly
         * (from the flag) back to writable.
         *
         * @private
         * @param key
         * @returns {*}
         */


        builder.$loadFor = function (key) {
          return Promise.resolve($loadFor.call(builder, key)).then(function () {
            var typeConfig = builder.getDataSource();
            var ed = builder.getEditorFor(key);
            return ed && ed.setReadonly(isReadonly(typeConfig));
          });
        };

        return builder;
      } // TODO: TypeSpecEditor could be condensed to a single dropdown

      /**
       * All slots should be shown and edited. The `typeSpec` slot will get the
       * appropriate faces to limit selectable types to the target type.
       *
       * @returns {Function}
       */

    }, {
      key: "getSlotFilter",
      value: function getSlotFilter() {
        var _this5 = this;

        return function (slot) {
          if (slot.getName() === 'typeSpec') {
            return {
              properties: {
                targetType: _this5.$targetType,
                showAbstract: false,
                showInterface: false
              }
            };
          }

          return true;
        };
      }
      /**
       * Get the currently-loaded target type (the `IConfigurable` type spec to
       * set on the `TypeConfig`'s `typeSpec` slot). If none has yet been loaded,
       * fall back to an existing default type spec.
       *
       * @private
       * @param {baja.Simple} defaultType the `baja:TypeSpec` to fall back to
       * @returns {Promise} promise to be resolved with the target type
       * spec
       */

    }, {
      key: "$getLoadedType",
      value: function $getLoadedType(defaultType) {
        var _this6 = this;

        var ed = this.$getTypeSpecEditor(),
            enteredValue = ed && !ed.$loading && ed.value();
        return validateTypeSpec(enteredValue).then(function (valid) {
          return valid ? ed.read() : validateTypeSpec(defaultType).then(function (valid) {
            return valid ? defaultType : _this6.$defaultType;
          });
        });
      }
      /**
       * @private
       * @returns {module:nmodule/webEditors/rc/fe/baja/TypeSpecEditor}
       */

    }, {
      key: "$getTypeSpecEditor",
      value: function $getTypeSpecEditor() {
        return this.getBuilder().getEditorFor('typeSpec');
      }
      /**
       * Preload information about the loaded `TypeConfig` by calling out to the
       * `TypeConfigServlet`, and set as instance variables on the
       * `TypeConfigEditor`:
       *
       * - `$defaultType`: the default type to choose for the `typeSpec` slot, if
       *   none is currently set
       * - `$targetType`: restrict user choices for the `typeSpec` slot to only
       *   subclasses of this Type
       *
       * @private
       * @returns {Promise} promise to be resolved after info is preloaded
       */

    }, {
      key: "$preloadTypeConfigInfo",
      value: function $preloadTypeConfigInfo() {
        var _this7 = this;

        return getTypeConfigInfo(this.value().getType()).then(function (config) {
          _this7.$defaultType = toTypeSpec(config.defaultType);
          _this7.$targetType = config.targetType;
        });
      }
      /**
       * Retrieve information about the given key as reported by the currently
       * selected `IConfigurable`. Resolved object will have `key`, `displayName`,
       * `properties`, and `value` properties, suitable for passing to `makeFor`.
       *
       * @private
       * @param {String} key
       * @returns {Promise} promise to be resolved with a config object
       */

    }, {
      key: "$getConfigObject",
      value: function $getConfigObject(key) {
        return this.$getConfigForIConfigurable().then(function (obj) {
          return getByKey(obj.config, key);
        });
      }
      /**
       * Call out to the station, if necessary, to retrieve information about
       * the currently selected type spec. (Currently, this will blow up if the
       * selected type spec does not implement `IConfigurable`.)
       *
       * Afterwards, `$getConfigObject` for the given `IConfigurable` key will
       * resolve an object.
       *
       * @private
       * @returns {Promise} promise to be resolved with an object containing
       * all information about the currently selected `IConfigurable` type
       */

    }, {
      key: "$getConfigForIConfigurable",
      value: function $getConfigForIConfigurable() {
        var _this8 = this;

        var typeConfig = this.getBuilder().getDataSource();
        return this.$getLoadedType(typeConfig.get('typeSpec')).then(function (configurableSpec) {
          if (isNull(configurableSpec)) {
            return NULL_CONFIG;
          }

          configurableSpec = String(configurableSpec);

          if (_this8.$configurableTypeSpec === configurableSpec) {
            return _this8.$configurableConfig;
          }

          _this8.$configurableTypeSpec = configurableSpec;
          return getConfigurableInfo(typeConfig.getType(), configurableSpec).then(function (obj) {
            _this8.$configurableConfig = obj;
            return obj;
          });
        });
      }
      /**
       * Read currently entered values for all type config keys, then apply them
       * to the given TypeConfig. (This can be a new unmounted copy for a read, or
       * a mounted TypeConfig for a save.) Any keys currently on the TypeConfig,
       * that do not exist in the editor, will be removed from the TypeConfig.
       *
       * @private
       * @param {baja.Complex} config a `baja:TypeConfig`
       * @param {Boolean} [unmodify] set to true if child editors should be marked
       * as unmodified after applying values
       * @returns {Promise} promise to be resolved with the same `TypeConfig`
       * instance as passed in, with all keys written onto it
       */

    }, {
      key: "$applyKeysToConfig",
      value: function $applyKeysToConfig(config, unmodify) {
        var builder = this.getBuilder();
        return Promise.all([builder.getKeys(), this.$getConfigForIConfigurable()]).then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 2),
              keys = _ref2[0],
              configObject = _ref2[1];

          var editors = keys.map(function (key) {
            return builder.getEditorFor(key);
          });
          var displayNames = keys.map(function (key) {
            return (getByKey(configObject.config, key) || {}).displayName;
          });
          return Promise.all(editors.map(function (ed) {
            return ed.read();
          })).then(function (values) {
            var batch = new baja.comm.Batch(); //don't use Promise.all here - need this to run synchronously
            //so the batch can be safely committed below

            var sets = values.map(function (value, i) {
              var key = keys[i],
                  has = config.has(key);
              return config[has ? 'set' : 'add']({
                slot: key,
                value: value,
                flags: has ? 0 : baja.Flags.READONLY,
                cx: {
                  displayName: displayNames[i]
                },
                batch: batch
              }).then(function () {
                return unmodify && editors[i].setModified(false);
              });
            });
            return batch.commit(Promise.all([Promise.all(sets), removeAllUnknown(config, keys, batch)]));
          });
        }).then(function () {
          return config;
        });
      }
      /**
       * Rebuild editors for all keys except typeSpec (because this rebuild will
       * be triggered by a change to typeSpec in the first place).
       *
       * @private
       * @returns {Promise}
       */

    }, {
      key: "$rebuild",
      value: function $rebuild() {
        var builder = this.getBuilder();
        return Promise.all([builder.getKeys(), builder.$prune()]).then(function (_ref3) {
          var _ref4 = _slicedToArray(_ref3, 1),
              keys = _ref4[0];

          return Promise.all(_.without(keys, 'typeSpec').map(function (key) {
            var ed = builder.getEditorFor(key);

            if (!(ed && ed.isModified())) {
              return builder.$loadFor(key);
            }
          }));
        });
      }
    }]);

    return TypeConfigEditor;
  }(PropertySheet);

  function getByKey(config, key) {
    for (var i = 0; i < config.length; i++) {
      if (config[i].key === key) {
        return config[i];
      }
    }
  }

  function isNull(typeSpec) {
    return !typeSpec || String(typeSpec) === 'null';
  }

  function removeAllUnknown(comp, keys, batch) {
    return Promise.all(comp.getSlots().toArray().map(function (slot) {
      return keys.indexOf(slot.getName()) < 0 && comp.remove({
        slot: slot,
        batch: batch
      });
    }));
  }
  /**
   * Resolve true if the type spec represents a valid baja Type. Resolve false
   * if invalid or null.
   *
   * @param typeSpec
   * @returns {Promise}
   */


  function validateTypeSpec(typeSpec) {
    if (isNull(typeSpec)) {
      return Promise.resolve(false);
    }

    return importTypes(String(typeSpec)).then(function () {
      return true;
    })["catch"](function () {
      return false;
    });
  }
  /**
   * This is how BTypeConfigFE does it. All slots on a BTypeConfig are readonly
   * except `typeSpec` (frozen slot) which respects actual write permissions.
   * @param {baja.Component} typeConfig
   * @returns {boolean}
   */


  function isReadonly(typeConfig) {
    var flags = typeConfig.getFlags('typeSpec');
    var _baja$Flags = baja.Flags,
        READONLY = _baja$Flags.READONLY,
        HIDDEN = _baja$Flags.HIDDEN; // noinspection JSBitwiseOperatorUsage

    return !!(flags & READONLY || flags & HIDDEN);
  }

  return TypeConfigEditor;
});
