/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/TimeZoneEditor
 */
define(['baja!', 'bajaux/events', 'jquery', 'underscore', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor'], function (baja, events, $, _, fe, BaseEditor, OrderedMapEditor) {
  'use strict';

  var MODIFY_EVENT = events.MODIFY_EVENT,
      zonesMap;

  function toOrderedMap(tzDb) {
    if (!zonesMap) {
      var zones = [baja.TimeZone.NULL].concat(sortTimeZones(tzDb.getTimeZones()));
      zonesMap = new baja.OrderedMap();

      _.each(zones, function (zone) {
        zonesMap.put(String(zone), zone);
      });
    }

    return zonesMap;
  }

  function sortTimeZones(zones) {
    return zones.sort(function (a, b) {
      var offsetA = a.getUtcOffset(),
          offsetB = b.getUtcOffset();

      if (offsetA === offsetB) {
        return a.getId() < b.getId() ? -1 : 1;
      } else {
        return offsetA < offsetB ? -1 : 1;
      }
    });
  }
  /**
   * Editor for working with `baja:TimeZone` values.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/webEditors/rc/fe/baja/TimeZoneEditor
   */


  var TimeZoneEditor = function TimeZoneEditor(params) {
    BaseEditor.apply(this, arguments);
  };

  TimeZoneEditor.prototype = Object.create(BaseEditor.prototype);
  TimeZoneEditor.prototype.constructor = TimeZoneEditor;
  /**
   * Get the `OrderedMapEditor` containing all time zones.
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/OrderedMapEditor}
   */

  TimeZoneEditor.prototype.$getOrderedMapEditor = function () {
    return this.jq().children().data('widget');
  };
  /**
   * Initialize a dropdown containing all time zones for the user to choose
   * from.
   *
   * @param {JQuery} dom
   * @returns {Promise}
   */


  TimeZoneEditor.prototype.doInitialize = function (dom) {
    var that = this;
    dom.on(MODIFY_EVENT, '.editor', function () {
      that.setModified(true);
      return false;
    });
    return baja.TimeZoneDatabase.get().then(toOrderedMap).then(function (map) {
      return fe.buildFor({
        dom: $('<div/>').appendTo(dom),
        type: OrderedMapEditor,
        value: map
      });
    });
  };
  /**
   * Set the selected time zone in the dropdown.
   *
   * @param {baja.TimeZone} zone
   */


  TimeZoneEditor.prototype.doLoad = function (zone) {
    return this.$getOrderedMapEditor().setSelectedKey(String(zone),
    /* silent */
    true);
  };
  /**
   * Resolve the currently selected time zone from the dropdown.
   *
   * @returns {Promise}
   */


  TimeZoneEditor.prototype.doRead = function () {
    return this.$getOrderedMapEditor().read();
  };
  /**
   * Destroy all child editors.
   *
   * @returns {Promise}
   */


  TimeZoneEditor.prototype.doDestroy = function () {
    return this.getChildEditors().destroyAll();
  };
  /**
   * Set all child editors readonly/writable.
   *
   * @param {Boolean} readonly
   * @returns {Promise}
   */


  TimeZoneEditor.prototype.doReadonly = function (readonly) {
    return this.getChildEditors().setAllReadonly(readonly);
  };
  /**
   * Set all child editors enabled/disabled.
   *
   * @param {Boolean} enabled
   * @returns {Promise}
   */


  TimeZoneEditor.prototype.doEnabled = function (enabled) {
    return this.getChildEditors().setAllEnabled(enabled);
  };

  TimeZoneEditor.$sortTimeZones = sortTimeZones;
  return TimeZoneEditor;
});
