/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/TimeRangeEditor
 */
define(['underscore', 'nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor'], function (_, ComplexCompositeEditor) {
  'use strict';
  /**
   * Editor for a `TimeRange`.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor
   * @alias module:nmodule/webEditors/rc/fe/baja/TimeRangeEditor
   */

  var TimeRangeEditor = function TimeRangeEditor(params) {
    ComplexCompositeEditor.call(this, _.extend({
      keyName: 'TimeRangeEditor'
    }, params));
  };

  TimeRangeEditor.prototype = Object.create(ComplexCompositeEditor.prototype);
  TimeRangeEditor.prototype.constructor = TimeRangeEditor;
  /**
   * Use slots `startTime` and `endTime`.
   *
   * @returns {Array}
   */

  TimeRangeEditor.prototype.getSlotFilter = function () {
    return ['startTime', 'endTime'];
  };

  return TimeRangeEditor;
});
