function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/PermissionsMapGridEditor
 */
define(['baja!', 'bajaux/events', 'jquery', 'underscore', 'Promise', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/util/spaceUtils', 'nmodule/webEditors/rc/fe/baja/util/subscriberUtils', 'nmodule/webEditors/rc/fe/baja/util/userUtils', 'nmodule/webEditors/rc/fe/baja/PermissionsRowEditor', 'bajaux/mixin/responsiveMixIn', 'lex!wbutil,bajaui', 'hbs!nmodule/webEditors/rc/fe/baja/template/PermissionsTable'], function (baja, events, $, _, Promise, BaseEditor, fe, spaceUtils, subscriberUtils, userUtils, PermissionsRowEditor, responsiveMixIn, lexs, tplTable) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 2),
      wbutilLex = _lexs[0],
      bajauiLex = _lexs[1];

  var MODIFY_EVENT = events.MODIFY_EVENT;
  var resolveService = spaceUtils.resolveService;
  var leaseWhenNeeded = subscriberUtils.leaseWhenNeeded;
  var resolveCurrentUser = userUtils.resolveCurrentUser;
  var getRoleService = leaseWhenNeeded(_.partial(resolveService, 'baja:RoleService'));
  var getCategoryService = leaseWhenNeeded(_.partial(resolveService, 'baja:CategoryService'));
  var MIN_GRID_ROWS = 8;
  var PERMISSIONS_GRID_SELECTOR = '.permissionsGridContent';
  /**
   * A field editor for working with a PermissionsMap.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/webEditors/rc/fe/baja/PermissionsMapGridEditor
   */

  var PermissionsMapGridEditor = function PermissionsMapGridEditor(params) {
    var that = this;
    BaseEditor.call(that, $.extend(true, {
      keyName: 'PermissionsMapGridEditor'
    }, params));
    responsiveMixIn(that, {
      'permissions-grid-mobile': {
        maxWidth: 760
      }
    });
  };

  PermissionsMapGridEditor.prototype = Object.create(BaseEditor.prototype);
  PermissionsMapGridEditor.prototype.constructor = PermissionsMapGridEditor;
  /**
   * The minimum number of permissions rows to show in the permissionsGrid
   * @private
   */

  PermissionsMapGridEditor.MIN_GRID_ROWS = MIN_GRID_ROWS;
  /**
   * Creates a PermissionsMap element.
   *
   * @param {JQuery} dom
   * @returns {Promise}
   */

  PermissionsMapGridEditor.prototype.doInitialize = function (dom) {
    var that = this;
    dom.html(tplTable({
      showRowDescription: true,
      category: wbutilLex.get('category.category'),
      operator: bajauiLex.get('security.operator'),
      admin: bajauiLex.get('security.admin'),
      read: bajauiLex.get('security.r'),
      write: bajauiLex.get('security.w'),
      invoke: bajauiLex.get('security.i')
    })); //if a row is modified, set myself modified

    dom.on(MODIFY_EVENT, '.editor', function () {
      that.setModified(true);
      return false;
    });
  };
  /**
   * Loads the given baja.PermissionsMap into the editor.
   *
   * @param {baja.PermissionsMap} permissionsMap
   * @returns {Promise.<baja.PermissionsMap>}
   */


  PermissionsMapGridEditor.prototype.doLoad = function (permissionsMap) {
    var that = this,
        permissionsGrid = that.jq().find(PERMISSIONS_GRID_SELECTOR);
    return that.getChildEditors().destroyAll().then(function () {
      return permissionsGrid.empty();
    }).then(function () {
      return Promise.all([that.$getMaxPermissions(), that.$getCategories(), that.$editorEnabled()]).then(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 3),
            maxPermissions = _ref2[0],
            categoryNames = _ref2[1],
            editorEnabled = _ref2[2];

        return Promise.all(categoryNames.map(function (categoryName, index) {
          var perms;

          if (index === 0) {
            return;
          } // don't do anything for index 0
          // (as we don't populate it in the category array, it shouldn't exist anyway)


          if (index < permissionsMap.size()) {
            perms = permissionsMap.getPermissions(index);
          } else {
            perms = baja.Permissions.none;
          }

          return fe.buildFor({
            dom: $('<tr class="ux-table-row" />').appendTo(permissionsGrid),
            type: PermissionsRowEditor,
            value: perms,
            rowDescription: categoryNames[index],
            rowId: index,
            maxPermissions: maxPermissions.getPermissions(index),
            formFactor: 'mini',
            enabled: editorEnabled
          });
        }));
      });
    });
  };
  /**
   * Read the individual child editors and assemble them into a `PermissionsMap`
   *
   * @returns {Promise.<baja.PermissionsMap>} promise to be resolved with a `baja.PermissionsMap` value
   */


  PermissionsMapGridEditor.prototype.doRead = function () {
    var that = this,
        permissions = [];
    return that.$editorEnabled().then(function (editorEnabled) {
      // if the edidtor is not enabled return the underlying (unchanged) value
      if (!editorEnabled) {
        return that.value();
      }

      return Promise.all(that.getChildEditors().map(function (row) {
        return row.read().then(function (perms) {
          permissions[row.getRowId()] = perms;
        });
      })).then(function () {
        return baja.PermissionsMap.make(permissions);
      });
    });
  };
  /**
   * Whether to enable the editor
   * The main use case here is deal with the scenario where superUser checkbox is disabled on the PermissionsMapEditor.
   * If superUser is checked and disabled, this compact editor shouldn't make any changes.
   * However, if superUser isn't checked, this editor should be allowed to make changes.
   * (but it won't be able to set the role as superUser as it's part of the functionality of this editor)
   *
   * @private
   * @returns {Promise.<boolean>} promise to be resolved with true/false
   */


  PermissionsMapGridEditor.prototype.$editorEnabled = function () {
    var userRoles,
        that = this;
    return that.$getCurrentUser().then(function (currentUser) {
      userRoles = currentUser.get('roles');

      if (!userRoles) {
        return true;
      } // => Grid will be enabled (ie let the server side decide whether any changes are OK)


      return Promise.all(userRoles.split(',').map(function (roleName) {
        return that.$getRole(roleName);
      })).then(function (userRoles) {
        for (var i = 0; i < userRoles.length; i++) {
          if (!userRoles[i]) {
            continue;
          }

          if (userRoles[i].getType().is('baja:AdminRole')) {
            return true; // The admin role is a super user => grid should be enabled
          }

          if (!userRoles[i].get('enabled')) {
            continue;
          }

          var rolePerms = userRoles[i].get('permissions');

          if (rolePerms.isSuperUser()) {
            return true;
          } // user has super user role => grid should be enabled

        }

        return !that.value().isSuperUser(); // Current user doesn't have super user role => grid will only
        // be enabled if the current PermissionsMap is not a super user
      });
    })["catch"](function () {
      // if any of the above fails the default position for the user's permissions is baja.PermissionsMap.SUPER_USER
      return true; // => Grid will be enabled
    });
  };
  /**
   * Get the maximum permissions for this user.
   *
   * @private
   * @returns {Promise.<baja.PermissionsMap>} promise to be resolved with a `baja.PermissionsMap` value
   */


  PermissionsMapGridEditor.prototype.$getMaxPermissions = function () {
    var userRoles,
        that = this;
    return that.$getCurrentUser().then(function (currentUser) {
      userRoles = currentUser.get('roles');

      if (!userRoles) {
        return baja.PermissionsMap.SUPER_USER;
      } // ie let the server side decide whether any changes are OK


      return Promise.all(userRoles.split(',').map(function (roleName) {
        return that.$getRole(roleName);
      })).then(function (userRoles) {
        // combine the permissions for all of this user's role to get the max permissions applicable
        var max = baja.PermissionsMap.DEFAULT;

        for (var i = 0; i < userRoles.length; i++) {
          if (!userRoles[i]) {
            continue;
          } // The admin role is a super user.


          if (userRoles[i].getType().is('baja:AdminRole')) {
            max = baja.PermissionsMap.SUPER_USER;
            break;
          }

          if (!userRoles[i].get('enabled')) {
            continue;
          }

          var rolePerms = userRoles[i].get('permissions');
          max = max.or(rolePerms);
        }

        return max;
      });
    })["catch"](function () {
      // if any of the above fails the default position for the user's permissions is baja.PermissionsMap.SUPER_USER
      // The server side should have the final say on whether any changes are allowed.
      return baja.PermissionsMap.SUPER_USER;
    });
  };

  PermissionsMapGridEditor.prototype.$getRoleService = function () {
    return this.getOrdBase().then(getRoleService);
  };

  PermissionsMapGridEditor.prototype.$getCategoryService = function () {
    return this.getOrdBase().then(getCategoryService);
  };

  PermissionsMapGridEditor.prototype.$getCurrentUser = function () {
    return this.getOrdBase().then(resolveCurrentUser);
  };

  PermissionsMapGridEditor.prototype.$getRole = function (roleName) {
    return this.$getRoleService().then(function (roleService) {
      var role = roleService.get(roleName);
      return role && role.lease().then(_.constant(role));
    })["catch"](_.constant(null));
  };

  PermissionsMapGridEditor.prototype.$getCategories = function () {
    return this.$getCategoryService().then(function (categoryService) {
      var categories = categoryService.getSlots().is('baja:Category').toValueArray(),
          i,
          category,
          arraySize,
          categoryNames = []; // Add named categories to the categoryNames

      for (i = 0; i < categories.length; i++) {
        category = categories[i];
        categoryNames[category.getIndex()] = category.getDisplayName();
      } // Fill in the blanks with the generic name


      arraySize = Math.max(categoryNames.length, MIN_GRID_ROWS + 1);

      for (i = 0; i < arraySize; i++) {
        // don't set up index 0 (it's not used for permissions)
        if (i > 0 && !categoryNames[i]) {
          categoryNames[i] = wbutilLex.get('category.generic', [i]);
        }
      }

      return categoryNames;
    })["catch"](_.constant(null));
  };
  /**
   * Destroys all child editors.
   *
   * @returns {Promise} promise to be resolved when all child editors
   * have been destroyed
   */


  PermissionsMapGridEditor.prototype.doDestroy = function () {
    return this.getChildEditors().destroyAll();
  };

  return PermissionsMapGridEditor;
});
