function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Scott Hoye
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/EnumSetEditor
 */
define(['baja!', 'lex!', 'bajaux/events', 'bajaux/Widget', 'jquery', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/baja/DisplayOnlyEditor', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'nmodule/webEditors/rc/util/htmlUtils', 'nmodule/webEditors/rc/util/ListSelection', 'hbs!nmodule/webEditors/rc/fe/baja/template/EnumSetEditor'], function (baja, lex, events, Widget, $, Promise, _, fe, BaseEditor, DisplayOnlyEditor, OrderedMapEditor, htmlUtils, ListSelection, tplEnumSetEditor) {
  'use strict';

  var MODIFY_EVENT = events.MODIFY_EVENT,
      preventSelectOnShiftClick = htmlUtils.preventSelectOnShiftClick; ////////////////////////////////////////////////////////////////
  // Support functions
  ////////////////////////////////////////////////////////////////

  /**
   * Returns the baja:EnumRange for the given EnumSet value.  If there is
   * no range specified on the EnumSet value (or it is using baja.EnumRange.DEFAULT),
   * the fallback behavior will be to look at the slot facets and use any EnumRange
   * declared there. If found, the results is of type `baja:EnumRange`.
   *
   * @private
   * @inner
   * @param widget The field editor for the EnumSet
   * @param {baja.EnumSet} enumSet The EnumSet value
   * @returns {baja.EnumRange} range facet set, or undefined if not present
   * or not `EnumRange`
   */

  function getEnumRange(widget, enumSet) {
    var range = enumSet && enumSet.getRange(),
        slotFacetRange;

    if (!range || range === baja.EnumRange.DEFAULT) {
      slotFacetRange = widget.properties().getValue('range');

      if (baja.hasType(slotFacetRange, 'baja:EnumRange')) {
        range = slotFacetRange;
      }
    }

    return range;
  }
  /**
   * Given an `EnumRange` tag value, look up the display value from the
   * given lexicon, or return the unescaped tag if no lexicon entry is found.
   *
   * @private
   * @inner
   * @param {String} tag tag value (raw input to tag editor)
   * @param {Lexicon} lex is the Lexicon
   * @returns {Promise|String} promise to be resolved with the String value
   * looked up from the specified lexicon, or the SlotPath-unescaped raw tag
   * value if it could not be found
   */


  function getTagDisplay(tag, lex) {
    var unescaped = baja.SlotPath.unescape(tag);

    if (lex) {
      return lex.get({
        // TODO: This escape is likely wrong (but this is currently how workbench works for enum ranges)
        key: baja.SlotPath.escape(tag),
        def: unescaped
      });
    }

    return unescaped;
  }
  /**
   * Given an `EnumSet` value, look up the optional Lexicon from its EnumRange.
   * If no Lexicon is found on the EnumRange, try finding a lexicon declared on
   * the slot facets.
   *
   * @private
   * @inner
   * @param widget The field editor for the EnumSet
   * @param {baja.EnumSet} enumSet the value for which to retrieve the Lexicon
   * @returns {Promise} a promise that will always resolve if a Lexicon is
   * found, but resolve with `undefined` if it cannot be found.
   */


  function getLexiconFromValue(widget, enumSet) {
    var enumRange = getEnumRange(widget, enumSet),
        lexicon = enumRange && enumRange.getOptions().get('lexicon');

    if (!lexicon) {
      // If no lexicon specified on the EnumSet's range, try the slot facets
      lexicon = widget.properties().getValue('lexicon');
    }

    if (!lexicon) {
      return Promise.resolve();
    }

    return lex.module(lexicon)["catch"](function err() {});
  } ////////////////////////////////////////////////////////////////
  // EnumSetEditor definition
  ////////////////////////////////////////////////////////////////

  /**
   * A field editor for working with `EnumSet` values.  Depending
   * on the form factor, this will use the full (compact) EnumSetEditor
   * a mini, display-only version.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/webEditors/rc/fe/baja/EnumSetEditor
   */


  var EnumSetEditor = function EnumSetEditor(params) {
    BaseEditor.call(this, $.extend({
      keyName: 'EnumSetEditor'
    }, params));

    if (this.getFormFactor() === Widget.formfactor.mini && !this.$isSingleSelection()) {
      DisplayOnlyEditor.$mixin(this);
    }
  };

  EnumSetEditor.prototype = Object.create(BaseEditor.prototype);
  EnumSetEditor.prototype.constructor = EnumSetEditor;
  /**
   * When in single-selection mode, an `OrderedMapEditor` will be shown.
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/OrderedMapEditor} the
   * ordered map editor, or undefined if not present
   */

  EnumSetEditor.prototype.$getOrderedMapEditor = function () {
    return this.jq().children('.OrderedMap').data('widget');
  };
  /**
   * Get ordinals currently selected by the user.
   *
   * @private
   * @returns {Array.<Number>}
   */


  EnumSetEditor.prototype.$getSelectedOrdinals = function () {
    return this.jq().find('input:checked').map(function () {
      return parseInt($(this).data('ordinal'), 10);
    }).get();
  };
  /**
   * Return true if the `singleSelection` property is true.
   * @private
   * @returns {Boolean}
   */


  EnumSetEditor.prototype.$isSingleSelection = function () {
    return !!this.properties().getValue('singleSelection');
  };

  EnumSetEditor.prototype.$toDisplay = function (enumSet, ordinal) {
    var that = this;
    return Promise.all([getEnumRange(that, enumSet), getLexiconFromValue(that, enumSet)]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
          range = _ref2[0],
          lex = _ref2[1];

      return getTagDisplay(range.getTag(ordinal), lex);
    });
  };
  /**
   * When in single-selection mode, we'll instantiate an OrderedMapEditor for
   * the user to select a single value from.
   *
   * @private
   * @param {JQuery} dom
   * @param {baja.EnumSet} enumSet
   * @returns {Promise}
   */


  EnumSetEditor.prototype.$buildOrderedMapEditor = function (dom, enumSet) {
    var that = this,
        range = getEnumRange(that, enumSet),
        ordinals = range.getOrdinals();
    return Promise.all(_.map(ordinals, function (ordinal) {
      return that.$toDisplay(enumSet, ordinal);
    })).then(function (displays) {
      var map = new baja.OrderedMap();
      displays.forEach(function (display, i) {
        map.put(display, ordinals[i]);
      });
      return fe.buildFor({
        dom: dom,
        loadParams: {
          selectedValue: enumSet.getOrdinals()[0]
        },
        type: OrderedMapEditor,
        value: map
      });
    });
  };
  /**
   * Override the updateDisplay function on DisplayOnlyEditor
   * to provide a tag summary of the selected ordinals
   *
   * @returns {Promise} promise to be resolved after the display has been
   * updated
   */


  EnumSetEditor.prototype.updateDisplay = function (value) {
    var that = this,
        dom = that.jq(),
        ordinals = value.getOrdinals(),
        range = getEnumRange(that, value),
        emptyDisplay;

    if (!ordinals.length) {
      // Nothing selected, so display empty text
      emptyDisplay = that.properties().getValue('emptyDisplayText'); // Give priority to the slot facets

      if (!emptyDisplay) {
        // Fallback to the range facets if slot facets don't have emptyDisplayText
        emptyDisplay = range && range.getOptions().get('emptyDisplayText');
      }

      return dom.text(emptyDisplay || '');
    }

    return getLexiconFromValue(this, value).then(function (lex) {
      dom.text(_.map(ordinals, function (ordinal) {
        return getTagDisplay(range.getTag(ordinal), lex);
      }).join(', '));
    });
  };

  EnumSetEditor.prototype.$applyListSelectionToInputs = function () {
    var that = this;

    if (that.isReadonly() || !that.isEnabled()) {
      return;
    } // Iterate through the table rows and set .selected as indicated by ListSelection


    that.jq().find('.ux-table-row').each(function (i, element) {
      $(element).toggleClass('selected', that.$listSelection.isSelected(i));
      var inputElement = $(element).find('input').get(0);

      if (inputElement.checked !== that.$listSelection.isSelected(i)) {
        inputElement.checked = that.$listSelection.isSelected(i);
        $(inputElement).trigger('change');
      }
    });
  };
  /**
   * Respond to input change events
   *
   * @param {JQuery} dom
   */


  EnumSetEditor.prototype.doInitialize = function (dom) {
    var that = this;
    dom.on('change', 'input', function () {
      that.setModified(true);
    });
    dom.on(MODIFY_EVENT, '.editor', function () {
      that.setModified(true);
      return false;
    });
    preventSelectOnShiftClick(dom);
    that.$listSelection = new ListSelection();
    that.$listSelection.installTouchHandler(that.jq(), '.ux-table', '.ux-table-row', function () {
      return that.$applyListSelectionToInputs();
    });
  };
  /**
   * Loads the `EnumSet` into the editor, creating a checkbox and label
   * for each value in the enum range and selecting the ordinals.
   *
   * @param {baja.EnumSet} enumSet
   * @returns {Promise} promise to be resolved when all the checkboxes and
   * labels have finished loading into the DOM
   */


  EnumSetEditor.prototype.doLoad = function (enumSet) {
    var that = this,
        dom = that.jq();

    if (that.$isSingleSelection()) {
      var omDiv = $('<div class="OrderedMap"/>');
      dom.html(omDiv);
      return that.$buildOrderedMapEditor(omDiv, enumSet);
    }

    var ordinals = enumSet.getOrdinals(),
        range = getEnumRange(that, enumSet),
        rangeOrdinals = range && range.getOrdinals();

    if (range && range !== baja.EnumRange.DEFAULT) {
      return getLexiconFromValue(that, enumSet).then(function (lex) {
        dom.html(tplEnumSetEditor({
          rangeEnum: _.map(rangeOrdinals, function (ordinal) {
            return {
              id: that.generateId(),
              selected: ordinals.indexOf(ordinal) >= 0,
              ordinal: ordinal,
              displayName: getTagDisplay(range.getTag(ordinal), lex)
            };
          })
        }));
      });
    } else {
      // If there is no EnumRange specified, then just use the ordinals
      dom.html(tplEnumSetEditor({
        rangeEnum: _.map(ordinals, function (ordinal) {
          return {
            id: that.generateId(),
            selected: true,
            ordinal: ordinal,
            displayName: ordinal
          };
        })
      }));
    }
  };
  /**
   * Reads the checkbox inputs and returns an 'EnumSet' instance for
   * the selections made.
   *
   * @returns {baja.EnumSet|Promise.<baja.EnumSet>} a `baja.EnumSet` instance
   * read from checkbox editors
   */


  EnumSetEditor.prototype.doRead = function () {
    var that = this,
        val = that.value(),
        enumRange = val && getEnumRange(that, val);

    if (that.$isSingleSelection()) {
      return that.$getOrderedMapEditor().read().then(function (ordinal) {
        return baja.EnumSet.make({
          ordinals: [ordinal],
          range: enumRange
        });
      });
    } else {
      return baja.EnumSet.make({
        ordinals: that.$getSelectedOrdinals(),
        range: enumRange
      });
    }
  };
  /**
   * Enables or disables all checkboxes.
   *
   * @param {Boolean} enabled
   */


  EnumSetEditor.prototype.doEnabled = function (enabled) {
    this.jq().find('input').prop('disabled', this.isReadonly() || !enabled);
    return this.getChildWidgets().setAllEnabled(enabled);
  };
  /**
   * Sets all checkboxes readonly/writable.
   *
   * @param {Boolean} readonly
   */


  EnumSetEditor.prototype.doReadonly = function (readonly) {
    this.jq().find('input').prop('disabled', !this.isEnabled() || readonly);
    return this.getChildWidgets().setAllReadonly(readonly);
  };
  /**
   * Destroy child widgets.
   * @returns {Promise}
   */


  EnumSetEditor.prototype.doDestroy = function () {
    return this.getChildWidgets().destroyAll();
  };

  return EnumSetEditor;
});
