function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/DynamicEnumEditor
 */
define(['baja!', 'jquery', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/CompositeEditor', 'nmodule/webEditors/rc/fe/baja/util/rangeUtils', 'nmodule/webEditors/rc/fe/config/CompositeBuilder'], function (baja, $, Promise, _, CompositeEditor, rangeUtils, CompositeBuilder) {
  'use strict';

  var getEnumRangeDisplay = rangeUtils.getEnumRangeDisplay;
  /**
   * A field editor for working with `DynamicEnum`s.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/CompositeEditor
   * @alias module:nmodule/webEditors/rc/fe/baja/DynamicEnumEditor
   */

  var DynamicEnumEditor = function DynamicEnumEditor(params) {
    CompositeEditor.call(this, $.extend({
      keyName: 'DynamicEnumEditor'
    }, params));
  };

  DynamicEnumEditor.prototype = Object.create(CompositeEditor.prototype);
  DynamicEnumEditor.prototype.constructor = DynamicEnumEditor;
  /**
   * Use a single-key CompositeBuilder so I don't have to manage all those
   * events by hand.
   * TODO: a ProxyEditor or similar because this is such a common use case -
   * i have a value of one data type, but i want to translate it into this
   * other type for the editor
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/config/CompositeBuilder}
   */

  DynamicEnumEditor.prototype.makeBuilder = function () {
    var that = this,
        builder = new CompositeBuilder();

    builder.getKeys = function () {
      return ['string'];
    };

    builder.getDomFor = function () {
      return $('<div/>').appendTo(that.jq());
    };

    builder.getValueFor = function () {
      var dynEnum = this.getDataSource();
      return String(dynEnum.getOrdinal());
    };

    builder.getConfigFor = function () {
      var range = that.$getRangeFor(this.getDataSource()),
          ordinals = range.getOrdinals(),
          datalist = {};
      return Promise.all(_.map(ordinals, function (ordinal) {
        return getEnumRangeDisplay(ordinal, range);
      })).then(function (displays) {
        _.each(ordinals, function (ordinal, i) {
          datalist[ordinal] = displays[i];
        });

        return {
          properties: {
            //always force the Relevant dropdown and show all entries
            'relevant-force': true,
            'relevant-filter': false,
            datalist: datalist
          },
          formFactor: 'mini'
        };
      });
    };

    return builder;
  };
  /**
   * Returns the `range` facet set on the editor, only if it is present and
   * is of type `baja:EnumRange`.
   *
   * @private
   * @returns {baja.EnumRange|undefined} range facet set, or undefined if not present
   * or not `EnumRange`
   */


  DynamicEnumEditor.prototype.$getRangeFacet = function () {
    var range = this.properties().getValue('range');

    if (baja.hasType(range, 'baja:EnumRange')) {
      return range;
    }
  };
  /**
   * Get the appropriate range to use for the loaded `DynamicEnum` (may be
   * overridden by a property).
   * @private
   * @param {baja.DynamicEnum} dynamicEnum
   * @returns {baja.EnumRange|undefined}
   */


  DynamicEnumEditor.prototype.$getRangeFor = function (dynamicEnum) {
    return this.$getRangeFacet() || dynamicEnum.getRange();
  };
  /**
   * Reads the currently selected `<option>` value and returns a new
   * `DynamicEnum` using that value as the ordinal.
   *
   * @returns {Promise.<baja.DynamicEnum>} a `DynamicEnum` instance
   * with the selected ordinal
   */


  DynamicEnumEditor.prototype.doRead = function () {
    var that = this,
        en = that.value();
    return that.getBuilder().readAll().then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 1),
          str = _ref2[0];

      if (!str) {
        return baja.DynamicEnum.DEFAULT;
      }

      var ordinal = parseInt(str, 10);

      if (isNaN(ordinal)) {
        throw new Error('invalid ordinal: ' + str);
      } else {
        return baja.DynamicEnum.make({
          range: that.$getRangeFacet() || en.getRange(),
          ordinal: ordinal
        });
      }
    });
  };

  return DynamicEnumEditor;
});
