/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/DisplayOnlyEditor
 */
define(['baja!', 'bajaux/widgets/ToStringWidget', 'Promise', 'underscore'], function (baja, ToStringWidget, Promise, _) {
  'use strict';
  /**
   * A display-only field editor. This editor will do nothing but convert the
   * value to a string and set the text value of the bound element.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/webEditors/rc/fe/baja/DisplayOnlyEditor
   */

  var DisplayOnlyEditor = function DisplayOnlyEditor() {
    ToStringWidget.apply(this, arguments);
  };

  DisplayOnlyEditor.prototype = Object.create(ToStringWidget.prototype);
  DisplayOnlyEditor.prototype.constructor = DisplayOnlyEditor;
  /**
   * Applies the ToStringWidget mixin, also removing the batchSave mixin if
   * present (since ToStringWidgets cannot be saved).
   *
   * @private
   * @param {module:bajaux/Widget} ed
   */

  DisplayOnlyEditor.$mixin = function (ed) {
    ed.valueToString = ed.valueToString || DisplayOnlyEditor.prototype.valueToString;
    ToStringWidget.$mixin(ed);
    ed.$mixins = _.without(ed.$mixins, 'batchSave');
  };
  /**
   * If value is a Baja type, convert this widget's Properties to a formatting
   * context and use it to toString the Baja value.
   *
   * @param {*} value
   * @returns {String|Promise<String>}
   */


  DisplayOnlyEditor.prototype.valueToString = function (value) {
    if (baja.hasType(value)) {
      var cx = this.properties().toValueMap();
      return Promise.resolve(value.toString(cx));
    }

    return ToStringWidget.prototype.valueToString.call(this, value);
  };

  return DisplayOnlyEditor;
});
