/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/DefaultSimpleEditor
 */
define(['baja!', 'jquery', 'nmodule/webEditors/rc/fe/CompositeEditor', 'nmodule/webEditors/rc/fe/config/CompositeBuilder'], function (baja, $, CompositeEditor, CompositeBuilder) {
  'use strict';
  /**
   * Default editing behavior for Simples. Will simply show a string editor that
   * lets the user edit the Simple by using its `encodeToString()` and
   * `decodeFromString()` functions.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/fe/baja/DefaultSimpleEditor
   * @extends module:nmodule/webEditors/rc/fe/CompositeEditor
   */

  var DefaultSimpleEditor = function DefaultSimpleEditor() {
    CompositeEditor.apply(this, arguments);
  };

  DefaultSimpleEditor.prototype = Object.create(CompositeEditor.prototype);
  DefaultSimpleEditor.prototype.constructor = DefaultSimpleEditor;
  /**
   * Only one child editor for the `decodeFromString()`.
   * @returns {module:nmodule/webEditors/rc/fe/config/CompositeBuilder}
   */

  DefaultSimpleEditor.prototype.makeBuilder = function () {
    var that = this,
        builder = new CompositeBuilder();

    builder.getKeys = function () {
      return ['str'];
    };

    builder.getDomFor = function () {
      return $('<span/>').appendTo(that.jq());
    };

    builder.getValueFor = function () {
      return this.getDataSource().encodeToString();
    };

    builder.getConfigFor = function () {
      return {
        formFactor: 'mini'
      };
    };

    return builder;
  };
  /**
   * Get the string editor.
   * @returns {module:bajaux/Widget}
   */


  DefaultSimpleEditor.prototype.$getStringEditor = function () {
    return this.getBuilder().getEditorFor('str');
  };

  DefaultSimpleEditor.prototype.doInitialize = function (dom) {
    dom.addClass('DefaultSimpleEditor');
    return CompositeEditor.prototype.doInitialize.apply(this, arguments);
  };
  /**
   * Will load the `encodeToString()` value into the string editor.
   * @param {baja.Simple} val
   * @returns {Promise}
   */


  DefaultSimpleEditor.prototype.doLoad = function (val) {
    if (!baja.hasType(val, 'baja:Simple')) {
      throw new Error('Simple required');
    }

    return CompositeEditor.prototype.doLoad.apply(this, arguments);
  };
  /**
   * Resolves an new instance of the same type as the loaded `Simple`,
   * `decodeFromString()`-ed from the entered value.
   * @returns {Promise.<baja.Simple>}
   */


  DefaultSimpleEditor.prototype.doRead = function () {
    var val = this.value();
    return this.$getStringEditor().read().then(function (str) {
      return val.getType().getInstance().decodeFromString(str);
    });
  };

  DefaultSimpleEditor.prototype.doDestroy = function () {
    this.jq().removeClass('DefaultSimpleEditor');
    return CompositeEditor.prototype.doDestroy.apply(this, arguments);
  };

  return DefaultSimpleEditor;
});
