function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/ConfirmPasswordEditor
 */
define(['baja!', 'lex!webEditors', 'jquery', 'nmodule/webEditors/rc/fe/baja/PasswordEditor', 'nmodule/webEditors/rc/fe/CompositeEditor', 'nmodule/webEditors/rc/fe/config/CompositeBuilder'], function (baja, lexs, $, PasswordEditor, CompositeEditor, CompositeBuilder) {
  'use strict';

  var webEditorsLex = lexs[0],
      CONFIRM = webEditorsLex.get('UserPasswordEditor.confirm'),
      PASSWORD = webEditorsLex.get('UserPasswordEditor.password'),
      PASSWORD_MISMATCH = webEditorsLex.get('UserPasswordEditor.passwordMismatch'),
      KEY_PASSWORD = 'p',
      KEY_CONFIRM = 'c',
      keys = [KEY_PASSWORD, KEY_CONFIRM];
  /**
   * Editor for handling `baja:Password` values that need a confirmation.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/CompositeEditor
   * @alias module:nmodule/webEditors/rc/fe/baja/ConfirmPasswordEditor
   */

  var ConfirmPasswordEditor = function ConfirmPasswordEditor(params) {
    var that = this;
    CompositeEditor.apply(this, arguments);
    that.validators().add(function (val) {
      return that.$getConfirmEditor().read().then(function (confirm) {
        if (val.encodeToString() !== confirm.encodeToString()) {
          throw new Error(PASSWORD_MISMATCH);
        }
      });
    });
  };

  ConfirmPasswordEditor.prototype = Object.create(CompositeEditor.prototype);
  ConfirmPasswordEditor.prototype.constructor = ConfirmPasswordEditor;

  ConfirmPasswordEditor.prototype.doInitialize = function (dom) {
    return CompositeEditor.prototype.doInitialize.apply(this, arguments);
  };
  /**
   * @overrides module:nmodule/webEditors/rc/fe/CompositeEditor
   * @returns {*}
   */


  ConfirmPasswordEditor.prototype.makeBuilder = function () {
    var that = this;
    var builder = new CompositeBuilder();

    builder.getDomFor = function (i) {
      return $('<div data-key="' + i + '"></div>').appendTo(that.jq());
    };

    builder.getKeys = function () {
      return keys;
    };

    builder.getValueFor = function () {
      return baja.$("baja:Password");
    };

    builder.getConfigFor = function (i) {
      var label = "";

      switch (i) {
        case KEY_PASSWORD:
          label = PASSWORD;
          break;

        case KEY_CONFIRM:
          label = CONFIRM;
          break;

        default:
          label = "";
      }

      return {
        type: PasswordEditor,
        complex: that.getComplex(),
        slot: that.getSlot(),
        properties: {
          prelabel: label
        }
      };
    };

    return builder;
  };
  /**
   * Get the second/confirmation string editor.
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/PasswordEditor}
   */


  ConfirmPasswordEditor.prototype.$getConfirmEditor = function () {
    // noinspection JSValidateTypes
    return this.getBuilder().getEditorFor(KEY_CONFIRM);
  };

  ConfirmPasswordEditor.prototype.doRead = function () {
    return this.getBuilder().readAll().then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 1),
          pwd = _ref2[0];

      return pwd;
    });
  };
  /**
   * Save the password
   *
   * @see module:nmodule/webEditors/rc/fe/baja/PasswordEditor
   * @see module:nmodule/webEditors/rc/servlets/password
   * @returns {Promise}
   */


  ConfirmPasswordEditor.prototype.saveToComplex = function (pw, params) {
    return PasswordEditor.prototype.saveToComplex.call(this, pw, params);
  };
  /**
   * Destroys "password" and "confirm" editors.
   *
   * @returns {Promise}
   */


  ConfirmPasswordEditor.prototype.doDestroy = function () {
    return this.getChildWidgets().destroyAll();
  };
  /**
   * Set password/confirm editors readonly. Will not make them writable if
   * editor is not working in a secure environment.
   *
   * @see module:nmodule/webEditors/rc/fe/baja/PasswordEditor
   * @param {Boolean} readonly
   * @returns {Promise}
   */


  ConfirmPasswordEditor.prototype.doReadonly = function (readonly) {
    return this.getChildEditors().setAllReadonly(readonly);
  };
  /**
   * Set password/confirm editors enabled. Will not enable them if editor is
   * not working in a secure environment.
   *
   * @see module:nmodule/webEditors/rc/fe/baja/PasswordEditor
   * @param {Boolean} enabled
   * @returns {Promise}
   */


  ConfirmPasswordEditor.prototype.doEnabled = function (enabled) {
    return this.getChildEditors().setAllEnabled(enabled);
  };

  return ConfirmPasswordEditor;
});
