function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/BooleanEditor
 */
define(['baja!', 'lex!baja', 'log!nmodule.webEditors.rc.fe.baja.BooleanEditor', 'jquery', 'Promise', 'nmodule/webEditors/rc/fe/baja/BaseEditor'], function (baja, lexs, log, $, Promise, BaseEditor) {
  'use strict';

  var bajaLex = lexs[0],
      logError = log.severe.bind(log);

  function doFormat(pattern) {
    return baja.Format.format({
      pattern: pattern
    });
  }
  /**
   * A field editor for working with booleans.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/webEditors/rc/fe/baja/BooleanEditor
   */


  var BooleanEditor = function BooleanEditor(params) {
    BaseEditor.call(this, $.extend({
      keyName: 'BooleanEditor'
    }, params));
  };

  BooleanEditor.prototype = Object.create(BaseEditor.prototype);
  BooleanEditor.prototype.constructor = BooleanEditor;
  /**
   * Compute the true/false display text to use from the `trueText` /
   * `falseText` facets.
   *
   * @private
   * @returns {Promise} promise to be resolved with an array containing two
   * strings for trueText/falseText
   */

  BooleanEditor.prototype.$getTrueFalseText = function () {
    var props = this.properties(),
        trueText = props.getValue('trueText') || bajaLex.get('true'),
        falseText = props.getValue('falseText') || bajaLex.get('false');
    return Promise.all([doFormat(trueText), doFormat(falseText)]);
  };
  /**
   * Return the checkbox element.
   *
   * @private
   * @returns {jQuery}
   */


  BooleanEditor.prototype.$getCheckbox = function () {
    return this.jq().children('input');
  };
  /**
   * Update the current value of the display label with the `trueText` or
   * `falseText` facet, falling back to `true` and `false` from the `baja`
   * lexicon if either of those facets is not configured.
   * @private
   * @param {Boolean} value whether the the editor currently has true or false
   * loaded
   * @returns {Promise}
   */


  BooleanEditor.prototype.$updateLabel = function (value) {
    var that = this;
    return that.$getTrueFalseText().then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
          trueText = _ref2[0],
          falseText = _ref2[1];

      that.jq().children('label').text(value ? trueText : falseText);
    });
  };
  /**
   * Creates a checkbox input.
   * @param {JQuery} dom
   */


  BooleanEditor.prototype.doInitialize = function (dom) {
    var that = this,
        id = this.generateId(),
        input = $('<input type="checkbox">').prop('id', id),
        label = $('<label></label>').prop('for', id);
    dom.html(input.add(label));
    dom.on('change', 'input:checkbox', function () {
      that.setModified(true);
      that.read().then(function (value) {
        return that.$updateLabel(value);
      })["catch"](logError);
    });
  };
  /**
   * Checks or unchecks the checkbox to reflect the loaded value.
   * @param {Boolean} val
   */


  BooleanEditor.prototype.doLoad = function (val) {
    this.$getCheckbox().prop('checked', !!val);
    return this.$updateLabel(val);
  };
  /**
   * Returns the checked/unchecked state of the checkbox.
   * @returns {Boolean} the boolean checked state of the checkbox
   */


  BooleanEditor.prototype.doRead = function () {
    return this.$getCheckbox().prop('checked');
  };
  /**
   * Enables or disables the checkbox element.
   *
   * @param {Boolean} enabled
   */


  BooleanEditor.prototype.doEnabled = function (enabled) {
    this.$getCheckbox().prop('disabled', this.isReadonly() || !enabled);
  };
  /**
   * Disables or enables the checkbox element.
   *
   * @param {Boolean} readonly
   */


  BooleanEditor.prototype.doReadonly = function (readonly) {
    this.$getCheckbox().prop('disabled', !this.isEnabled() || readonly);
  };

  return BooleanEditor;
});
