function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/AdapterEditor
 */
define(['underscore', 'Promise', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/BaseEditor'], function (_, Promise, fe, BaseEditor) {
  'use strict';
  /**
   * Quite often, an editor for one type will essentially be the same as an
   * existing editor for another type, possibly with some extra configuration.
   * This class allows you to define an editor in terms of building another.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/fe/baja/AdapterEditor
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   */

  var AdapterEditor = /*#__PURE__*/function (_BaseEditor) {
    _inherits(AdapterEditor, _BaseEditor);

    var _super = _createSuper(AdapterEditor);

    function AdapterEditor() {
      _classCallCheck(this, AdapterEditor);

      return _super.apply(this, arguments);
    }

    _createClass(AdapterEditor, [{
      key: "toConfig",

      /**
       * This method will provide the fe.makeFor config that defines what our
       * adapted editor looks like.
       *
       * @abstract
       * @param {*} value the value to load
       * @returns {object|Promise.<object>} a params object to be passed
       * to `fe.makeFor`. At minimum, `value` is required.
       *
       * @example
       * <caption>Create a string editor that allows the user to edit the string
       * as-is, but also provide an extra datalist of known good values.</caption>
       * toConfig(myString) {
       *   return getKnownGoodValues()
       *     .then((goodValues) => {
       *       return {
       *         value: myString,
       *         properties: { datalist: goodValues.join(';') }
       *       };
       *     });
       * }
       */
      value: function toConfig(value) {
        throw new Error('not implemented');
      }
      /**
       * This method converts the adapted value back to the original type.
       *
       * @abstract
       * @param {*} readValue the value read from the converted editor
       * @param {module:bajaux/Widget} convertedEditor the converted editor
       * @returns {*|Promise.<*>} the value, converted back to the type originally
       * loaded in
       */

    }, {
      key: "toValue",
      value: function toValue(readValue, convertedEditor) {
        return readValue;
      }
      /**
       * Performs the work of initializing and loading the converted editor.
       *
       * @param {*} value
       * @returns {Promise}
       */

    }, {
      key: "doLoad",
      value: function doLoad(value) {
        var _this = this;

        return Promise.resolve(this.toConfig(value)).then(function (myConfig) {
          var convertedValue = myConfig.value; // by default, we will pass our own properties

          var defaultConfig = {
            properties: _this.properties().toValueMap(),
            formFactor: _this.getFormFactor(),
            enabled: _this.isEnabled(),
            readonly: _this.isReadonly()
          };
          return fe.makeFor(_.extend(defaultConfig, myConfig)).then(function (ed) {
            //hold onto a reference to use in doRead()...
            _this.$ed = ed; // (emptying it out each time because, doLoad can be called multiple
            // times)...

            ed.$jq = _this.jq().empty().off();
            return Promise.resolve(ed.doInitialize(_this.jq())).then(function () {
              return ed.load(convertedValue);
            });
          });
        });
      }
      /**
       * Resolves the value, as read from the converted editor.
       * @returns {Promise.<*>} respective value
       */

    }, {
      key: "doRead",
      value: function doRead() {
        var _this2 = this;

        return this.$ed.read().then(function (convertedValue) {
          // here, convertedReadValue would be any primitive type, so convert it back to
          // the original type
          return _this2.toValue(convertedValue, _this2.$ed);
        });
      }
      /**
       * Sets the readonly state of the converted editor.
       * @param {boolean} readonly
       * @returns {Promise}
       */

    }, {
      key: "doReadonly",
      value: function doReadonly(readonly) {
        // ed will not be available for the first time when the property sheet loads,
        // so returning Promise.resolve().
        if (this.$ed) {
          return this.$ed.doReadonly(readonly);
        }

        return Promise.resolve();
      }
      /**
       * Sets the enabled state of the converted editor.
       * @param {boolean} enabled
       * @returns {Promise}
       */

    }, {
      key: "doEnabled",
      value: function doEnabled(enabled) {
        // ed will not be available for the first time when the property sheet loads,
        // so returning Promise.resolve().
        if (this.$ed) {
          return this.$ed.doEnabled(enabled);
        }

        return Promise.resolve();
      }
      /**
       * Delegates destruction to the converted editor.
       * @param {object} [params]
       * @returns {Promise}
       */

    }, {
      key: "doDestroy",
      value: function doDestroy(params) {
        // ed will not be available for the first time when the property sheet loads,
        // so returning Promise.resolve().
        if (this.$ed) {
          return this.$ed.doDestroy(params);
        }

        return Promise.resolve();
      }
    }]);

    return AdapterEditor;
  }(BaseEditor);

  return AdapterEditor;
});
