function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/AbsTimeRangeEditor
 */
define(['lex!webEditors', 'jquery', 'Promise', 'nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor'], function (lexs, $, Promise, ComplexCompositeEditor) {
  'use strict';

  var webEditorsLex = lexs[0];

  function startBeforeEnd(startTime, endTime) {
    if (startTime.getJsDate().getTime() >= endTime.getJsDate().getTime()) {
      throw new Error(webEditorsLex.get('AbsTimeRangeEditor.startAfterEnd'));
    }
  }
  /**
   * Editor for an `AbsTimeRange`.
   *
   * An `AbsTimeRangeEditor` supports the following `bajaux` `Properties`:
   *
   * - `validateRange`: set to `true` to add a validate step that ensures the
   *   `startTime` slot is before, or equal to, the `endTime` slot.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor
   * @alias module:nmodule/webEditors/rc/fe/baja/AbsTimeRangeEditor
   */


  var AbsTimeRangeEditor = function AbsTimeRangeEditor(params) {
    var that = this;
    ComplexCompositeEditor.call(that, $.extend({
      keyName: 'AbsTimeRangeEditor'
    }, params));

    if (that.properties().getValue('validateRange') === true) {
      that.validators().add(function (diff) {
        var value = that.value();
        return Promise.all([diff.getValue(value, 'startTime'), diff.getValue(value, 'endTime')]).then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 2),
              startTime = _ref2[0],
              endTime = _ref2[1];

          return startBeforeEnd(startTime, endTime);
        });
      });
    }
  };

  AbsTimeRangeEditor.prototype = Object.create(ComplexCompositeEditor.prototype);
  AbsTimeRangeEditor.prototype.constructor = AbsTimeRangeEditor;
  /**
   * Use slots `startTime` and `endTime`.
   *
   * @returns {Array}
   */

  AbsTimeRangeEditor.prototype.getSlotFilter = function () {
    return ['startTime', 'endTime'];
  };

  return AbsTimeRangeEditor;
});
