function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Jeremy Narron
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/array/ArrayCompositeEditor
 */
define(['lex!webEditors', 'bajaux/spandrel', 'bajaux/Widget', 'bajaux/commands/Command', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/baja/DisplayOnlyEditor'], function (lexs, spandrel, Widget, Command, Promise, _, fe, feDialogs, DisplayOnlyEditor) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
      webEditorsLex = _lexs[0];

  var extend = _.extend,
      isNumber = _.isNumber;
  var FOCUS_CLASS = 'ux-bg'; ////////////////////////////////////////////////////////////////
  // ArrayCompositeEditor
  ////////////////////////////////////////////////////////////////

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: 'ArrayCompositeEditor'
      }
    };
  };

  function arrayToConfig(array, _ref) {
    var _this = this;

    var properties = _ref.properties;
    var _properties$getConfig = properties.getConfig,
        getConfig = _properties$getConfig === void 0 ? function () {
      return {};
    } : _properties$getConfig,
        _properties$numbers = properties.numbers,
        numbers = _properties$numbers === void 0 ? {} : _properties$numbers;
    var _numbers$show = numbers.show,
        show = _numbers$show === void 0 ? true : _numbers$show,
        _numbers$countFromZer = numbers.countFromZero,
        countFromZero = _numbers$countFromZer === void 0 ? false : _numbers$countFromZer;
    var focusedIndex = this.$focusedEditorIndex;
    return {
      rows: {
        dom: '<div class="editors"></div>',
        on: [['focusin', '*/editor', function (e, ed) {
          return _this.$setFocusedEditor(ed);
        }]],
        kids: array.map(function (value, i) {
          return {
            dom: "<div class=\"editor-row ".concat(focusedIndex === i ? FOCUS_CLASS : '', "\"></div>"),
            kids: {
              number: show && "<div class=\"number\">".concat(countFromZero ? i : i + 1, ".</div>"),
              editor: extend(getConfig(value, i, properties), {
                dom: '<div></div>',
                value: value
              })
            }
          };
        })
      }
    };
  }
  /**
   * An abstract editor intended to manage the instantiation, initialization,
   * and loading of multiple sub-editors contained in an array.
   *
   * This class also contains default implementations of four commands
   * that can be used as buttons with this editor: add, remove, move up,
   * and move down.
   *
   * It accepts an object literal Property called `numbers` which contains two
   * sub properties:
   * - `show`: (Boolean) if true display the number for each editor starting
   * from 1.
   * - `countFromZero`: (Boolean) if true start the editor numbers from 0
   * instead of 1.
   *
   * It accepts an optional `getConfig` Property, which is a function to receive
   * the value and index for each member of the array, and return `fe.buildFor`
   * parameters such as `properties` and `type` used to build the editor for
   * that member.
   *
   * @class
   * @extends module:bajaux/spandrel/SpandrelWidget
   * @alias module:nmodule/webEditors/rc/fe/array/ArrayCompositeEditor
   */


  var ArrayCompositeEditor = /*#__PURE__*/function (_spandrel) {
    _inherits(ArrayCompositeEditor, _spandrel);

    var _super = _createSuper(ArrayCompositeEditor);

    function ArrayCompositeEditor() {
      var _this2;

      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      _classCallCheck(this, ArrayCompositeEditor);

      _this2 = _super.call(this, {
        params: params,
        defaults: widgetDefaults()
      });

      if (_this2.getFormFactor() === Widget.formfactor.mini) {
        DisplayOnlyEditor.$mixin(_assertThisInitialized(_this2));
      }

      return _this2;
    }
    /**
     * Read a new value for the currently entered value.
     *
     * @returns {Promise.<Array>}
     */


    _createClass(ArrayCompositeEditor, [{
      key: "doRead",
      value: function doRead() {
        return Promise.all(this.$getValueEditors().map(function (w) {
          return w.read();
        }));
      }
      /**
       * Gets the currently focused editor index.
       *
       * @returns {Number|undefined}
       */

    }, {
      key: "getFocusedEditorIndex",
      value: function getFocusedEditorIndex() {
        return this.$focusedEditorIndex;
      }
    }, {
      key: "$getValueEditors",
      value: function $getValueEditors() {
        return this.queryWidgets('rows/*/editor');
      }
      /**
       * Sets the currently focused editor index.
       *
       * @private
       * @param {Number} index
       * @param {Boolean} requestFocus
       */

    }, {
      key: "$setFocusedEditorIndex",
      value: function $setFocusedEditorIndex(index, requestFocus) {
        var rows = this.queryWidgets('rows/*');
        this.$focusedEditorIndex = index;
        rows.forEach(function (row, i) {
          return row.jq().toggleClass(FOCUS_CLASS, i === index);
        });

        if (index !== undefined && requestFocus) {
          var focusedEd = rows[index].queryWidget('editor');
          focusedEd.requestFocus();
        }
      }
      /**
       * @private
       * @param {module:module:bajaux/Widget} ed the widget that received focus
       */

    }, {
      key: "$setFocusedEditor",
      value: function $setFocusedEditor(ed) {
        this.$setFocusedEditorIndex(+this.getPathToKid(ed)[1]);
      }
      /**
       * Un-focuses any current focused editor.
       * @private
       */

    }, {
      key: "$removeFocus",
      value: function $removeFocus() {
        this.$setFocusedEditorIndex(undefined);
      }
      /**
       * When in mini/display-only mode, just display the number of items.
       *
       * @returns {String}
       */

    }, {
      key: "valueToString",
      value: function valueToString(array) {
        return webEditorsLex.get('ArrayCompositeEditor.items', array.length);
      } ////////////////////////////////////////////////////////////////
      // Command helper functions
      ////////////////////////////////////////////////////////////////

      /**
       * Add an item to the backing array.
       *
       * @param {*} item
       * @returns {Promise}
       */

    }, {
      key: "addItem",
      value: function addItem(item) {
        return this.doLoad(this.value().concat(item));
      }
      /**
       * Remove an item from the backing array.
       *
       * @param {Number} indexToRemove
       * @returns {Promise}
       */

    }, {
      key: "removeItem",
      value: function removeItem(indexToRemove) {
        var _this3 = this;

        return this.$verifyIndexInBounds(indexToRemove).then(function (array) {
          var focusedIndex = _this3.getFocusedEditorIndex();

          if (indexToRemove === focusedIndex) {
            if (indexToRemove === _this3.$getValueEditors().length - 1) {
              _this3.$removeFocus();
            }
          } else if (focusedIndex > indexToRemove) {
            _this3.$setFocusedEditorIndex(focusedIndex - 1, true);
          }

          array.splice(indexToRemove, 1);
          return _this3.doLoad(array);
        });
      }
      /**
       * Move an item one slot up in the backing array.
       *
       * @param {Number} indexToMoveUp
       * @returns {Promise}
       */

    }, {
      key: "moveUpItem",
      value: function moveUpItem(indexToMoveUp) {
        var _this4 = this;

        return this.$verifyIndexInBounds(indexToMoveUp).then(function (array) {
          if (indexToMoveUp === 0) {
            return;
          }

          if (indexToMoveUp === _this4.getFocusedEditorIndex()) {
            _this4.$setFocusedEditorIndex(indexToMoveUp - 1, true);
          }

          return _this4.doLoad(swap(array, indexToMoveUp, indexToMoveUp - 1));
        });
      }
      /**
       * Move an item one slot down in the backing array.
       *
       * @param {Number} indexToMoveDown
       * @returns {Promise}
       */

    }, {
      key: "moveDownItem",
      value: function moveDownItem(indexToMoveDown) {
        var _this5 = this;

        return this.$verifyIndexInBounds(indexToMoveDown).then(function (array) {
          if (indexToMoveDown === array.length - 1) {
            return;
          }

          if (indexToMoveDown === _this5.getFocusedEditorIndex()) {
            _this5.$setFocusedEditorIndex(indexToMoveDown + 1, true);
          }

          return _this5.doLoad(swap(array, indexToMoveDown, indexToMoveDown + 1));
        });
      }
      /**
       * @private
       * @param {number} index
       * @returns {Promise.<Array>}
       */

    }, {
      key: "$verifyIndexInBounds",
      value: function $verifyIndexInBounds(index) {
        return this.read().then(function (array) {
          if (index < 0 || index >= array.length) {
            throw new Error('Index out of array bounds');
          }

          return array;
        });
      }
    }]);

    return ArrayCompositeEditor;
  }(spandrel(arrayToConfig, {
    manager: fe.getWidgetManager()
  })); ////////////////////////////////////////////////////////////////
  // Commands
  ////////////////////////////////////////////////////////////////

  /**
   * Command to add a new value.
   *
   * @private
   * @class
   * @extends module:bajaux/commands/Command
   * @memberOf module:nmodule/webEditors/rc/fe/array/ArrayCompositeEditor
   * @param {Function} getEd a function that returns either an
   * `ArrayCompositeEditor` or a `Promise` that resolves with an
   * `ArrayCompositeEditor`.
   * @param {*} [defaultValue=''] the default value to prompt the user with.
   */


  var AddCommand = /*#__PURE__*/function (_Command) {
    _inherits(AddCommand, _Command);

    var _super2 = _createSuper(AddCommand);

    function AddCommand(getEd) {
      var defaultValue = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';

      _classCallCheck(this, AddCommand);

      return _super2.call(this, {
        module: 'webEditors',
        lex: 'commands.addItem',
        func: function func() {
          return Promise.all([feDialogs.showFor({
            value: defaultValue
          }), getEd()]).then(function (_ref2) {
            var _ref3 = _slicedToArray(_ref2, 2),
                item = _ref3[0],
                ed = _ref3[1];

            return item !== null && ed.addItem(item);
          });
        }
      });
    }

    return AddCommand;
  }(Command);

  ArrayCompositeEditor.AddCommand = AddCommand;
  /**
   * Command to remove the selected item.
   *
   * @private
   * @class
   * @extends module:bajaux/commands/Command
   * @memberOf module:nmodule/webEditors/rc/fe/array/ArrayCompositeEditor
   * @param {Function} getEd a function that returns either an
   * `ArrayCompositeEditor` or a `Promise` that resolves with an
   * `ArrayCompositeEditor`.
   */

  var RemoveCommand = /*#__PURE__*/function (_Command2) {
    _inherits(RemoveCommand, _Command2);

    var _super3 = _createSuper(RemoveCommand);

    function RemoveCommand(getEd) {
      _classCallCheck(this, RemoveCommand);

      return _super3.call(this, {
        module: 'webEditors',
        lex: 'commands.removeItem',
        func: function func() {
          return Promise.resolve(getEd()).then(function (ed) {
            var focusedIndex = ed.getFocusedEditorIndex();

            if (isNumber(focusedIndex)) {
              return ed.removeItem(focusedIndex);
            }
          });
        }
      });
    }

    return RemoveCommand;
  }(Command);

  ArrayCompositeEditor.RemoveCommand = RemoveCommand;
  /**
   * Command to move the selected item up in the list.
   *
   * @private
   * @class
   * @extends module:bajaux/commands/Command
   * @memberOf module:nmodule/webEditors/rc/fe/array/ArrayCompositeEditor
   * @param {Function} getEd a function that returns either an
   * `ArrayCompositeEditor` or a `Promise` that resolves with an
   * `ArrayCompositeEditor`.
   */

  var MoveUpCommand = /*#__PURE__*/function (_Command3) {
    _inherits(MoveUpCommand, _Command3);

    var _super4 = _createSuper(MoveUpCommand);

    function MoveUpCommand(getEd) {
      _classCallCheck(this, MoveUpCommand);

      return _super4.call(this, {
        module: 'webEditors',
        lex: 'commands.moveUp',
        func: function func() {
          return Promise.resolve(getEd()).then(function (ed) {
            var focusedIndex = ed.getFocusedEditorIndex();

            if (isNumber(focusedIndex)) {
              return ed.moveUpItem(focusedIndex);
            }
          });
        }
      });
    }

    return MoveUpCommand;
  }(Command);

  ArrayCompositeEditor.MoveUpCommand = MoveUpCommand;
  /**
   * Command to move the selected item down in the list.
   *
   * @private
   * @class
   * @extends module:bajaux/commands/Command
   * @memberOf module:nmodule/webEditors/rc/fe/array/ArrayCompositeEditor
   * @param {Function} getEd a function that returns either an
   * `ArrayCompositeEditor` or a `Promise` that resolves with an
   * `ArrayCompositeEditor`.
   */

  var MoveDownCommand = /*#__PURE__*/function (_Command4) {
    _inherits(MoveDownCommand, _Command4);

    var _super5 = _createSuper(MoveDownCommand);

    function MoveDownCommand(getEd) {
      _classCallCheck(this, MoveDownCommand);

      return _super5.call(this, {
        module: 'webEditors',
        lex: 'commands.moveDown',
        func: function func() {
          return Promise.resolve(getEd()).then(function (ed) {
            var focusedIndex = ed.getFocusedEditorIndex();

            if (isNumber(focusedIndex)) {
              return ed.moveDownItem(focusedIndex);
            }
          });
        }
      });
    }

    return MoveDownCommand;
  }(Command);

  ArrayCompositeEditor.MoveDownCommand = MoveDownCommand; ////////////////////////////////////////////////////////////////
  // Support functions
  ////////////////////////////////////////////////////////////////

  function swap(arr, i, j) {
    var tmp = arr[i];
    arr[i] = arr[j];
    arr[j] = tmp;
    return arr;
  }

  return ArrayCompositeEditor;
});
