function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Cody Short
 */

/**
 * API Status: **Private**
 * @module nmodule/converters/rc/NumericToSimpleMap
 */
define(['baja!', 'underscore'], function (baja, _) {
  "use strict";
  /**
   * A bajaux implementation of a NumericToSimpleMap converter.
   * @alias module:nmodule/converters/rc/NumericToSimpleMap
   * @extends baja.Simple
   */

  var NumericToSimpleMap = /*#__PURE__*/function (_baja$Simple) {
    _inherits(NumericToSimpleMap, _baja$Simple);

    var _super = _createSuper(NumericToSimpleMap);

    function NumericToSimpleMap(items, def) {
      var _this;

      _classCallCheck(this, NumericToSimpleMap);

      _this = _super.apply(this, arguments);
      _this.$items = items;
      _this.$def = def;
      return _this;
    }
    /**
     * Decode a NumericToSimpleMap
     *
     * @param {String} str
     * @return {NumericToSimpleMap}
     */


    _createClass(NumericToSimpleMap, [{
      key: "decodeFromString",
      value: function decodeFromString(str) {
        return NumericToSimpleMap.make({
          str: str
        });
      }
    }, {
      key: "decodeAsync",

      /**
       *
       * @param {string} str
       * @param {baja.comm.Batch} [batch]
       * @return {Promise}
       */
      value: function decodeAsync(str, batch) {
        if (str === "null") {
          return Promise.resolve(NumericToSimpleMap.DEFAULT);
        } // Get the prototype instance (used to decode everything else)


        var protoRes = /^([^ ]+) (.*)/.exec(str);

        if (protoRes.length <= 1) {
          throw new Error("Cannot decode NumericToSimpleMap" + str);
        } // Decode the prototype simple we're going to decode from


        var typeToImport = protoRes[1];
        return Promise.resolve(baja.importTypes({
          typeSpecs: [typeToImport],
          batch: batch
        })).then(function () {
          return NumericToSimpleMap.make(str);
        });
      }
    }, {
      key: "getValueType",

      /**
       * Determines the type of values in the NumericToSimpleMap.
       * @returns {baja.Type|null}
       */
      value: function getValueType() {
        if (this.$def !== null) {
          return this.$def.getType();
        } else if (this.$items.length > 0) {
          return this.$items[0].value.getType();
        } else {
          return null;
        }
      }
      /**
       * Gets the default value for this map.
       * @returns {baja.Simple}
       */

    }, {
      key: "getDefault",
      value: function getDefault() {
        return this.$def;
      }
      /**
       * Gets the min from the items.
       * @returns {Array.<number>}
       */

    }, {
      key: "getMinimums",
      value: function getMinimums() {
        return _.pluck(this.$items, 'min');
      }
      /**
       * Gets the max from the items.
       * @returns {Array.<number>}
       */

    }, {
      key: "getMaximums",
      value: function getMaximums() {
        return _.pluck(this.$items, 'max');
      }
      /**
       * Gets the value from the items.
       * @returns {Array.<baja.Simple>}
       */

    }, {
      key: "getValues",
      value: function getValues() {
        return _.pluck(this.$items, 'value');
      }
      /**
       * Determines whether NumericToSimpleMap is null based upon the contents of
       * the items array.
       * @returns {boolean} true if null, false if not null
       */

    }, {
      key: "isNull",
      value: function isNull() {
        return this.$items.length === 0;
      }
      /**
       * Make a NumericToSimpleMap
       *
       * @param {Object|string} obj Object Literal for the method's arguments or
       * the string encoding of the NumericToSimpleMap.
       * @param {String} obj.str the String encoding.
       * @return {NumericToSimpleMap}
       */

    }, {
      key: "make",
      value: function make(obj) {
        obj = baja.objectify(obj, "str");

        if (!obj || !obj.str) {
          throw new Error("NumericToSimpleMap.make passed invalid value");
        }

        if (obj.str === "null") {
          return NumericToSimpleMap.DEFAULT;
        } // Get the prototype instance (used to decode everything else)


        var protoRes = /^([^ ]+) (.*)/.exec(obj.str);

        if (protoRes.length <= 1) {
          throw new Error("Cannot decode NumericToSimpleMap" + obj.str);
        } // Decode the prototype simple we're going to decode from


        var proto = baja.$(protoRes[1]); // Separate out the value pairs

        var valPairRegEx = /([^;]*)=(([^;]|;;)*)/g;
        var valPairRes,
            defValue = null,
            value,
            numRegEx,
            numRes,
            items = [];
        valPairRes = valPairRegEx.exec(protoRes[2]);

        while (valPairRes) {
          // Decode the value from the String
          var encodedValue = valPairRes[2].replace(/;;/g, ";");
          value = proto.decodeFromString(encodedValue);

          if (valPairRes[1] === "default") {
            defValue = value;
          } else {
            // Decode the numeric range
            numRegEx = /([^:]*):([^:]*)/;
            numRes = numRegEx.exec(valPairRes[1]);

            if (!numRes || numRes && numRes.length !== 3) {
              throw new Error("Could not decode NumericToSimpleMap: " + valPairRes[1]);
            } // Add the item with the min and max range to our array


            items.push({
              min: baja.Double.DEFAULT.decodeFromString(numRes[1]).valueOf(),
              max: baja.Double.DEFAULT.decodeFromString(numRes[2]).valueOf(),
              value: value
            });
          }

          valPairRes = valPairRegEx.exec(protoRes[2]);
        }

        return new NumericToSimpleMap(items, defValue);
      }
      /**
       * Encode the NumericToSimpleMap to a String
       *
       * @return {String}
       */

    }, {
      key: "encodeToString",
      value: function encodeToString() {
        var str = "";

        if (this.$items.length === 0 && this.$def === null) {
          return "null";
        }

        str = "".concat(this.getValueType().toString(), " ");
        this.$items.forEach(function (item) {
          var encodedString = item.value.encodeToString(),
              value = "".concat(item.min, ":").concat(item.max, "=").concat(encodedString.replace(/;/g, ";;"), ";");
          str = str.concat(value);
        });

        if (this.$items.length > 0) {
          str = str.substring(0, str.length - 1);
        }

        if (this.$def !== null) {
          if (this.$items.length > 0) {
            str = str.concat(";");
          }

          var encodedString = this.$def.encodeToString();
          str = str.concat("default=".concat(encodedString.replace(/;/g, ";;")));
        }

        return str;
      }
    }, {
      key: "equals",

      /**
       * Equality test
       *
       * @param obj num
       * @return {Boolean}
       */
      value: function equals(obj) {
        var it, objIt, i;

        if (baja.hasType(obj) && obj.getType().equals(this.getType()) && obj.$items.length === this.$items.length) {
          // Compare items
          for (i = 0; i < this.$items.length; ++i) {
            it = this.$items[i];
            objIt = obj.$items[i];

            if (it.min !== objIt.min || it.max !== objIt.max || !it.value.equals(objIt.value)) {
              return false;
            }
          } // Compare default values


          if (this.$def === null) {
            return obj.$def === null;
          } else {
            if (obj.$def === null) {
              return false;
            } else {
              return obj.$def.equals(this.$def);
            }
          }
        }

        return false;
      }
    }, {
      key: "get",

      /**
       * Get a simple by its numeric value or return the default if no mapping.
       *
       * @param {Number} num
       * @return {baja.Simple} the value (or null if no default is specified).
       */
      value: function get(num) {
        var it, i;

        for (i = 0; i < this.$items.length; ++i) {
          it = this.$items[i];

          if (it.min <= num && num <= it.max) {
            return it.value;
          }
        }

        return this.$def;
      }
    }]);

    return NumericToSimpleMap;
  }(baja.Simple);
  /**
   * Default NumericToSimpleMap instance
   */


  NumericToSimpleMap.DEFAULT = new NumericToSimpleMap([], null);
  /**
   * Make a NumericToSimpleMap
   *
   * @param {Object} obj Object Literal for the method's arguments.
   * @param {String} obj.str the String encoding.
   * @return {NumericToSimpleMap}
   */

  NumericToSimpleMap.make = function (obj) {
    return NumericToSimpleMap.DEFAULT.make(obj);
  };

  return NumericToSimpleMap;
});
