function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Cody Short
 */

/**
 * API Status: **Private**
 * @module nmodule/converters/rc/EnumToSimpleMap
 */
define(['baja!', 'underscore'], function (baja, _) {
  "use strict";
  /**
   * A bajaux implementation of an EnumToSimpleMap converter.
   * @alias module:nmodule/converters/rc/EnumToSimpleMap
   * @extends baja.Simple
   */

  var EnumToSimpleMap = /*#__PURE__*/function (_baja$Simple) {
    _inherits(EnumToSimpleMap, _baja$Simple);

    var _super = _createSuper(EnumToSimpleMap);

    /**
     * The representation of values in the map.
     * @typedef {Object} module:converters/rc/EnumToSimpleMap/Item
     * @property {number} min
     * @property {number} max
     * @property {value} baja.Simple
     */

    /**
     * A Component that represents a Niagara 'converters:EnumToSimpleMap' Type.
     *
     * @name EnumToSimpleMap
     * @extends baja.Simple
     * @param {Array<module:converters/rc/EnumToSimpleMap/Item>} items
     * @param {baja.Simple} def
     */
    function EnumToSimpleMap(items, def) {
      var _this;

      _classCallCheck(this, EnumToSimpleMap);

      _this = _super.apply(this, arguments);
      _this.$items = items;
      _this.$def = def;
      return _this;
    }
    /**
     * Make an EnumToSimpleMap
     *
     * @param {Object|string} obj Object Literal for the method's arguments.
     *   or the string encoding to be loaded in. 
     * @param {String} [obj.str] the String encoding.
     * @param {Array<module:converters/rc/EnumToSimpleMap/Item>} [obj.items] the items that are mapped
     * @param {baja.Simple} [obj.default] the default value of the map
     * @return {EnumToSimpleMap}
     */


    _createClass(EnumToSimpleMap, [{
      key: "make",
      value: function make(obj) {
        if (obj && (obj.def || obj.items)) {
          var _items = obj.items || [],
              def = obj.def || null;

          return new EnumToSimpleMap(_items, def);
        }

        obj = baja.objectify(obj, "str");

        if (!obj || !obj.str) {
          throw new Error("EnumToSimpleMap.make passed invalid value");
        }

        if (obj.str === "null") {
          return EnumToSimpleMap.DEFAULT;
        } // Get the prototype instance (used to decode everything else)


        var protoRes = /^([^ ]+) (.*)/.exec(obj.str);

        if (protoRes.length <= 1) {
          throw new Error("Cannot decode EnumToSimpleMap" + obj.str);
        } // Decode the prototype simple we're going to decode from


        var proto = baja.$(protoRes[1]); // Separate out the value pairs

        var valPairRegEx = /([^;]*)=(([^;]|;;)*)/g;
        var valPairRes,
            defValue = null,
            value,
            items = [];
        valPairRes = valPairRegEx.exec(protoRes[2]);

        while (valPairRes) {
          // Decode the value from the String
          var encodedValue = valPairRes[2].replace(/;;/g, ";");
          value = proto.decodeFromString(encodedValue);

          if (valPairRes[1] === "default") {
            defValue = value;
          } else {
            //parse comma-delimited ordinals
            var ordinals = valPairRes[1].split(',');
            ordinals.forEach(function (ordinalStr) {
              items.push({
                ordinal: parseInt(ordinalStr, 10),
                value: value
              });
            });
          }

          valPairRes = valPairRegEx.exec(protoRes[2]);
        }

        return new EnumToSimpleMap(items, defValue);
      }
    }, {
      key: "decodeFromString",

      /**
       * Decode a EnumToSimpleMap
       *
       * @param {String} str
       * @return {EnumToSimpleMap}
       */
      value: function decodeFromString(str) {
        return EnumToSimpleMap.make(str);
      }
    }, {
      key: "decodeAsync",

      /**
       *
       * @param {string} str
       * @param {baja.comm.Batch} [batch]
       * @return {Promise}
       */
      value: function decodeAsync(str, batch) {
        if (str === "null") {
          return Promise.resolve(EnumToSimpleMap.DEFAULT);
        } // Get the prototype instance (used to decode everything else)


        var protoRes = /^([^ ]+) (.*)/.exec(str);

        if (protoRes.length <= 1) {
          throw new Error("Cannot decode EnumToSimpleMap" + str);
        } // Decode the prototype simple we're going to decode from


        var typeToImport = protoRes[1];
        return Promise.resolve(baja.importTypes({
          typeSpecs: [typeToImport],
          batch: batch
        })).then(function () {
          return EnumToSimpleMap.make(str);
        });
      }
    }, {
      key: "encodeToString",

      /**
       * Encode the EnumToSimpleMap to a String
       *
       * @return {String}
       */
      value: function encodeToString() {
        var str = "";

        if (this.$items.length === 0 && this.$def === null) {
          return "null";
        }

        str = "".concat(this.getValueType().toString(), " ");
        this.$items.forEach(function (item) {
          var encodedString = item.value.encodeToString(),
              value = "".concat(item.ordinal, "=").concat(encodedString.replace(/;/g, ";;"), ";");
          str = str.concat(value);
        });

        if (this.$items.length > 0) {
          str = str.substring(0, str.length - 1);
        }

        if (this.$def !== null) {
          if (this.$items.length > 0) {
            str = str.concat(";");
          }

          var encodedString = this.$def.encodeToString();
          str = str.concat("default=".concat(encodedString.replace(/;/g, ";;")));
        }

        return str;
      }
    }, {
      key: "isNull",

      /**
       * Determines whether the EnumToSimpleMap is null based upon items.
       * @returns {boolean}
       */
      value: function isNull() {
        return this.$items.length === 0;
      }
      /**
       * Gets the values from items
       * @returns {Array.<baja.Simple>}
       */

    }, {
      key: "getValues",
      value: function getValues() {
        return _.pluck(this.$items, 'value');
      }
      /**
       * Gets the ordinals from items
       * @returns {Array.<number>}
       */

    }, {
      key: "getOrdinals",
      value: function getOrdinals() {
        return _.pluck(this.$items, 'ordinal');
      }
      /**
       * Gets the default values
       * @returns {baja.Simple|null}
       */

    }, {
      key: "getDefault",
      value: function getDefault() {
        return this.$def;
      }
      /**
       * Determines the type of values in the map.
       * @returns {baja.Type|null}
       */

    }, {
      key: "getValueType",
      value: function getValueType() {
        if (this.$def) {
          return this.$def.getType();
        } else if (this.$items.length > 0) {
          return this.$items[0].value.getType();
        }

        return null;
      }
      /**
       * Equality test
       *
       * @param {Object} obj
       * @return {boolean}
       */

    }, {
      key: "equals",
      value: function equals(obj) {
        var it, objIt, i;

        if (baja.hasType(obj) && obj.getType().equals(this.getType()) && obj.$items.length === this.$items.length) {
          // Compare items
          for (i = 0; i < this.$items.length; ++i) {
            it = this.$items[i];
            objIt = obj.$items[i];

            if (it.ordinal !== objIt.ordinal || !it.value.equals(objIt.value)) {
              return false;
            }
          } // Compare default values


          if (this.$def === null) {
            return obj.$def === null;
          } else {
            if (obj.$def === null) {
              return false;
            } else {
              return obj.$def.equals(this.$def);
            }
          }
        }

        return false;
      }
    }, {
      key: "get",

      /**
       * Get a simple by its ordinal value or return the default if no mapping.
       *
       * @param {number} ordinal
       * @return {baja.Simple} the value (or null if no default is specified).
       */
      value: function get(ordinal) {
        var it = this.$items,
            i;

        for (i = 0; i < it.length; ++i) {
          if (it[i].ordinal === ordinal) {
            return it[i].value;
          }
        }

        return this.$def;
      }
    }], [{
      key: "make",

      /**
       * Make an EnumToSimpleMap
       *
       * @param {Object|string} obj Object Literal for the method's arguments.
       *   or the string encoding to be loaded in.
       * @param {String} obj.str the String encoding.
       * @param {Array<module:converters/rc/EnumToSimpleMap/Item>} [obj.items] the items that are mapped
       * @param {baja.Simple} [obj.default] the default value of the map
       * @return {EnumToSimpleMap}
       */
      value: function make(obj) {
        return EnumToSimpleMap.DEFAULT.make(obj);
      }
    }]);

    return EnumToSimpleMap;
  }(baja.Simple);
  /**
   * Default NumericToSimpleMap instance
   */


  EnumToSimpleMap.DEFAULT = new EnumToSimpleMap([], null);
  return EnumToSimpleMap;
});
