/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

define(['lex!bacnet',
        'nmodule/webEditors/rc/wb/table/model/columns/IconColumn',
        'nmodule/webEditors/rc/wb/table/model/columns/PropertyColumn',
        'nmodule/webEditors/rc/wb/table/tree/TreeTableModel'], function (
         lexs,
         IconColumn,
         PropertyColumn,
         TreeTableModel) {

  'use strict';

  var bacnetLex = lexs[0];

  var DiscoveryIconColumn = function () {
    IconColumn.apply(this, arguments);
  };
  DiscoveryIconColumn.prototype = Object.create(IconColumn.prototype);
  DiscoveryIconColumn.prototype.constructor = DiscoveryIconColumn;

  DiscoveryIconColumn.prototype.getValueFor = function (row) {
    return row.getSubject().getIcon();
  };

  var COLUMNS = [
    new DiscoveryIconColumn(),
    new PropertyColumn('objectName', {
      displayName: bacnetLex.get('configManager.objectName')
    }),
    new PropertyColumn('objectId', {
      displayName: bacnetLex.get('learn.objectId')
    }),
    new PropertyColumn('value', {
      displayName: bacnetLex.get('configManager.value')
    }),
    new PropertyColumn('description', {
      displayName: bacnetLex.get('configManager.description')
    })
  ];

  /**
   * API Status: **Private**
   * @exports nmodule/bacnet/rc/wb/mgr/model/BacnetConfigLearnModel
   */
  var exports = {};

  /**
   * @returns {Promise.<module:nmodule/webEditors/rc/wb/table/tree/TreeTableModel>}
   */
  exports.make = function () {
    return TreeTableModel.make({ columns: COLUMNS });
  };

  return (exports);
});
