/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 */

/* jshint browser: true */

/**
 * API Status: **Private**
 * @module nmodule/bacnet/rc/util/BacnetConst
 */
define([ 'lex!bacnet' ], function (lexs) {

  'use strict';

  var exports = {},
      bacnetLex = lexs[0];

  exports.ASN_NULL = 0;
  exports.ASN_BOOLEAN = 1;
  exports.ASN_UNSIGNED = 2;
  exports.ASN_INTEGER = 3;
  exports.ASN_REAL = 4;
  exports.ASN_DOUBLE = 5;
  exports.ASN_OCTECT_STRING = 6;
  exports.ASN_CHARACTER_STRING = 7;
  exports.ASN_BIT_STRING = 8;
  exports.ASN_ENUMERATED = 9;
  exports.ASN_DATE = 10;
  exports.ASN_TIME = 11;
  exports.ASN_OBJECT_IDENTIFIER = 12;
  exports.ASHRAE_RESERVED_13 = 13;
  exports.ASHRAE_RESERVED_14 = 14;
  exports.ASHRAE_RESERVED_15 = 15;

  /** Special data types */

  exports.ASN_CONSTRUCTED_DATA = -1;
  exports.ASN_BACNET_ARRAY = -2;
  exports.ASN_BACNET_LIST = -3;
  exports.ASN_ANY = -4;
  exports.ASN_CHOICE = -5;
  exports.ASN_UNKNOWN_PROPRIETARY = -6;

  /** Prefixes for naming new enumerations */

  exports.ASHRAE_PREFIX = bacnetLex.get('enum.ashrae');
  exports.PROPRIETARY_PREFIX = bacnetLex.get('enum.proprietary');

  return exports;
});
