/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/bacnet/rc/baja/config/BacnetBinary
 */
define(['nmodule/bacnet/rc/baja/BacnetObject',
        'nmodule/webEditors/rc/baja/bajaUtils'], function (
         BacnetObject,
         bajaUtils) {

  'use strict';

  var proxySlotFacets = bajaUtils.proxySlotFacets;

  /**
   * BajaScript representation of an `bacnet:BacnetBinary` value.
   *
   * @class
   * @extends {module:nmodule/bacnet/rc/baja/BacnetObject}
   * @alias {module:nmodule/bacnet/rc/baja/config/BacnetBinary}
   */
  var BacnetBinary = function BacnetBinary() {
    BacnetObject.apply(this, arguments);
    proxySlotFacets(this, {
      '^(alarm|feedback|present)Value|relinquishDefault$': 'facets'
    });
  };
  BacnetBinary.prototype = Object.create(BacnetObject.prototype);
  BacnetBinary.prototype.constructor = BacnetBinary;

  return BacnetBinary;
});
