/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author JJ Frankovich
 */

/**
 * API Status: **Private**
 * @module nmodule/seriesTransform/rc/SeriesTransformFactory
 */
define([
  'Promise',
  'nmodule/webChart/rc/model/BaseChartFactory',
  'nmodule/seriesTransform/rc/SeriesTransformSeries' ], function (
    Promise,
    BaseChartFactory,
    SeriesTransformSeries) {

  "use strict";

  /**
   * The factory for TransformGraph which simply generates SeriesTransformSeries
   *
   * @class
   * @extends module:nmodule/webChart/rc/model/BaseChartFactory
   * @alias module:nmodule/seriesTransform/rc/SeriesTransformFactory
   */
  var SeriesTransformFactory = function () {
    BaseChartFactory.apply(this, arguments);
  };
  SeriesTransformFactory.prototype = new BaseChartFactory();
  SeriesTransformFactory.prototype.constructor = SeriesTransformFactory;

  /**
   * Return one SeriesTransformSeries per value
   * @param {module:nmodule/webChart/rc/model/BaseModel} model
   * @param {baja.Subscriber} subscriber
   * @param {Object} seriesParams
   * @param {baja.Value} seriesParams.value
   * @param {baja.Ord} seriesParams.ord
   * @returns {Promise.<module:nmodule/seriesTransform/rc/SeriesTransformSeries>}
   */
  SeriesTransformFactory.prototype.factory = function (model, subscriber, seriesParams) {
    return Promise.resolve(new SeriesTransformSeries(model, seriesParams));
  };

  return SeriesTransformFactory;
});
