function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* eslint-env browser */

/**
 * @module bajaux/util/CommandButton
 */
define(['jquery', 'Promise', 'underscore', 'bajaux/events', 'bajaux/Widget', 'bajaux/commands/Command', 'bajaux/commands/ToggleCommand', 'bajaux/icon/iconUtils', 'nmodule/js/rc/log/Log'], function ($, Promise, _, events, Widget, Command, ToggleCommand, iconUtils, Log) {
  'use strict';

  var COMMAND_CHANGE_EVENT = events.command.CHANGE_EVENT,
      toHtml = iconUtils.toHtml,
      cmdButtonsWaiting = [],
      logError = Log.logMessage.bind(Log, 'nmodule.bajaux.rc.util.CommandButton', Log.Level.SEVERE);

  var updateAll = _.debounce(function () {
    cmdButtonsWaiting.forEach(function (button) {
      button.$updateDom()["catch"](logError);
    });
    cmdButtonsWaiting = [];
  }, 250);
  /**
   * When enabling/disabling multiple buttons at once, don't throttle each call
   * separately as they'll resolve at different times and give you multiple
   * repaints. Throttle all commands at once to minimize repaints.
   * @param {module:bajaux/util/CommandButton} cmdButton
   */


  function updateCommandButtonDom(cmdButton) {
    if (!_.contains(cmdButtonsWaiting, cmdButton)) {
      cmdButtonsWaiting.push(cmdButton);
      updateAll();
    }
  }
  /**
   * A widget for displaying and invoking a Command.
   *
   * @class
   * @extends module:bajaux/Widget
   * @alias module:bajaux/util/CommandButton
   */


  var CommandButton = function CommandButton() {
    Widget.apply(this, arguments);
  };

  CommandButton.prototype = Object.create(Widget.prototype);
  CommandButton.prototype.constructor = CommandButton;
  /**
   * Get the element that will hold the icon `img`s.
   *
   * @private
   * @returns {JQuery}
   */

  CommandButton.prototype.$getIconElement = function () {
    return this.jq().children('.display').children('.icon');
  };
  /**
   * Get the element that will hold the command's display name.
   *
   * @private
   * @returns {JQuery}
   */


  CommandButton.prototype.$getDisplayNameElement = function () {
    return this.jq().children('.display').children('.displayName');
  };
  /**
   * Arms a click handler that will invoke the loaded Command. Adds a
   * `CommandButton` CSS class.
   *
   * Technically, this widget can be initialized in any DOM element, but makes
   * the most sense in a `button` element.
   *
   * @param {JQuery} dom
   */


  CommandButton.prototype.doInitialize = function (dom) {
    var that = this;
    dom.on('click', function () {
      var cmd = that.value();

      if (cmd.isEnabled() && that.isEnabled()) {
        cmd.invoke()["catch"](logError);
      }
    });
    var el = dom[0];

    if (!el) {
      return;
    }

    el.classList.add('CommandButton');
    var displaySpan = document.createElement('span');
    displaySpan.className = 'display';
    var iconSpan = document.createElement('span');
    iconSpan.className = 'icon';
    var displayNameSpan = document.createElement('span');
    displayNameSpan.className = 'displayName';
    displaySpan.appendChild(iconSpan);
    displaySpan.appendChild(displayNameSpan);
    el.append(displaySpan);
  };
  /**
   * Updates the display name, description, icon, and enabled status of the
   * button widget. Should be called once on load and whenever the loaded
   * Command changes.
   *
   * @private
   * @returns {Promise} promise to be resolved when the DOM has finished
   * updating
   */


  CommandButton.prototype.$updateDom = function () {
    var that = this,
        jq = that.jq(),
        cmd = that.value();

    if (!jq || !jq.length) {
      return Promise.resolve();
    }

    return Promise.all([cmd.toDisplayName(), cmd.toDescription()]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
          displayName = _ref2[0],
          description = _ref2[1];

      if (!that.isInitialized()) {
        return;
      }

      var iconElement = that.$getIconElement(),
          displayNameElement = that.$getDisplayNameElement(),
          isToggled = cmd.isToggleCommand() && cmd.isSelected(),
          icon = cmd.getIcon(),
          cmdEnabled = cmd.isEnabled(),
          btnEnabled = that.isEnabled();
      jq.attr('title', description);
      displayNameElement.text(displayName);
      jq.toggleClass('ux-toggled', isToggled);
      return Promise.all([btnEnabled !== cmdEnabled && that.setEnabled(cmdEnabled), icon && toHtml(icon).then(function (html) {
        return iconElement.html(html);
      })]);
    });
  };
  /**
   * Loads a Command. Binds an event handler to update the DOM whenever the
   * Command's properties are changed.
   *
   * @param {module:bajaux/commands/Command} cmd
   * @returns {Promise} promise to be resolved when the `Command` is
   * loaded, or rejected if no `Command` given
   */


  CommandButton.prototype.doLoad = function (cmd) {
    if (!(cmd instanceof Command)) {
      throw new Error('Command required');
    }

    var that = this,
        changeHandler = that.$changeHandler;
    cmd.loading().then(function () {
      if (changeHandler) {
        cmd.off(COMMAND_CHANGE_EVENT, changeHandler);
      }

      cmd.on(COMMAND_CHANGE_EVENT, that.$changeHandler = function () {
        updateCommandButtonDom(that);
      });
    })["catch"](logError);
    return that.$updateDom();
  };
  /**
   * Removes the click handler and CSS class from `doInitialize`.
   */


  CommandButton.prototype.doDestroy = function () {
    this.jq().removeClass('CommandButton').removeClass('ux-disabled');
    var cmd = this.value();

    if (cmd) {
      cmd.off(COMMAND_CHANGE_EVENT, this.$changeHandler);
    }
  };
  /**
   * Adds or removes the `disabled` property from the DOM.
   *
   * @param {Boolean} enabled
   */


  CommandButton.prototype.doEnabled = function (enabled) {
    this.jq().prop('disabled', !enabled).toggleClass('ux-disabled', !enabled);
  };

  return CommandButton;
});
