function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* eslint-env browser */
define(['bajaux/spandrel/buildConfig', 'bajaux/spandrel/util', 'underscore'], function (buildConfig, util, _) {
  'use strict';

  var $IS_SPANDREL_SYMBOL = buildConfig.$IS_SPANDREL_SYMBOL,
      $KEY_SYMBOL = buildConfig.$KEY_SYMBOL;
  var isDynamic = util.isDynamic;
  var WIDGET_ATTRIBUTES = {
    enabled: true,
    formFactor: true,
    properties: true,
    readonly: true,
    value: true
  };
  /**
   * API Status: **Development**
   * @exports bajaux/spandrel/jsx
   */

  var exports = {};
  /**
   * @param {string|Function} type
   * @param {object|null} props
   * @param kids
   * @returns {module:bajaux/spandrel~SpandrelArg}
   */

  function jsxToSpandrel(type, props, kids) {
    var _ref;

    var dom, widgetType;
    props = props || {};
    var _props = props,
        spandrelKey = _props.spandrelKey,
        spandrelSrc = _props.spandrelSrc;

    if (typeof type === 'string') {
      dom = document.createElement(type);
    } else {
      dom = document.createElement(props.tagName || 'div');
      widgetType = type;
    }

    setProps(dom, props, !!widgetType);

    if (spandrelSrc) {
      if (kids.length) {
        throw new Error('spandrelSrc cannot be combined with children');
      }

      if (typeof type !== 'string') {
        throw new Error('spandrelSrc can only be applied to a DOM element');
      }

      var sp = spandrelSrc.toSpandrel({
        dom: dom
      });

      if (_typeof(sp) === 'object' && !Array.isArray(sp)) {
        sp[$IS_SPANDREL_SYMBOL] = true;

        if (spandrelKey) {
          sp[$KEY_SYMBOL] = spandrelKey;
        }
      }

      return sp;
    }

    var _props2 = props,
        enabled = _props2.enabled,
        formFactor = _props2.formFactor,
        properties = _props2.properties,
        readonly = _props2.readonly,
        value = _props2.value;

    if (typeof enabled === 'string') {
      enabled = enabled !== 'false';
    }

    if (typeof readonly === 'string') {
      readonly = readonly !== 'false';
    }

    if (typeof value === 'undefined' && isDynamic(type)) {
      value = null;
    }

    if (!kids.length) {
      kids = undefined;
    } else {
      kids.forEach(function (kid, i) {
        if (!kid) {
          return;
        }

        if (typeof kid === 'string') {
          dom.appendChild(document.createTextNode(kid));
          kids = undefined;
        } else {
          kid.key = kid.key || String(i);
        }
      });
    }

    return _ref = {}, _defineProperty(_ref, $IS_SPANDREL_SYMBOL, true), _defineProperty(_ref, $KEY_SYMBOL, spandrelKey), _defineProperty(_ref, "dom", dom), _defineProperty(_ref, "enabled", enabled), _defineProperty(_ref, "formFactor", formFactor), _defineProperty(_ref, "kids", kids), _defineProperty(_ref, "properties", properties), _defineProperty(_ref, "readonly", readonly), _defineProperty(_ref, "type", widgetType), _defineProperty(_ref, "value", value), _ref;
  }

  function setProps(el, props, isWidget) {
    Object.keys(props).forEach(function (name) {
      return setProp(el, name, props[name], isWidget);
    });
  }

  function setProp(el, name, value, isWidget) {
    if (isWidget && WIDGET_ATTRIBUTES[name]) {
      return;
    }

    if (name === '$init') {
      return value(el);
    }

    if (name === 'spandrelKey' || name === 'spandrelSrc') {
      return;
    }

    if (name === 'className') {
      name = 'class';
    }

    if (name === 'style' && _typeof(value) === 'object') {
      var style = el.style;
      Object.keys(value).forEach(function (prop) {
        style[prop] = value[prop];
      });
    } else if (typeof value === 'boolean') {
      if (value) {
        el.setAttribute(name, true);
      }

      el[name] = value;
    } else {
      el.setAttribute(name, value);
    }
  }
  /**
   * @param {string|Function} type HTML tag name, or a Widget constructor to instantiate
   * @param {object|null} props
   * @param {Array.<object>} children
   * @returns {module:bajaux/spandrel~SpandrelArg}
   *
   * @example
   * <caption>Basic JSX->spandrel example</caption>
   * &#37;** @jsx spandrel.jsx *&#37;
   * class ComponentToHTML extends spandrel((comp) => {
   *   return (
   *     <table>
   *     {
   *       comp.getSlots().properties().toArray().map((prop) => {
   *         return <tr>
   *           <td>{ prop.getName() }</td>
   *           <td>{ prop.getType() }</td>
   *         </tr>;
   *       })
   *     }
   *     </table>
   *   );
   * }) {}
   */


  exports.jsxToSpandrel = function (type, props) {
    for (var _len = arguments.length, children = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
      children[_key - 2] = arguments[_key];
    }

    return jsxToSpandrel(type, props, _.flatten(children));
  };

  return exports;
});
