function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* eslint-env browser */

/**
 * @private
 * @module bajaux/spandrel/buildConfig
 */
define(['Promise', 'underscore'], function (Promise, _) {
  'use strict';

  var KEY_SYMBOL = Symbol('spandrelKey');
  var IS_SPANDREL_SYMBOL = Symbol('isSpandrel');
  var IS_DYNAMIC_SYMBOL = Symbol('isDynamic');
  var ROOT_SYMBOL = Symbol('spandrelRoot');
  var DEPTH_SYMBOL = Symbol('spandrelDepth');
  /**
   * Given spandrel input (potentially dynamically generated), spit out a JSON
   * array, where each member may potentially contain more nested data, that
   * will map to one or more fe.buildFor calls.
   *
   * @private
   * @alias module:bajaux/spandrel/buildConfig
   * @param {string|Array.<object>|Object} arg
   * @param {module:bajaux/spandrel~WidgetState} widgetState configuration data derived
   * from the parent widget to contain all these spandrel-generated widgets
   * @returns {Promise.<module:bajaux/spandrel~BuildContext>}
   */

  function buildConfig(arg) {
    var widgetState = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    widgetState = _.extend({
      props: widgetState.properties
    }, widgetState);
    var normalizedOn;

    var handleArg = function handleArg(spandrelArg, key) {
      key = String(spandrelArg && spandrelArg[KEY_SYMBOL] || key);
      return Promise.resolve(handleSpandrelArg(spandrelArg, key, widgetState)).then(function (member) {
        if (!spandrelArg) {
          return member;
        }

        normalizedOn = (normalizedOn || []).concat(normalizeOn(spandrelArg.on, key));
        return member;
      });
    };

    if (isHtml(arg) || !arg) {
      return Promise.all([handleArg(arg, 0)]).then(function (members) {
        return {
          members: members,
          on: []
        };
      });
    }

    if (Array.isArray(arg)) {
      return Promise.all(arg.map(handleArg)).then(function (members) {
        return {
          members: members,
          on: normalizedOn
        };
      });
    }

    if (_typeof(arg) === 'object') {
      if (arg[IS_SPANDREL_SYMBOL]) {
        return buildConfig([arg]);
      }

      var on = arg.on,
          kids = arg.kids;

      if (kids || on) {
        if (arg.dom) {
          // if dom is specified, we want one kid widget, with kids built under that.
          return Promise.all([handleArg(arg, '0')]).then(function (members) {
            return {
              members: members,
              on: normalizedOn
            };
          });
        } else {
          normalizedOn = normalizeOn(on); // if no dom is specified, we want kids built directly.

          return Promise.all(_.map(kids, function (kid, key) {
            return handleArg(kid, String(key));
          })).then(function (members) {
            return {
              members: members,
              on: normalizedOn
            };
          });
        }
      }

      return Promise.all(Object.keys(arg).map(function (k) {
        return handleArg(arg[k], k);
      })).then(function (members) {
        return {
          members: members,
          on: normalizedOn || []
        };
      });
    }

    return Promise.reject(new Error('cannot configure spandrel widget from ' + arg));
  }
  /**
   * @param {Array} on the `on` event handlers as provided by the user. The
   * members may be of the form `[ event, handler ]` or `[ event, selector, handler ]`.
   * @param {string} [key] since the result handlers will be applied one level
   * up, if the input handlers should apply only to one nested widget key, the
   * key will be prepended to the selectors.
   * @returns {Array} the normalized `on` event handler arrays to be included
   * in the final BuildContext.
   */


  function normalizeOn(on, key) {
    if (!on || !on.length) {
      return [];
    }

    if (!Array.isArray(on[0])) {
      on = [on];
    }

    return on.map(function (on) {
      var _on = _slicedToArray(on, 3),
          event = _on[0],
          selector = _on[1],
          handler = _on[2];

      if (on.length < 3) {
        handler = selector;

        if (key) {
          selector = key + '/**/*';
        } else {
          selector = '**/*';
        }
      } else {
        if (key) {
          selector = key + '/' + selector;
        }
      }

      return [event, selector, handler];
    });
  }
  /**
   * Spandrel can take string values, arrays of values, or key -> value maps.
   * This function will handle one value in a potential collection of
   * arguments.
   *
   * @param {string|object} spandrelArg
   * @param {string} key
   * @param {object} widgetState
   * @returns {object|Promise.<object>} object with key and config properties
   */


  function handleSpandrelArg(spandrelArg, key, widgetState) {
    if (!spandrelArg) {
      return {
        key: key,
        config: {
          dom: '<wbr style="display: none;">'
        }
      };
    }

    if (isHtml(spandrelArg)) {
      return {
        key: key,
        config: rawStringToConfig(spandrelArg, widgetState)
      };
    } else {
      if (spandrelArg.key && spandrelArg.config) {
        //already a spandrel object
        //TODO: use a non-enumerable property instead of guessing
        return spandrelArg;
      }

      return Promise.resolve(objectToConfig(spandrelArg, widgetState)).then(function (config) {
        return {
          key: key,
          config: config
        };
      });
    }
  }

  function isHtml(dom) {
    return typeof dom === 'string' || dom instanceof Element;
  }
  /**
   * @param str raw html
   * @param widgetState parent widget config
   * @returns {object} config object that can be passed to fe.buildFor
   */


  function rawStringToConfig(str, widgetState) {
    return {
      dom: str,
      formFactor: 'mini'
    };
  }
  /**
   * @param spandrelArg arg as given to spandrel
   * @param widgetState parent widget config
   * @returns {object|Promise.<object>} config object that can be passed to
   * fe.buildFor
   */


  function objectToConfig(spandrelArg, widgetState) {
    var kids = spandrelArg.kids;
    var widgetProps = widgetState.properties;
    var argProps = spandrelArg.properties;

    if (typeof argProps === 'function') {
      argProps = argProps(_.extend({}, widgetProps));
    } else if (argProps === 'inherit') {
      argProps = widgetProps;
    }

    var config = _.extend({}, spandrelArg, {
      formFactor: spandrelArg.formFactor || 'mini'
    });

    if (argProps) {
      config.properties = argProps;
    }

    if (config.readonly === 'inherit' || config.readonly === undefined) {
      config.readonly = widgetState.readonly;
    }

    if (config.enabled === 'inherit' || config.enabled === undefined) {
      config.enabled = widgetState.enabled;
    }

    config.writable = config.enabled && !config.readonly;

    if (kids) {
      return buildConfig(kids, config).then(function (kids) {
        return _.extend(_.omit(config, 'on'), {
          kids: kids
        });
      });
    }

    return _.omit(config, 'on');
  } // make these invisible until explicitly needed to be public
  // store the spandrel key on the DOM element itself


  Object.defineProperty(buildConfig, '$KEY_SYMBOL', {
    value: KEY_SYMBOL
  }); // mark an object as spandrel data

  Object.defineProperty(buildConfig, '$IS_SPANDREL_SYMBOL', {
    value: IS_SPANDREL_SYMBOL
  }); // mark a DOM element, widget instance, or widget constructor as a dynamic spandrel widget

  Object.defineProperty(buildConfig, '$IS_DYNAMIC_SYMBOL', {
    value: IS_DYNAMIC_SYMBOL
  }); // store a reference to the root spandrel widget on one of its descendents

  Object.defineProperty(buildConfig, '$ROOT_SYMBOL', {
    value: ROOT_SYMBOL
  }); // store a spandrel widget's depth within the tree (root === 0)

  Object.defineProperty(buildConfig, '$DEPTH_SYMBOL', {
    value: DEPTH_SYMBOL
  });
  return buildConfig;
});
