function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module bajaux/spandrel/SpandrelWidget
 */
define(['bajaux/Widget', 'bajaux/events', 'Promise', 'underscore', 'bajaux/spandrel/util'], function (Widget, events, Promise, _, util) {
  'use strict';

  var MODIFY_EVENT = events.MODIFY_EVENT;
  var compact = _.compact,
      filter = _.filter,
      flatten = _.flatten,
      map = _.map,
      omit = _.omit;
  var kidsMatching = util.kidsMatching,
      pathMatches = util.pathMatches;
  var SWALLOWED_MODIFY = Symbol('swallowedModify');
  var NON_INHERITABLE_PROPERTIES = ['rootCssClass'];
  /**
   * @class
   * @alias module:bajaux/spandrel/SpandrelWidget
   * @extends module:bajaux/Widget
   */

  return /*#__PURE__*/function (_Widget) {
    _inherits(SpandrelWidget, _Widget);

    var _super = _createSuper(SpandrelWidget);

    function SpandrelWidget() {
      _classCallCheck(this, SpandrelWidget);

      return _super.apply(this, arguments);
    }

    _createClass(SpandrelWidget, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this = this;

        dom.on(MODIFY_EVENT, function (e) {
          // i need to listen for modify events from child elements, and mark
          // myself modified when i get one. but i can't just return false,
          // because events from deeper down in the tree of spandrel widgets need
          // to bubble up so the spandrel-native handlers higher up still work.
          // like for on: [ MODIFY_EVENT, '**/foo', () => {} ], events need to
          // bubble up from the nested foo widget.
          //
          // but if i let everything bubble willy nilly, then the events double-up
          // and i wind up with a O(n^2) performance problem.
          //
          // so i mark the event as "swallowed" so it still bubbles but doesn't
          // trigger any parent widgets to call setModified() forever.
          //
          // e.target === dom[0] when it's the event from my own setModified call.
          if (e.target !== dom[0] && !e[SWALLOWED_MODIFY]) {
            e[SWALLOWED_MODIFY] = true;

            _this.setModified(true);
          }
        });
        return _get(_getPrototypeOf(SpandrelWidget.prototype), "doInitialize", this).apply(this, arguments);
      }
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        return Promise.all(map(this.jq().children(), function (e) {
          var widget = Widget["in"](e);

          if (widget) {
            return widget.destroy();
          }
        }));
      }
    }, {
      key: "doChanged",
      value: function doChanged() {
        return this.rerender && this.rerender();
      }
      /**
       * @param {module:bajaux/Widget} kid
       * @returns {Array.<string>}
       */

    }, {
      key: "getPathToKid",
      value: function getPathToKid(kid) {
        if (kid === this) {
          return [];
        }

        var path = util.getPathToKid(this, kid);

        if (!path.length) {
          throw new Error('kid not actual child of this widget');
        }

        return path;
      }
      /**
       * @param {string} queryString a string, /-separated, to match spandrel keys
       * through the entire nested structure
       * @returns {module:bajaux/Widget|undefined} the first matching widget
       */

    }, {
      key: "queryWidget",
      value: function queryWidget(queryString) {
        return this.queryWidgets(queryString)[0];
      }
      /**
       * @param {string} queryString a string, /-separated, to match spandrel keys
       * through the entire nested structure
       * @returns {Array.<module:bajaux/Widget>} matching widgets
       */

    }, {
      key: "queryWidgets",
      value: function queryWidgets(queryString) {
        var _this2 = this;

        queryString = String(queryString);
        var widgets =
        /** @type {Array.<module:bajaux/Widget>} */
        [this];

        if (!queryString) {
          return widgets;
        }

        if (queryString.match(/\*\*/)) {
          //slow globbing
          return filter(this.jq().find('.bajaux-initialized'), function (el) {
            return el.spandrelKey;
          }).map(Widget["in"]).filter(function (w) {
            return pathMatches(util.getPathToKid(_this2, w).join('/'), queryString);
          });
        }

        queryString.split('/').forEach(function (key) {
          widgets = flatten(widgets.map(function (widget) {
            return kidsMatching(widget && widget.jq()[0], key).map(Widget["in"]);
          }));
        });
        return compact(widgets);
      }
      /**
       * @returns {module:bajaux/spandrel~WidgetState} widget state
       */

    }, {
      key: "state",
      value: function state(key, value) {
        switch (arguments.length) {
          case 0:
            var props = omit(this.properties().toObject(), NON_INHERITABLE_PROPERTIES),
                enabled = this.isEnabled(),
                readonly = this.isReadonly(),
                jq = this.jq();
            return _.extend({
              commands: this.getCommandGroup(),
              enabled: enabled,
              formFactor: this.getFormFactor(),
              modified: this.isModified(),
              properties: props,
              props: props,
              readonly: readonly,
              rootElement: jq && jq[0],
              writable: enabled && !readonly
            }, this.$state);

          case 1:
            if (!key || _typeof(key) !== 'object') {
              throw new Error('state map required');
            }

            this.$state = _.extend(this.$state || {}, key);
        }
      }
    }], [{
      key: "mixin",
      value: function mixin(Ctor) {
        var spandrelProt = SpandrelWidget.prototype;
        var ctorProt = Ctor.prototype;
        Object.getOwnPropertyNames(spandrelProt).forEach(function (method) {
          if (method === 'constructor') {
            return;
          }

          if (method.startsWith('do')) {
            var ctorMethod = ctorProt[method];
            var spandrelMethod = spandrelProt[method];

            ctorProt[method] = function () {
              var _this3 = this;

              for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
                args[_key] = arguments[_key];
              }

              return Promise.resolve(ctorMethod && ctorMethod.apply(this, args)).then(function () {
                return spandrelMethod.apply(_this3, args);
              });
            };
          } else {
            ctorProt[method] = spandrelProt[method];
          }
        });
      }
    }]);

    return SpandrelWidget;
  }(Widget);
});
