function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* eslint-env browser */

/**
 * API Status: **Development**
 * @module bajaux/spandrel
 */
define(['log!bajaux.spandrel', 'bajaux/Widget', 'bajaux/lifecycle/WidgetManager', 'jquery', 'Promise', 'underscore', 'nmodule/js/rc/switchboard/switchboard', 'bajaux/spandrel/buildConfig', 'bajaux/spandrel/diff', 'bajaux/spandrel/jsx', 'bajaux/spandrel/RequestLayoutMixin', 'bajaux/spandrel/SpandrelWidget', 'bajaux/spandrel/util'], function (log, Widget, WidgetManager, $, Promise, _, switchboard, buildConfig, diff, jsx, RequestLayoutMixin, SpandrelWidget, util) {
  'use strict';

  var TRACE = log.isLoggable('FINEST');
  var logFinest = log.finest.bind(log);
  var defaultManager = new WidgetManager();
  var $DEPTH_SYMBOL = buildConfig.$DEPTH_SYMBOL,
      $IS_DYNAMIC_SYMBOL = buildConfig.$IS_DYNAMIC_SYMBOL,
      $ROOT_SYMBOL = buildConfig.$ROOT_SYMBOL;
  var diffBuildContexts = diff.diffBuildContexts;
  var any = _.any,
      difference = _.difference,
      extend = _.extend,
      isArray = _.isArray,
      last = _.last,
      lastIndexOf = _.lastIndexOf;
  var getContainingSpandrelWidget = util.getContainingSpandrelWidget,
      getInlineStyles = util.getInlineStyles,
      getPathToKid = util.getPathToKid,
      kidsMatching = util.kidsMatching,
      pathMatches = util.pathMatches,
      requiresRebuild = util.requiresRebuild,
      updateElement = util.updateElement;
  var PRIORITY_UPDATE = 1;
  var PRIORITY_REBUILD = 2;
  var PATH_TO_KID_CONTEXTS = ['config', 'kids', 'members'];
  /**
   * The purpose of `spandrel` is to provide a reasonably pure-functional,
   * diffable method of defining a nested structure of bajaux Widgets and
   * supporting HTML. Rather than require Widget implementors to manually code
   * calls to `initialize()` or `buildFor()`, `spandrel` allows you to provide
   * your desired structure of HTML elements and their associated Widget
   * instances, and handle the work of updating the document as that structure
   * may change over time.
   *
   * See {@tutorial spandrel} for in-depth information.
   *
   * @alias module:bajaux/spandrel
   * @param {module:bajaux/spandrel~SpandrelArg} arg
   * @param {object} [params={}] params
   * @param {function(new:module:bajaux/Widget)} [params.extends] optionally specify a Widget superclass to extend
   * @param {module:bajaux/lifecycle/WidgetManager} [params.manager] optionally provide your own WidgetManager to manage Widget lifecycle
   * @returns {Function} a Widget constructor
   * @since Niagara 4.10
   *
   * @example
   * <caption>Generate a static widget</caption>
   * const StaticWidget = spandrel([
   *   '<label>Name: </label>',
   *   '<input type="text" value="{{ props.name }}">',
   *   {
   *     dom: '<span></span>',
   *     value: false,
   *     properties: 'inherit'
   *   }
   * ]);
   * return fe.buildFor({
   *   dom: $('#myStaticWidget'),
   *   type: StaticWidget,
   *   properties: { name: 'Logan', trueText: 'Good', falseText: 'Not So Good' }
   * });
   *
   * @example
   * <caption>Generate a dynamic widget with a field editor for each slot</caption>
   * const DynamicWidget = spandrel(comp => comp.getSlots().toArray().map(slot => ({
   *   dom: '<div class="componentSlot"/>',
   *   kids: [
   *     `<label>${ slot.getName() }: </label>`,
   *     { dom: '<span/>', complex: comp, slot: slot }
   *   ]
   * })));
   *
   * return fe.buildFor({
   *   dom: $('#myDynamicWidget'),
   *   type: DynamicWidget,
   *   value: myComponent
   * });
   *
   * @example
   * <caption>Subclass an existing dynamic spandrel widget, making changes
   * before rendering.</caption>
   *
   * // our superclass will render a <label> element, with a background
   * // determined by a widget property.
   * const LabelWidget = spandrel((value, { properties }) => {
   *   const label = document.createElement('label');
   *   label.innerText = value;
   *   label.style.background = properties.background || '';
   *   return label;
   * });
   *
   * const RedLabelWidget = spandrel((value, { renderSuper }) => {
   *
   *   // renderSuper will call back to the superclass, allowing your subclass
   *   // to edit the data before spandrel renders it to the page.
   *   //
   *   // you can optionally pass a function to renderSuper that will tweak the
   *   // widget state before the superclass renders its data. if no tweaking is
   *   // desired, just renderSuper() is fine.
   *   //
   *   return renderSuper((state) => {
   *     state.properties.background = 'lightpink';
   *
   *     // remember to return the new state.
   *     return state;
   *   })
   *     .then((label) => {
   *       // renderSuper will resolve the data exactly as rendered by the
   *       // superclass.
   *       label.style.color = 'red';
   *       return label;
   *     });
   * }, { extends: LabelWidget });
   */

  function spandrel(arg, params) {
    if (typeof arg === 'function') {
      //dynamically redefine the nested widget structure based on whatever
      //value is being loaded.
      return makeDynamic(arg, params);
    } else {
      // define a static nested widget structure.
      return makeStatic(arg, params);
    }
  }
  /**
   * Given spandrel input (potentially dynamically generated), spit out a build
   * context, where each member may potentially contain more nested data, that
   * will map to one or more fe.buildFor calls.
   *
   * @private
   * @param {module:bajaux/spandrel~SpandrelArg} arg
   * @param {module:bajaux/spandrel~WidgetState} widgetState configuration data derived
   * from the parent widget to contain all these spandrel-generated widgets
   * @returns {Promise.<module:bajaux/spandrel~BuildContext>}
   */


  spandrel.build = function (arg, widgetState) {
    return buildConfig(arg, widgetState);
  };
  /**
   * Use `spandrel.jsx` as your JSX pragma to convert your JSX into spandrel
   * config.
   *
   * @see module:bajaux/spandrel/jsx
   */


  spandrel.jsx = jsx.jsxToSpandrel;
  /**
   * @private
   * @param {module:bajaux/lifecycle/WidgetManager} manager
   */

  spandrel.$installDefaultWidgetManager = function (manager) {
    defaultManager = manager;
  };
  /**
   * @private
   * @returns {module:bajaux/lifecycle/WidgetManager}
   */


  spandrel.$getDefaultWidgetManager = function () {
    return defaultManager;
  };
  /**
   * @param {function(*): module:bajaux/spandrel~SpandrelArg} func
   * @param {Object} [params]
   * @param {Function} [params.extends]
   * @param {module:bajaux/lifecycle/WidgetManager} [params.manager]
   * @returns {function(new:module:bajaux/spandrel/SpandrelWidget)}
   */


  function makeDynamic(func) {
    var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
        Super = _ref["extends"],
        manager = _ref.manager;

    var DynamicSpandrelWidget = /*#__PURE__*/function (_ref2) {
      _inherits(DynamicSpandrelWidget, _ref2);

      var _super = _createSuper(DynamicSpandrelWidget);

      function DynamicSpandrelWidget(params) {
        var _this;

        _classCallCheck(this, DynamicSpandrelWidget);

        _this = _super.apply(this, arguments);
        _this.$manager = extractManager(params) || manager;
        switchboard(_assertThisInitialized(_this), {
          render: {
            allow: 'oneAtATime',
            onRepeat: 'preempt'
          }
        });
        RequestLayoutMixin(_assertThisInitialized(_this));
        _this[$IS_DYNAMIC_SYMBOL] = true;
        return _this;
      }

      _createClass(DynamicSpandrelWidget, [{
        key: "initialize",
        value: function initialize(dom, params, layoutParams) {
          return _get(_getPrototypeOf(DynamicSpandrelWidget.prototype), "initialize", this).call(this, dom, params, Object.assign({
            quick: true
          }, layoutParams));
        }
      }, {
        key: "doLoad",
        value: function doLoad(value) {
          return this.render(value);
        }
        /**
         * @private
         * @param {*} value the value being loaded
         * @param {module:bajaux/spandrel~WidgetState} state the widget state
         * @returns {Promise.<*>} data produced by the widget, ready to be
         * rendered by spandrel
         */

      }, {
        key: "$render",
        value: function $render(value, state) {
          var rootElement = state.rootElement;
          var oldClass = rootElement.getAttribute('class');
          var oldStyle = rootElement.getAttribute('style');
          var oldStyles = getInlineStyles(rootElement); // here, we make a copy because:
          // - we need to keep track of precisely what classes the widget adds to
          //   its classList, therefore we have to start with a blank classList.
          // - if we just set the classList to empty on the real live element,
          //   class-based selectors will stop working if the selection happens
          //   while the element is in the 'in-between' state while
          //   $renderSpandrelData is being called.

          var copyClassList = document.createElement(rootElement.tagName).classList;
          var origClassList = rootElement.classList;
          setClassList(rootElement, copyClassList);
          return this.$renderSpandrelData(value, state).then(function (spandrelArg) {
            var addedClasses = Array.prototype.slice.call(copyClassList);
            var addedStyles = getInlineStyles(rootElement); // record styles explicitly removed

            var oldProps = Object.keys(oldStyles);

            for (var i = 0, len = oldProps.length; i < len; i++) {
              var prop = oldProps[i];

              if (oldStyles[prop] && !addedStyles[prop]) {
                addedStyles[prop] = '';
              }
            }

            setClassList(rootElement, origClassList);
            attr(rootElement, 'class', oldClass);
            attr(rootElement, 'style', oldStyle);
            rootElement[$IS_DYNAMIC_SYMBOL] = true;
            return {
              spandrelArg: spandrelArg,
              addedClasses: addedClasses,
              addedStyles: addedStyles
            };
          });
        }
        /**
         * Calls the render function that defines the class (the argument to
         * `spandrel` itself).
         * @param {*} value the value being loaded
         * @param {module:bajaux/spandrel~WidgetState} state the widget state
         * @returns {Promise}
         */

      }, {
        key: "$renderSpandrelData",
        value: function $renderSpandrelData(value, state) {
          var _this2 = this;

          var widgetState = extend({}, state, {
            renderSuper: function renderSuper(func) {
              if (typeof func === 'function') {
                return Promise.resolve(func(state)).then(function (newState) {
                  return _get(_getPrototypeOf(DynamicSpandrelWidget.prototype), "$renderSpandrelData", _this2).call(_this2, value, newState);
                });
              } else {
                return _get(_getPrototypeOf(DynamicSpandrelWidget.prototype), "$renderSpandrelData", _this2).call(_this2, value, state);
              }
            }
          });
          return Promise.resolve(func.call(this, value, widgetState));
        }
        /**
         * Pass the given value back through the spandrel processing function,
         * regenerating the widget's structure as appropriate. This differs from
         * `load()` in that it changes the DOM structure only - it does not fire
         * load events or change the result of `this.value()`.
         *
         * @param {*} value
         * @param {module:bajaux/spandrel~WidgetState} [state] widget
         * state to use; if omitted the widget's current state will be used
         * @returns {Promise}
         */

      }, {
        key: "render",
        value: function render(value, state) {
          var _this3 = this;

          return Promise["try"](function () {
            return _this3.$render(value, state || _this3.state()).then(function (result) {
              return _this3.$doBuild(result);
            }).then(function () {
              _this3.$loadFinished = true;
              return _this3.layout({
                quick: _this3 !== _this3[$ROOT_SYMBOL]
              });
            });
          })["catch"](function (err) {
            if (!_this3.$manager) {
              throw err;
            }

            return _this3.$manager.error(err, _this3);
          });
        } // TODO: rerender() needs to be smart about not wiping modified editors.
        // if called in response to a MODIFY_EVENT, it rebuilds the editor you
        // were typing in and you lose focus. c.f. LayoutEditor: i should be able
        // to just [ MODIFY_EVENT, () => this.rerender() ]
        // TODO: rerender() needs to handle when read() resolves a type that is
        // not compatible with load().

        /**
         * Re-renders the widget based on the result of `this.read()`.
         *
         * @param {module:bajaux/spandrel~WidgetState} [state]
         * @returns {Promise}
         */

      }, {
        key: "rerender",
        value: function rerender(state) {
          var _this4 = this;

          if (!this.isInitialized()) {
            return Promise.resolve();
          } //TODO: switchboard onlyAfter


          return Promise.resolve(this.$loadFinished && this.read().then(function (v) {
            return _this4.render(v, state);
          }));
        }
      }, {
        key: "layout",
        value: function layout() {
          if (!this.$loadFinished) {
            return Promise.resolve();
          }

          return _get(_getPrototypeOf(DynamicSpandrelWidget.prototype), "layout", this).apply(this, arguments);
        }
      }, {
        key: "doReadonly",
        value: function doReadonly() {
          return this.rerender();
        }
      }, {
        key: "doEnabled",
        value: function doEnabled() {
          return this.rerender();
        } //TODO: add lex support

      }, {
        key: "$doBuild",
        value: function $doBuild(_ref3) {
          var _this5 = this;

          var spandrelArg = _ref3.spandrelArg,
              addedClasses = _ref3.addedClasses,
              addedStyles = _ref3.addedStyles;
          var dom = this.jq();
          var widgetState = this.state();
          var mgr = this.$manager || spandrel.$getDefaultWidgetManager();
          var prevClasses;
          var prevStyles;
          return spandrel.build(spandrelArg, widgetState).then(function (curr) {
            var prev = _this5.$spandrel;
            var differences;

            if (prev) {
              differences = diffBuildContexts(prev.spandrelData, curr);
              prevClasses = prev.addedClasses;
              prevStyles = prev.addedStyles;
            }

            _this5.$spandrel = {
              spandrelData: curr,
              addedClasses: addedClasses,
              addedStyles: addedStyles
            };

            if (!prev) {
              return buildWidgetsFromSpandrelData(_this5, curr, dom, mgr);
            }

            return differences && applyDiffs(_this5, curr, prev.spandrelData, differences, _this5.jq()[0], mgr);
          }).then(function () {
            var rootElement = widgetState.rootElement;
            var classList = rootElement.classList,
                style = rootElement.style;

            if (prevClasses && prevClasses.length) {
              classList.remove.apply(classList, difference(prevClasses, addedClasses));
            }

            if (prevStyles) {
              var removedStyles = difference(Object.keys(prevStyles), Object.keys(addedStyles));

              for (var i = 0, len = removedStyles.length; i < len; ++i) {
                style.removeProperty(removedStyles[i]);
              }
            }

            if (addedClasses.length) {
              classList.add.apply(classList, addedClasses);
            }

            Object.assign(style, addedStyles);
          });
        }
      }]);

      return DynamicSpandrelWidget;
    }(Super || SpandrelWidget); //we need SpandrelWidget functionality even if we didn't inherit from it


    if (Super) {
      SpandrelWidget.mixin(Super);
    }

    DynamicSpandrelWidget[$IS_DYNAMIC_SYMBOL] = true;
    return DynamicSpandrelWidget;
  }

  function makeStatic(spandrelArg) {
    var _ref4 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
        _ref4$manager = _ref4.manager,
        manager = _ref4$manager === void 0 ? defaultManager : _ref4$manager;

    return /*#__PURE__*/function (_SpandrelWidget) {
      _inherits(_class, _SpandrelWidget);

      var _super2 = _createSuper(_class);

      function _class() {
        var _this6;

        _classCallCheck(this, _class);

        _this6 = _super2.apply(this, arguments);
        RequestLayoutMixin(_assertThisInitialized(_this6));
        return _this6;
      }

      _createClass(_class, [{
        key: "doInitialize",
        value: function doInitialize(dom) {
          var _this7 = this,
              _arguments = arguments;

          return spandrel.build(spandrelArg, this.state()).then(function (data) {
            return buildWidgetsFromSpandrelData(_this7, data, dom, manager);
          }).then(function () {
            return _get(_getPrototypeOf(_class.prototype), "doInitialize", _this7).apply(_this7, _arguments);
          });
        }
      }]);

      return _class;
    }(SpandrelWidget);
  }
  /**
   * @param {module:bajaux/Widget} widget
   * @param {module:bajaux/spandrel~BuildContext} buildConfig
   * @param {JQuery} dom
   * @param {module:bajaux/lifecycle/WidgetManager} manager
   * @returns {Promise}
   */


  function buildWidgetsFromSpandrelData(widget, buildConfig, dom, manager) {
    var members = buildConfig.members,
        on = buildConfig.on;

    if (on.length) {
      armHandlers(widget, dom, on);
    }

    return Promise.all(members.map(function (member) {
      return doFeBuild(member, $(member.config.dom).appendTo(dom), manager, widget[$ROOT_SYMBOL], widget[$DEPTH_SYMBOL] + 1);
    }));
  }
  /**
   * @param {module:bajaux/Widget} owner
   * @param {module:bajaux/spandrel~BuildContext} curr current spandrel build context
   * @param {module:bajaux/spandrel~BuildContext} prev previous spandrel build context
   * @param {Array.<object>} differences deep-diff differences between the two
   * @param {HTMLElement} rootElement root element of the spandrel Widget
   * @param {module:bajaux/lifecycle/WidgetManager} manager
   * @returns {Promise} to be resolved when differences are applied
   */


  function applyDiffs(owner, curr, prev, differences, rootElement, manager) {
    var findNodePath = function findNodePath() {
      var path = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
      var currMember = null,
          prevMember,
          currMembers = curr && curr.members,
          prevMembers = prev && prev.members;
      var keys = extractKeys(path).map(function (key) {
        currMember = currMembers[key] || {};
        prevMember = prevMembers[key] || {};
        currMembers = resolveObjectPath(currMember, PATH_TO_KID_CONTEXTS);
        prevMembers = resolveObjectPath(prevMember, PATH_TO_KID_CONTEXTS);
        return prevMember.key || key; //if the key changed, the old key is still in the dom
      });
      var node = keys.reduce(function (node, key) {
        return kidsMatching(node, key)[0];
      }, rootElement);
      return {
        node: node,
        keys: keys,
        member: currMember
      };
    };

    var edits = {};
    var root = owner[$ROOT_SYMBOL];
    var depth = owner[$DEPTH_SYMBOL] + 1;

    var doEdit = function doEdit(key, priority, _doEdit) {
      var existingEdit = edits[key];

      if (existingEdit && existingEdit.$priority === PRIORITY_REBUILD) {
        return existingEdit;
      } else {
        var promise = edits[key] = Promise.resolve(existingEdit).then(_doEdit);
        promise.$priority = priority;
        return promise;
      }
    };
    /*
    TODO: do we need to optimize this?
    if we got a diff for the top-level widget and the event handler on the
    kid widget at the same time, spandrel was destroying the parent (which
    also destroys the kid) and re-arming the event handler on the (destroyed)
    kid at the same time.
    for now, we'll run the promises in serial since deep-diff should return the
    diffs in top-to-bottom order. but maybe we could eke out some more
    performance if we ran promises in distinct branches (never same branch) in
    parallel.
     */


    var setupEditFromDiff = function setupEditFromDiff(diff) {
      var kind = diff.kind,
          index = diff.index,
          item = diff.item,
          path = diff.path; //additions/deletions only count if they're to lists of child widgets.
      //e.g. i might have added a new member to an array as in an OrdList.

      if (path && path.length && last(path) !== 'members') {
        kind = 'E';
      }

      switch (kind) {
        case 'E':
          {
            var _findNodePath = findNodePath(path),
                node = _findNodePath.node,
                keys = _findNodePath.keys,
                member = _findNodePath.member;

            var editPath = keys.join('/');
            var changedProp = last(path);

            if (changedProp === 'on') {
              var widget = Widget["in"](rootElement).queryWidget(keys.join('/')); // TODO: optimize this
              // the differing value could be just one member of `on` but we have
              // to wipe and re-arm all events at once

              var on = getValueFromBuildContext(curr, path, 'on');
              return armHandlers(widget, widget.jq(), on);
            } //special case for dom: don't do a full wipe and rebuild if dom is
            //reusable


            if (changedProp === 'dom') {
              var oldElement = node;
              var newElement = $(member.config.dom)[0];

              if (!requiresRebuild(oldElement, newElement)) {
                if (TRACE) {
                  trace(owner, 'updating dom in-place at path {}', editPath);
                }

                return doEdit(editPath, PRIORITY_UPDATE, function () {
                  return updateElement(oldElement, newElement, member.config.properties);
                });
              } else if (TRACE) {
                trace(owner, 'rebuilding dom at path {} because it could not be diffed', editPath);
              }
            }

            if (changedProp === 'value') {
              var existing = Widget["in"](node);
              var config = getValueFromBuildContext(curr, path, 'config');
              return Promise.resolve(manager.deriveConfiguredConstructor(config)).then(function (Ctor) {
                if (Ctor && existing instanceof Ctor) {
                  if (TRACE) {
                    trace(owner, 'loading new value "{}" into widget {} at path {}', member.config.value, existing.constructor.name, editPath);
                  }

                  return doEdit(editPath, PRIORITY_UPDATE, function () {
                    return manager.load(existing, member.config);
                  });
                } else {
                  if (TRACE) {
                    trace(owner, 'rebuilding widget at {} because new value to load ' + '"{}" is not compatible with existing widget {}', editPath, member.config.value, existing && existing.constructor.name);
                  }

                  return doEdit(editPath, PRIORITY_REBUILD, function () {
                    return rebuild($(node), member, manager, root, depth);
                  });
                }
              });
            }

            if (isUpdatableDiff(path)) {
              var _widget = Widget["in"]($(node));

              if (_widget instanceof SpandrelWidget && typeof _widget.rerender === 'function') {
                if (TRACE) {
                  trace(owner, 'updating "{}" widget property at path {}', changedProp, editPath);
                }

                return doEdit(editPath, PRIORITY_UPDATE, function () {
                  return update(_widget, member);
                });
              } else if (TRACE) {
                trace(owner, 'could not update "{}" widget property at path {} ' + 'because it was not a dynamic spandrel widget', changedProp, editPath);
              }
            }

            if (TRACE) {
              trace(owner, 'falling back to a full rebuild at path {} because ' + 'widget property "{}" could not be updated in-place', editPath, changedProp);
            }

            return doEdit(editPath, PRIORITY_REBUILD, function () {
              return rebuild($(node), member, manager, root, depth);
            });
          }

        case 'A':
          switch (item.kind) {
            case 'N':
              {
                var _findNodePath2 = findNodePath(path),
                    _keys = _findNodePath2.keys,
                    _node = _findNodePath2.node,
                    addedObj = item.rhs;

                if (TRACE) {
                  trace(owner, 'creating new widget at {}/{}', _keys.join('/'), addedObj.key);
                }

                return doFeBuild(addedObj, $(addedObj.config.dom).appendTo(_node), manager, root, depth);
              }

            case 'D':
              {
                var _findNodePath3 = findNodePath((path || []).concat(index)),
                    _keys2 = _findNodePath3.keys,
                    _node2 = _findNodePath3.node;

                if (TRACE) {
                  trace(owner, 'destroying {} at path {}', Widget["in"](_node2).constructor.name, _keys2.join('/'));
                }

                return Widget["in"](_node2).destroy().then(function () {
                  return $(_node2).remove();
                });
              }
          }

      }
    };

    return differences.reduce(function (prom, diff) {
      return prom.then(function () {
        return setupEditFromDiff(diff);
      });
    }, Promise.resolve());
  }

  function isUpdatableDiff(path) {
    var lastInPath = last(path);
    return lastInPath === 'properties' || lastInPath === 'readonly' || lastInPath === 'enabled' || lastInPath === 'writable';
  }
  /**
   * @param {JQuery} dom
   * @param {module:bajaux/spandrel~Member} member
   * @param {module:bajaux/lifecycle/WidgetManager} manager
   * @returns {Promise}
   */


  function rebuild(dom, member, manager, root, depth) {
    //TODO: support a RebuildStrategy
    var oldWidget = Widget["in"](dom);

    if (oldWidget && !(oldWidget instanceof SpandrelWidget) && oldWidget.isModified()) {
      return Promise.resolve();
    }

    return Promise.resolve(oldWidget && oldWidget.destroy()).then(function () {
      var newDom = $(member.config.dom);
      dom.replaceWith(newDom);
      return doFeBuild(member, newDom, manager, root, depth);
    });
  }
  /**
   * @param {module:bajaux/spandrel/SpandrelWidget} widget
   * @param {module:bajaux/spandrel~Member} member
   * @returns {Promise}
   */


  function update(widget, member) {
    //TODO: support an UpdateStrategy
    return widget.applyParams(member.config).then(function () {
      return widget.rerender();
    });
  }
  /**
   * Given a config from a Spandrel member, determine what kind of widget
   * Spandrel should show for it.
   * @param {module:bajaux/lifecycle/WidgetManager~BuildParams} config the
   * `config` property from a Spandrel member
   * @param {module:bajaux/lifecycle/WidgetManager} manager
   * @returns {Promise.<Function>} promise to be resolved with the kind of
   * widget to show. If none is specified or it can't figure it out, default to
   * Widget which will do nothing but show some raw HTML.
   */


  function tryToDetermineType(config, manager) {
    var kids = config.kids;

    if (kids) {
      var members = kids.members,
          on = kids.on;
      return Promise.resolve(spandrel({
        kids: members,
        on: on
      }, {
        manager: manager
      }));
    }

    return manager.buildContext(extend({
      formFactor: 'mini'
    }, config)).then(function (buildContext) {
      return buildContext.widgetConstructor || Widget;
    });
  }
  /**
   * Build a widget in this element, as configured.
   * @param {module:bajaux/spandrel~Member} member
   * @param {JQuery} dom
   * @param {module:bajaux/lifecycle/WidgetManager} manager
   * @returns {Promise.<module:bajaux/Widget>} the built widget
   */


  function doFeBuild(_ref5, dom, manager, root, depth) {
    var key = _ref5.key,
        config = _ref5.config;
    return tryToDetermineType(config, manager).then(function (type) {
      dom[0].spandrelKey = key;
      var data = extend({
        manager: manager
      }, config.data);
      var $quiet = !(config.properties && config.properties.$quiet === false);
      var params = extend({
        $constructorParams: {
          $quiet: $quiet
        },
        layoutParams: {
          quick: true
        }
      }, config, {
        data: data,
        dom: dom,
        type: type
      });
      return manager.makeFor(params).then(function (ed) {
        RequestLayoutMixin(ed, root || ed, depth, function (err, widget) {
          return manager.error(err, widget);
        });
        return manager.buildFor(params, ed);
      });
    });
  }

  function armHandlers(widget, dom, on) {
    var prev = widget.$spandrelHandlers;

    if (prev) {
      prev.forEach(function (_ref6) {
        var _ref7 = _slicedToArray(_ref6, 3),
            event = _ref7[0],
            handler = _ref7[2];

        return dom.off(event, handler);
      });
    } //allow 1-dimensional array handler


    if (!isArray(on[0])) {
      on = [on];
    }

    var spandrelHandlers = widget.$spandrelHandlers = [];
    on.forEach(function (arr) {
      var _arr2 = _slicedToArray(arr, 3),
          event = _arr2[0],
          selectorString = _arr2[1],
          handler = _arr2[2];

      if (arr.length === 2) {
        handler = selectorString;
        selectorString = null;
      }

      var selectors = selectorString ? selectorString.split(',').map(function (s) {
        return s.trim();
      }) : null;

      var eventHandler = function eventHandler(e) {
        var spandrelWidget = getContainingSpandrelWidget(e.target);
        var args = Array.prototype.slice.call(arguments, 1);

        if (spandrelWidget) {
          //Widget#trigger already passes itself as first argument - don't double up
          if (spandrelWidget === args[0]) {
            args = args.slice(1);
          }

          var path = getPathToKid(widget, spandrelWidget);

          if (!selectors || anyPathMatches(selectors, path.join('/'))) {
            return handler.apply(null, [e, spandrelWidget].concat(args));
          }
        }
      };

      spandrelHandlers.push([event, selectorString, eventHandler]);
      dom.on(event, eventHandler);
    });
  }
  /**
   * @param {string[]} path a property path through a nested spandrel config
   * @returns {string[]} the widget keys extracted from the path
   */


  function extractKeys(path) {
    // in the spandrel config, the path to the diff if nested is going
    // to follow the pattern:
    // members, key, config, kids, members, key, config, kids, members, key...
    return path.filter(function (p, i) {
      return path[i - 1] === 'members';
    });
  }

  function getValueFromBuildContext(ctx, path, name) {
    return resolveObjectPath(ctx, path.slice(0, lastIndexOf(path, name) + 1));
  }
  /**
   * Does a deep-get of a property path from an object. Works like the array
   * form of `_.property`.
   * @param {object} obj
   * @param {string[]} path
   * @returns {*}
   */


  function resolveObjectPath(obj, path) {
    return path.reduce(function (curr, prop) {
      return curr[prop] || {};
    }, obj);
  }
  /**
   * @param {string[]} selectors array of widget selectors
   * @param {string} path actual path to a queried widget
   * @returns {boolean}
   */


  function anyPathMatches(selectors, path) {
    return any(selectors, function (selector) {
      return pathMatches(path, selector);
    });
  }

  function attr(el, name, attr) {
    if (attr) {
      el.setAttribute(name, attr);
    } else {
      el.removeAttribute(name);
    }
  }
  /**
   * @param {object} params
   * @returns {module:bajaux/lifecycle/WidgetManager} the manager passed either
   * as `params.data.manager` or `params.params.data.manager`
   */


  function extractManager() {
    var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    //TODO: does Widget itself need an API for this?
    var data = params.data;
    var manager = data && data.manager;

    if (!manager) {
      params = params.params;
      data = params && params.data;
      manager = data && data.manager;
    }

    return manager;
  }

  function trace(owner, msg) {
    for (var _len = arguments.length, args = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
      args[_key - 2] = arguments[_key];
    }

    logFinest.apply(void 0, [owner.constructor.name + ': ' + msg].concat(args));
  }

  function setClassList(el, classList) {
    Object.defineProperty(el, 'classList', {
      configurable: true,
      enumerable: true,
      writable: true,
      value: classList
    });
  }

  return spandrel;
});
