function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @module bajaux/dragdrop/NavNodeEnvelope
 */
define(['baja!', 'baja!baja:INavNode', 'jquery', 'Promise', 'underscore', 'bajaux/dragdrop/Envelope', 'nmodule/js/rc/asyncUtils/asyncUtils'], function (baja, types, $, Promise, _, Envelope, asyncUtils) {
  'use strict';

  var doRequire = asyncUtils.doRequire;

  var getNavNode = _.once(function () {
    return doRequire('bajaScript/baja/nav/NavNode');
  }); ////////////////////////////////////////////////////////////////
  // Support functions
  ////////////////////////////////////////////////////////////////


  function getTypeSpecs(obj) {
    var kids = obj.kids || [],
        kidSpecs = kids.map(getTypeSpecs);
    return [obj.typeSpec].concat(kidSpecs);
  }
  /**
   * Extract an array of all type specs from the array of JSON objects.
   * 
   * @inner
   * @param {Array.<Object>} json
   * @returns {Array.<String>}
   */


  function getAllTypeSpecs(json) {
    return _.uniq(_.flatten(json.map(getTypeSpecs)));
  }

  function toJson(navNode) {
    var kids = navNode.getSlots && navNode.getSlots().is('baja:INavNode').toValueArray(),
        ord = navNode.getNavOrd();
    return {
      ord: ord && String(ord),
      name: navNode.getNavName(),
      displayName: navNode.getNavDisplayName(),
      icon: navNode.getNavIcon().encodeToString(),
      description: navNode.getNavDescription(),
      typeSpec: navNode.getType().getTypeSpec(),
      kids: kids ? kids.map(toJson) : []
    };
  }

  function toNavNode(obj) {
    var typeSpec = obj.typeSpec,
        type = baja.lt(obj.typeSpec);

    if (!type || !type.is('baja:INavNode')) {
      throw new Error('only INavNodes supported, ' + typeSpec + ' found');
    }

    return Promise.all([getNavNode(), Promise.all((obj.kids || []).map(toNavNode))]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
          NavNode = _ref2[0],
          kids = _ref2[1];

      var navNode = new NavNode({
        navName: obj.name,
        displayName: obj.displayName,
        description: obj.description,
        ord: String(obj.ord),
        icon: obj.icon
      });

      navNode.getType = function () {
        return type;
      };

      navNode.getNavChildren = function () {
        return Promise.resolve(kids);
      };

      return navNode;
    });
  } ////////////////////////////////////////////////////////////////
  // NavNodeEnvelope
  ////////////////////////////////////////////////////////////////

  /**
   * Envelope for transforming raw JSON into NavNode instances, or vice versa.
   * 
   * @class
   * @extends module:bajaux/dragdrop/Envelope
   * @alias module:bajaux/dragdrop/NavNodeEnvelope
   * @param {Array.<Object>|Array.<baja.NavNode>} arr either an array of raw
   * JSON to be converted to NavNodes, or an array of NavNodes to be converted
   * to JSON
   * @throws {Error} if a non-Array given
   */


  var NavNodeEnvelope = function NavNodeEnvelope(arr) {
    Envelope.apply(this, arguments);

    if (!Array.isArray(arr)) {
      throw new Error('array required');
    }

    var navNodes, json; //TODO: need an "isArrayOf" or similar

    if (baja.hasType(arr[0], 'baja:INavNode')) {
      navNodes = arr;
    } else {
      json = arr;
    }

    this.$navNodes = navNodes;
    this.$json = json;
  };

  NavNodeEnvelope.prototype = Object.create(Envelope.prototype);
  NavNodeEnvelope.prototype.constructor = NavNodeEnvelope;
  /**
   * @returns {string} `niagara/navnodes`
   */

  NavNodeEnvelope.prototype.getMimeType = function () {
    return 'niagara/navnodes';
  };
  /**
   * Get the JSON representations of the envelope's NavNodes:
   * 
   *     [{
   *       "name": "navName",
   *       "displayName": "navDisplayName",
   *       "description": "navDescription",
   *       "icon": "navIcon",
   *       "ord": "navOrd",
   *       "typeSpec": "typeSpec",
   *       "kids": [ \/* child nav node JSON objects *\/ ]
   *     }]
   *     
   * @returns {Promise} promise to be resolved with an array of raw
   * JSON objects
   */


  NavNodeEnvelope.prototype.toJson = function () {
    return Promise.resolve(this.$json || (this.$json = this.$navNodes.map(toJson)));
  };
  /**
   * Get the actual NavNodes represented by this envelope.
   * 
   * @returns {Promise} promise to be resolved with an array of
   * NavNode instances
   */


  NavNodeEnvelope.prototype.toValues = function () {
    var that = this,
        json = that.$json,
        navNodes = that.$navNodes;

    if (navNodes) {
      return Promise.resolve(navNodes);
    }

    return baja.importTypes(getAllTypeSpecs(json)).then(function () {
      return Promise.all(_.map(json, toNavNode));
    }).then(function (navNodes) {
      return that.$navNodes = navNodes;
    });
  };

  return NavNodeEnvelope;
});
