/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @module bajaux/dragdrop/Envelope
 */
define(['Promise'], function (Promise) {
  'use strict';

  function reject(err) {
    return Promise.reject(new Error(err));
  }
  /**
   * Base class for Envelope implementations. These define methods of
   * transformation between raw JSON and data values (Baja values or otherwise),
   * for use in drag/drop or other data-transfer situations.
   * 
   * @abstract
   * @class
   * @alias module:bajaux/dragdrop/Envelope
   * @param {Array} arr an array of values to store in this envelope
   */


  var Envelope = function Envelope(arr) {};
  /**
   * Get a mime type to identify the data type transformed by this envelope.
   * 
   * @abstract
   * @returns {String}
   */


  Envelope.prototype.getMimeType = function () {
    throw new Error('getMimeType() not implemented');
  };
  /**
   * Get a JSON representation of the data contained in this envelope.
   * 
   * @abstract
   * @returns {Promise} a promise to be resolved with an array of
   * raw JSON objects
   */


  Envelope.prototype.toJson = function () {
    return reject('toJson() not implemented');
  };
  /**
   * Get the actual values represented by this envelope.
   * 
   * @abstract
   * @returns {Promise} a promise to be resolved with an array of
   * data values
   */


  Envelope.prototype.toValues = function () {
    return reject('toValues() not implemented');
  };

  return Envelope;
});
