/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/**
 * API Status: **Private**
 * @module nmodule/driver/rc/fe/ProxyConversionMiniEditor
 */
define(['baja!', 'jquery', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/DisplayOnlyEditor', 'nmodule/webEditors/rc/util/htmlUtils', 'nmodule/webEditors/rc/fe/baja/PopOutEditor', 'nmodule/webEditors/rc/fe/config/CompositeBuilder', 'nmodule/webEditors/rc/fe/CompositeEditor', 'css!nmodule/driver/rc/driver'], function (baja, $, Promise, _, fe, DisplayOnlyEditor, htmlUtils, PopOutEditor, CompositeBuilder, CompositeEditor) {
  'use strict'; ///////////////////////////////////////////////////////////////////////////////////////////
  //////ProxyConversionDisplayOnlyEditor
  ////////////////////////////////////////////////////////////////////////////////////////////

  var escapeHtml = htmlUtils.escapeHtml;
  /**
   * Displays only the description property of the loaded value
   * @constructor
   */

  var ProxyConversionDisplayOnlyEditor = function ProxyConversionDisplayOnlyEditor() {
    DisplayOnlyEditor.apply(this, arguments);
  };

  ProxyConversionDisplayOnlyEditor.prototype = Object.create(DisplayOnlyEditor.prototype);
  ProxyConversionDisplayOnlyEditor.prototype.constructor = ProxyConversionDisplayOnlyEditor;
  /**
   * Returns the description of the loaded value if supported.
   * Works for TabularConversion, TabularThermistorConversion and NrioTabularThermistorConversion for eg.
   * @param value
   * @returns {String|*}
   */

  ProxyConversionDisplayOnlyEditor.prototype.valueToString = function (value) {
    if (baja.hasType(value, 'kitIo:TabularConversion') || baja.hasType(value, 'ndio:TabularThermistorConversion') || baja.hasType(value, 'nrio:NrioTabularThermistorConversion')) {
      return "[" + escapeHtml(value.getDescription()) + "]";
    }

    return '';
  }; ///////////////////////////////////////////////////////////////////////////////////////////
  //////ProxyConversionMiniEditor
  ////////////////////////////////////////////////////////////////////////////////////////////

  /**
   * @class
   * @alias module:nmodule/driver/rc/fe/ProxyConversionMiniEditor
   * @extends module:nmodule/webEditors/rc/fe/CompositeEditor
   * @param params
   */


  var ProxyConversionMiniEditor = function ProxyConversionMiniEditor(params) {
    CompositeEditor.apply(this, arguments);
  };

  ProxyConversionMiniEditor.prototype = Object.create(CompositeEditor.prototype);
  ProxyConversionMiniEditor.prototype.constructor = ProxyConversionMiniEditor;

  ProxyConversionMiniEditor.prototype.makeBuilder = function () {
    var that = this,
        builder = new CompositeBuilder(),
        showButton = that.properties().getValue('showButton');

    builder.getKeys = function () {
      return showButton ? ['value', 'button'] : ['value'];
    };

    builder.getConfigFor = function (key) {
      switch (key) {
        case 'value':
          return {
            type: ProxyConversionDisplayOnlyEditor
          };

        case 'button':
          return {
            type: PopOutEditor
          };
      }
    };

    builder.getValueFor = function (key) {
      switch (key) {
        case 'value':
          return this.getDataSource();

        case 'button':
          return this.getEditorFor('value');
      }
    };

    builder.getDomFor = function (key) {
      return $('<div/>').addClass(key).appendTo(that.jq());
    };

    return builder;
  };

  ProxyConversionMiniEditor.prototype.doRead = function () {
    //just want the first one
    return this.getChildWidgets().readAll().spread(_.identity);
  };

  return ProxyConversionMiniEditor;
});
//# sourceMappingURL=ProxyConversionMiniEditor.js.map
