/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/**
 * API Status: **Private**
 * @module nmodule/driver/rc/baja/XYPoint
 */
define([], function () {
  'use strict';
  /**
   * An object representing a simple point with X and Y double values
   * @class
   * @alias module:nmodule/driver/rc/baja/XYPoint
   * @param params - An object with x and y values
   */

  var XYPoint = function XYPoint(params) {
    this.x = params.x ? parseFloat(params.x, 10) : 0.0;
    this.y = params.y ? parseFloat(params.y, 10) : 0.0;
  };
  /**
   * Returns the X value
   * @returns {number}
   */


  XYPoint.prototype.xValue = function () {
    return this.x;
  };
  /**
   * Gets the Y value
   * @returns {number}
   */


  XYPoint.prototype.yValue = function () {
    return this.y;
  };
  /**
   * Check if passed-in object is equal to this
   * @param o
   * @returns {boolean}
   */


  XYPoint.prototype.equals = function (o) {
    if (o instanceof XYPoint) {
      return this.xValue() === o.x && this.yValue() === o.y;
    }

    return false;
  };
  /**
   * Encode XYPoint to a string in X,Y format
   * @returns {string} The encoded string
   */


  XYPoint.prototype.encodeToString = function () {
    return this.xValue() + "," + this.yValue();
  };
  /**
   * Get XYPoint from a string encoding of the form 'x,y'
   * @param str - encoded input of the form 'x,y'
   * @returns {XYPoint} New XYPoint object
   */


  XYPoint.decodeFromString = function (str) {
    if (!str || str.split(",").length < 2) {
      return new XYPoint({
        x: 0,
        y: 0
      });
    }

    var a = str.split(",");
    return new XYPoint({
      x: a[0],
      y: a[1]
    });
  };

  return XYPoint;
});
//# sourceMappingURL=XYPoint.js.map
