/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/driver/rc/baja/ProxyExt
 */
define(['baja!', 'baja!baja:UnitConversion'], function (baja) {
  'use strict';

  var Component = baja.Component,
      NO_UNIT_CONVERSION = baja.Facets.make({
    unitConversion: baja.DynamicEnum.make({
      en: baja.$('baja:UnitConversion').get('none')
    })
  });
  /**
   * BajaScript representation of a `driver:ProxyExt` value.
   *
   * @class
   * @extends baja.Component
   * @alias module:nmodule/driver/rc/baja/ProxyExt
   */

  var ProxyExt = function ProxyExt() {
    Component.apply(this, arguments);
  };

  ProxyExt.prototype = Object.create(Component.prototype);
  ProxyExt.prototype.constructor = ProxyExt;
  /**
   * For the `readValue` and `writeValue` slots, return the value at
   * `deviceFacets` with `unitConversion` set to `NONE`.
   *
   * @see BProxyExt#getSlotFacets(Slot)
   * @param {String|baja.Slot} slot
   * @returns {baja.Facets}
   */

  ProxyExt.prototype.getFacets = function (slot) {
    switch (String(slot)) {
      case 'readValue':
      case 'writeValue':
        return baja.Facets.make(this.get('deviceFacets'), NO_UNIT_CONVERSION);
    }

    return Component.prototype.getFacets.apply(this, arguments);
  };

  return ProxyExt;
});
//# sourceMappingURL=ProxyExt.js.map
