/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/**
 * API Status: **Private**
 * @module nmodule/driver/rc/baja/LinearConversion
 */
define(['baja!', 'bajaScript/baja/obj/objUtil', 'lex!driver'], function (baja, objUtil, lexs) {
  'use strict';

  var Simple = baja.Simple,
      cacheDecode = objUtil.cacheDecode,
      cacheEncode = objUtil.cacheEncode,
      lexDriver = lexs[0];
  /**
   * Bajascript object representing a Linear Conversion (of driver:LinearConversion type)
   * @class
   * @extends baja.Simple
   * @alias module:nmodule/driver/rc/baja/LinearConversion
   */

  var LinearConversion = function LinearConversion() {
    Simple.apply(this, arguments);
  };

  LinearConversion.prototype = Object.create(Simple.prototype);
  LinearConversion.prototype.constructor = LinearConversion;

  LinearConversion.make = function (scale, offset) {
    if (isNaN(parseFloat(scale, 10))) {
      throw new Error(lexDriver.get("LinearConversion.error.invalidParam", lexDriver.get("LinearConversion.scale")));
    }

    if (isNaN(parseFloat(offset, 10))) {
      throw new Error(lexDriver.get("LinearConversion.error.invalidParam", lexDriver.get("LinearConversion.offset")));
    }

    var lc = new LinearConversion();
    lc.$scale = scale;
    lc.$offset = offset;
    return lc;
  };

  LinearConversion.prototype.make = function () {
    return LinearConversion.make.apply(LinearConversion, arguments);
  };

  LinearConversion.prototype.getScale = function () {
    return this.$scale;
  };

  LinearConversion.prototype.getOffset = function () {
    return this.$offset;
  };
  /**
   * Decode a `LinearConversion` from a string representation.
   *
   * @function
   * @param {String} str
   * @returns {module:nmodule/driver/rc/baja/LinearConversion}
   */


  LinearConversion.prototype.decodeFromString = cacheDecode(function (str) {
    if (!str || str.split(";").length < 2) {
      return LinearConversion.DEFAULT;
    }

    var a = str.split(";");
    return LinearConversion.make(parseFloat(a[0], 10), parseFloat(a[1], 10));
  });
  /**
   * Encode this `LinearConversion` to a string of the form '<scale>;<offset>'.
   *
   * @function
   * @returns {String}
   */

  LinearConversion.prototype.encodeToString = cacheEncode(function () {
    return this.$scale + ";" + this.$offset;
  });
  LinearConversion.DEFAULT = LinearConversion.make(1.0, 0.0);
  /**
   * Register this baja type as 'driver:LinearConversion'
   */

  baja.registerType('driver:LinearConversion', function () {
    return LinearConversion;
  });
  return LinearConversion;
});
//# sourceMappingURL=LinearConversion.js.map
