/*
  bajaux fires events a developer can listen for...

  - Widget property added/removed
  - Widget property changed
  - Widget destroyed
  - Widget initialized
  - Widget layout
  - Widget modified/unmodified
  - Widget loaded
  - Widget saved
  - Widget validated
  - Widget command changed
  - Widget toggle command selected
  - Widget command invoked
  - Widget command group changed
  
  For more information regarding the events, please see..
  
  module://bajaux/rc/events.js
*/
define(['bajaux/Widget',
        'bajaux/events',
        'bajaux/commands/Command',
        'bajaux/util/SaveCommand',
        'dialogs',
        'hbs!nmodule/docDeveloper/rc/bajaux/examples/EventsWidgetTemplate'], function (
        Widget,
        events,
        Command,
        SaveCommand,
        dialogs,
        template) {

  'use strict';

  var widgetMsg = "Event detected from Widget - ";

  var EventsWidget = function () {
    var that = this;
    Widget.apply(that, arguments);

    var cmd = new Command({
      module: "docDeveloper",
      lex: "commands.helloWorld",
      func: function () {
        dialogs.showOk("Clicked the Hello World Command!");
      }
    });

    cmd.on(events.command.INVOKE_EVENT, function () {
      that.$append("Event detected from Command - Command Invoked!");
    });

    that.getCommandGroup().add(new SaveCommand(), cmd);
  };

  EventsWidget.prototype = Object.create(Widget.prototype);
  EventsWidget.prototype.constructor = EventsWidget;

  EventsWidget.prototype.$append = function (str) {
    // Append some new text to the widget's 'pre' DOM element...
    var jq = this.jq().find("pre");
    jq.text(jq.text() + str + "\n");
    return this;
  };

  EventsWidget.prototype.doInitialize = function (jq) {
    var that = this;
    jq.html(template());

    jq.children("input").click(function () {
      that.setModified(true);
      return false;
    });

    jq.on(events.command.INVOKE_EVENT, function () {
      that.$append(widgetMsg + "Command Invoked!");
    });

    jq.on(events.SAVE_EVENT, function () {
      that.$append(widgetMsg + "Widget saved!");
    });

    jq.on(events.MODIFY_EVENT, function () {
      that.$append(widgetMsg + "Widget modified!");
    });
  };

  return EventsWidget;
});
