/*
  Let's take a look how we can set properties.

  Note the 'then' statements being used. JavaScript Promises have been added to
  BajaScript version 2. With promises we can easily chain together lots of asynchronous
  code. Learn more about the promise library we use here...

  https://github.com/petkaantonov/bluebird/blob/master/API.md
*/
require(["baja!", "dialogs"], function (baja, dialogs) {
 "use strict";

  var counter;
  baja.Ord.make("station:|slot:/BajaScriptExamples/Components/Counter")
    .get({
      lease: true, // Temporarily subscribe the Counter for one minute.
      leaseTime: baja.RelTime.make({ minutes: 1 })
    })
    .then(function (point) {
      counter = point;
    })
    .then(function () {
      // Note how all of these calls return a promise. Only the next 'then' will
      // be invoked once this call has finished. In the case of a dialog, it's only
      // when it's closed.
      return dialogs.showOk("Counter before setting: " + counter.getOutDisplay()).promise();
    })
    .then(function () {
      // Set the count up Property to true...
      return counter.getCountUp().setValue(true);
    })
    .then(function () {
      // As soon as the Property has been set to true, change it back to false.
      return counter.getCountUp().setValue(false);
    })
    .then(function () {
      return dialogs.showOk("Counter after setting: " + counter.getOutDisplay()).promise();
    });
});
