/*
  In this tutorial, we're going to remove the alarm extension that was added previously.
*/

require(["baja!", 
         "baja!alarm:AlarmSourceExt",
         "dialogs"], function (
         baja, 
         types,
         dialogs) {
  "use strict";

  baja.Ord.make("station:|slot:/BajaScriptExamples/Components/Ramp")
    .get()
    .then(function (point) {
      // Does the point already have an alarm extension added to it?
      var ext = point.getSlots().is("alarm:AlarmSourceExt").firstValue();

      if (ext) { 
        // Remove the alarm extension from the point. This will make a network call to the 
        // server to remove the extension.
        point.remove(ext)
          .then(function () {
             dialogs.showOk("Removed alarm extension from point: " + point.getNavOrd().toString());
          });
      }
      else {
        dialogs.showOk("No alarm extension found.");
      }
    });
});
