/*
  BajaScript can be used to query a Station via SQL, BQL etc...

  - For more information, please see the JsDocs for baja.coll.Table
*/
require(["baja!", 
         "dialogs", 
         "underscore"], function (
          baja, 
          dialogs,
          _) {  
  "use strict";
  
  var buff = "";        
  function update(str) {
    buff += str + "\n";
  }

  // Run the BQL query in the Station and print out the results...
  baja.Ord.make("station:|slot:/|bql:select toPathString from baja:Component")
    .get({
      cursor: {
        before: function () {
          update("Called just before iterating through the Cursor");
        },
        after: function () {
          update("Called just after iterating through the Cursor");
        },
        each: function () {
          update("Each: " + this.get("toPathString"));
        },
        limit: 15, // Specify optional limit on the number of records (defaults to 10)
        offset: 0 // Specify optional record offset (defaults to 0)
      }  
    })
    .then(function (result) {
      _.each(result.getColumns(), function (c) {
        update("Column: " + c.getDisplayName());
      });

      dialogs.showOk("<pre>" + buff + "</pre>");
    });
});
