/*
  In the last tutorial, you learnt how resolve an ORD and read a live value.

  Now we're going to extend that original example by seeing how we can 'do something' to a Station by invoking an Action.
*/
require(["baja!", 
         "baja!control:NumericOverride",
         "dialogs"], function (
         baja,
         types,
         dialogs) {
  "use strict";

  var sub = new baja.Subscriber();
  dialogs.showOk(function (dlg, jq) {
    jq.text("Waiting for change...");

    return baja.Ord.make("station:|slot:/BajaScriptExamples/Components/NumericWritable")
      .get({ subscriber: sub })
      .then(function (point) {
        // This ok function handler is called once the writable point has been resolved and subscribed
        
        // Invoking the 'override' Action on a point requires an argument. 
        // Therefore, we first need to create a baja:NumericOverride object. 
        // Please note, to create an instance of an object (via the baja.$ method), we 
        // need to ensure we first import the Type. This is done in the above 'baja!control:NumericWritable'
        // statement.
        var overrideVal = baja.$("control:NumericOverride");
        
        // Override with this value 5 seconds.
        overrideVal.setValue(123);
        overrideVal.setDuration(baja.RelTime.make({seconds: 5}));
        
        sub.attach("changed", function (prop, cx) {
          if (prop.getName() === "out") {
            jq.text("Out: " + point.getOutDisplay());
          }
        });

        // Invoke the Action on the point. This will result in an asynchronous network call...
        point.override(overrideVal);
        
        // The Action can also be invoked through the baja.Component#invoke method...
        /*
        point.invoke({
          slot: "override",
          value: overrideVal
        });
        */
      });
  })
  .promise()
  .finally(function () {
    sub.unsubscribeAll();
    sub.detach();
  });

});
