/*
  Let's recap on all of the different component events we can listen for...

  - There are lots of different events to listen to. For a list, please see the JsDocs for baja.Subscriber#attach.
  - There's also a 'detach' method to remove handlers.
  - There are many different ways to attach event handlers as shown in the commented out examples below...
*/

require(["baja!", 
         "dialogs",
         "jquery"], function (
         baja,
         dialogs,
         $) {
  "use strict";

  var sub = new baja.Subscriber(),
      ordStr = "station:|slot:/BajaScriptExamples/Components/EventTest";

  dialogs.showOk(function (dlg, jq) {

    function update(msg) {
      var entry = $("<div></div>");
      entry.text(msg);
      jq.append(entry);
    }

    // Attaching a single event listener function...
    /*
    sub.attach("changed", function(prop, cx) {
      update("Property changed: " + prop.getName());
    });
    */

    // Attach one function to multiple events...
    /*
    sub.attach("subscribed changed added removed", function() {
      update("Event received: " + this.toPathString());
    });
    */
   
   update("Open another browser or workbench. Navigate to...");
   update("...");
   update(ordStr);
   update("...");
   update("Now add and remove Components to this folder. Note the events that appear below...");
   update("...");

    // Use an Object Literal to define multiple event handlers in one call...
    sub.attach({
      changed: function(prop, cx) {
        update("Changed");
      },
      
      added: function(prop, cx) {
        update("Added");
      },

      removed: function(prop, val, cx) {
        update("Removed");
      },
      
      renamed: function(prop, oldName, cx) {
        update("Renamed");
      },

      reordered: function(cx) {
        update("Reordered");
      },
      
      topicFired: function(topic, event, cx) {
        update("Topic Fired");
      },
      
      flagsChanged: function(slot, cx) {
        update("Flags Changed");
      },

      facetsChanged: function(slot, cx) {
        update("Facets Changed");
      },

      subscribed: function(cx) {
        update("Subscribed");
      },

      unsubscribed: function(cx) {
        update("Unsubscribed");
      },
      
      unmount: function(cx) {
        update("EventTest removed from Station!");
      },
      
      componentRenamed: function(oldName, cx) {
        update("Original EventTest has been renamed: " + oldName);
      },
      
      componentFlagsChanged: function(cx) {
        update("EventTest parent Property flags changed");
      },
      
      componentFacetsChanged: function(cx) {
        update("EventTest parent Property facets changed");
      },
      
      componentReordered: function(cx) {
        update("EventTest has been reordered in parent");
      }
    });  

    baja.Ord.make(ordStr)
      .get({subscriber: sub});
  })
  .promise()
  .finally(function () {
    sub.unsubscribeAll();
    sub.detach();
  });

});
