/*
  This code will batch resolve a number of ORDs in one go with 
  a minimal number of network calls.
*/

require(["baja!", 
         "dialogs"], function (
         baja, 
         dialogs) {
  "use strict";
  
  var ords = [
      "station:|slot:/BajaScriptExamples/Components/Ramp",
      "station:|slot:/BajaScriptExamples/Components/Counter",
      "station:|slot:/BajaScriptExamples/Components/NumericWritable",
      "station:|slot:/BajaScriptExamples/Components/Batch",
      "station:|slot:/BajaScriptExamples/Components/EventTest",
      "station:|slot:/BajaScriptExamples/Components/Reorder",
      "station:|slot:/BajaScriptExamples/Components/BajaScriptTestComp"
    ],
    resolve = new baja.BatchResolve(ords),
    buf = "";

  function update(str) {
    buf += str + "\n";
  }    

  resolve.resolve({
      each: function () {
        update(this.toPathString());
      }
    })
    .then(function () {
      dialogs.showOk("<pre>" + buf + "</pre>");
    });
});
