/*
  As well as reading live values and invoking Actions, we can also manipulate
  the Components running in a Station. For instance, we can add, remove, reorder or
  rename information!
*/

require(["baja!",
         "baja!alarm:AlarmSourceExt,alarm:OutOfRangeFaultAlgorithm,alarm:OutOfRangeAlgorithm",
         "dialogs"], function (
         baja, 
         types, 
         dialogs) {
  "use strict";

  // Please note, here we're resolving an ORD without specifying a subscriber. 
  // Without any arguments in the 'get' method, the Counter component will be 
  // temporarily subscribed for ten seconds. This is known as a 'lease'.
  baja.Ord.make("station:|slot:/BajaScriptExamples/Components/Ramp")
    .get()
    .then(function (point) {
      // Does the point already have an alarm extension added to it?
      if (!point.getSlots().is("alarm:AlarmSourceExt").isEmpty()) {
        dialogs.showOk("Alarm extension already added to point!");
        return;
      }

      // Create an instance of a out of range alarm extension. Note how the algorithm's 
      // are specified in an object literal. Also note how because we are using baja.$ to 
      // create an instance of a type, we also have to import them in the outer require 
      // call.
      var ext = baja.$("alarm:AlarmSourceExt", {
        faultAlgorithm: baja.$("alarm:OutOfRangeFaultAlgorithm"),
        offnormalAlgorithm: baja.$("alarm:OutOfRangeAlgorithm")
      });

      // Please note, at this point we have an alarm extension in memory in the client. We haven't yet
      // added it to the point in the server. Before we do so, we can configure a few properties on the alarm
      // extension first.
      var offNormal = ext.getOffnormalAlgorithm();
      offNormal.setHighLimit(80);
      offNormal.setLowLimit(20);
      offNormal.getLimitEnable().setLowLimitEnable(true);
      offNormal.getLimitEnable().setHighLimitEnable(true);

      // Now add the extension to the point. The point is a proxy version of the real component
      // running in the Station. When we call 'add', this will make a network call to add the
      // Alarm Extension to the real Component running in the Station. If the current user hasn't
      // get permissions to add a Component, this operation will fail.
      point.add({
        slot: "alarmExt?", // The question mark is used here to guarantee a unique name is give to component.
        value: ext
      }).then(function () {
        dialogs.showOk("Added alarm extension to " + point.getNavOrd().toString());
      });
    });

});
