/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/**
 * A module defining `NrioTabularThermistorConversionEditor`.
 * API Status: **Private**
 * @module nmodule/nrio/rc/fe/NrioTabularThermistorConversionEditor
 */
define([
  'nmodule/driver/rc/fe/BaseTabularConversionEditor',
  'jquery',
  'Promise',
  'baja!',
  'lex!nrio',
  'nmodule/driver/rc/fe/XYPointEditor',
  'nmodule/driver/rc/baja/XYPoint',
  'nmodule/nrio/rc/baja/NrioTabularThermistorConversion',
  'underscore'
], function
  (BaseTabularConversionEditor,
   $,
   Promise,
   baja,
   lexs,
   XYPointEditor,
   XYPoint,
   NrioTabularThermistorConversion,
   _) {

  'use strict';

  var nrioLex = lexs[0];

  /**
   * Bajaux for Tabular conversion
   *
   * @class
   * @extends module:bajaux/Widget
   * @alias module:nmodule/nrio/rc/fe/NrioTabularThermistorConversionEditor
   */
  var NrioTabularThermistorConversionEditor = function NrioTabularThermistorConversionEditor() {
    var that = this;
    BaseTabularConversionEditor.apply(that, arguments);
  };

  //extend and set up prototype chain
  NrioTabularThermistorConversionEditor.prototype = Object.create(BaseTabularConversionEditor.prototype);
  NrioTabularThermistorConversionEditor.prototype.constructor = NrioTabularThermistorConversionEditor;

  /**
   * @see BaseTabularConversionEditor.getInitDomProps
   */
  NrioTabularThermistorConversionEditor.prototype.getInitDomProps = function () {
    return {
      labels: {
        desc: nrioLex.get("tabularDialog.descriptionLabel"),
        source: nrioLex.get("tabularDialog.ohmsColumnLabel"),
        result: nrioLex.get("tabularDialog.celsiusColumnLabel")
      }
    };
  };

  /**
   * Reads the editor data into a NrioTabularThermistorConversion object
   * @returns {Promise} promise to be resolved with the current value
   */
  NrioTabularThermistorConversionEditor.prototype.doRead = function () {
    return Promise.join(
      this.$getDescEditor().read(),
      this.getBuilder().readAll()
    ).spread(function (desc, points) {
        return NrioTabularThermistorConversion.make(desc, points);
      });
  };

  return NrioTabularThermistorConversionEditor;
});
