function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Shivani Jakhmola
 */

/**
 * API Status: **Private**
 * @module  module:nmodule/lonworks/rc/fe/DomainIdEditor
 */
define(['baja!', 'jquery', 'Promise', 'bajaux/Widget', 'bajaux/events', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/util/htmlUtils', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'nmodule/lonworks/rc/baja/DomainId', 'nmodule/webEditors/rc/util/byteUtils', 'lex!lonworks', 'css!nmodule/lonworks/rc/lonworks'], function (baja, $, Promise, Widget, events, fe, BaseEditor, htmlUtils, OrderedMapEditor, DomainId, byteUtils, lexs) {
  "use strict";

  var _lexs = _slicedToArray(lexs, 1),
      lonworksLex = _lexs[0];

  var lengthLabel = lonworksLex.getSafe('DomainIdFE.length'),
      idLabel = lonworksLex.getSafe('DomainIdFE.id');
  var escapeHtml = htmlUtils.escapeHtml,
      radix = 16;

  var domainIdEditorHtml = function domainIdEditorHtml() {
    return "\n   <span class='domainIdLength-label' style=\"padding-right:0.2em;\"><label>".concat(lengthLabel, "</label></span>\n   <span class='domainIdLength'></span>\n   <span class='domainIdValue-label'\n    style=\"visibility:hidden;padding-left\":1em\"><label>").concat(idLabel, "</label></span>\n   <span class='domainIdValue' style=\"visibility:hidden\"></span>\n  ");
  };
  /**
   * Baja UX field editor for lonworks Domain Id.
   * Has an editor for Domain Id length and Domain Id value
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/lonworks/rc/fe/DomainIdEditor
   */


  var DomainIdEditor = /*#__PURE__*/function (_BaseEditor) {
    _inherits(DomainIdEditor, _BaseEditor);

    var _super = _createSuper(DomainIdEditor);

    function DomainIdEditor() {
      _classCallCheck(this, DomainIdEditor);

      return _super.apply(this, arguments);
    }

    _createClass(DomainIdEditor, [{
      key: "doInitialize",

      /**
       * Creates a length editor with value 0 as default.
       * On change function makes Domain Id String editor visible if the length of
       * the Domain Id is greater than 0.
       * Each time the value of Domain Id length changes the Domain Id string editor
       * get initialized to a string of zeros based on the length selected.
       * Width of the string editor also changes based on length.
       *
       * @param {JQuery} dom
       * @returns {Promise}
       */
      value: function doInitialize(dom) {
        var _this = this;

        dom.addClass('DomainIdEditor');
        dom.html(domainIdEditorHtml());
        dom.on(events.MODIFY_EVENT, '.domainIdLength', function (e, ed) {
          ed.read().then(function (len) {
            var length = parseInt(len);

            var idElement = _this.$getIdElement();

            if (length !== 0) {
              _this.$styleIdEditor(idElement, length);

              return _this.$getIdEditor().load(byteUtils.byteArrayToString([0, 0, 0, 0, 0, 0], " ", length, radix));
            } else {
              $('.domainIdValue-label').css("visibility", "hidden");
              idElement.css("visibility", "hidden");
            }
          })["catch"](function (err) {
            baja.error(err);
            throw err;
          });
        });
        dom.on(events.MODIFY_EVENT, '.domainIdValue', function () {
          _this.setModified(true);

          return false;
        });
        var domainIdEditors = [fe.buildFor({
          dom: this.$getLengthElement(),
          value: this.$getLengthPatternMap(),
          loadParams: {
            selectedValue: "0"
          },
          type: OrderedMapEditor
        }), fe.buildFor({
          dom: this.$getIdElement(),
          value: "",
          formFactor: 'mini'
        })];
        return Promise.all(domainIdEditors);
      }
      /**
       * Loads the Domain Id Length editor and makes the Domain Id string editor
       * visible only if the length editor has a value other than 0.
       * Byte array entered by the user is converted to string.
       *
       * @param domainId
       * @returns {Promise}
       */

    }, {
      key: "doLoad",
      value: function doLoad(domainId) {
        var len = domainId.getDomainIdLength(),
            promiseList = [];
        var domainLengthFE = this.$getLengthEditor().setSelectedValue(len.toString(), true);
        promiseList.push(domainLengthFE);
        var idElement = this.$getIdElement();

        if (len !== 0) {
          this.$styleIdEditor(idElement, len);
          promiseList.push(this.$getIdEditor().load(byteUtils.byteArrayToString(domainId.getDomainId(), ' ', len, radix)));
        } else {
          idElement.css("visibility", "hidden");
        }

        return Promise.all(promiseList);
      }
      /**
       * Reads the value of the Domain Id length and string editors.
       *
       *  @returns module:nmodule/lonworks/rc/baja/DomainId
       */

    }, {
      key: "doRead",
      value: function doRead() {
        return Promise.all([this.$getLengthEditor().read(), this.$getIdEditor().read()]).then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 2),
              len = _ref2[0],
              id = _ref2[1];

          var length = parseInt(len);
          var byteId = byteUtils.stringToByteArray(id, length);
          return DomainId.make(length, byteId);
        });
      }
      /**
       * Sets all the child widgets of this editor to readonly.
       *
       * @param {boolean} readonly
       * @returns {Promise}
       */

    }, {
      key: "doReadonly",
      value: function doReadonly(readonly) {
        return this.getChildWidgets().setAllReadonly(readonly);
      }
      /**
       * Sets all the child widgets of this editor to enabled.
       *
       * @param {boolean} enabled
       * @returns {Promise}
       */

    }, {
      key: "doEnabled",
      value: function doEnabled(enabled) {
        return this.getChildWidgets().setAllEnabled(enabled);
      }
      /**
       * Destroys all children of the editor.
       *
       * @returns {Promise}
       */

    }, {
      key: "doDestroy",
      value: function doDestroy() {
        return this.getChildWidgets().destroyAll();
      }
      /**
       * Returns the OrderedMap of Domain Id length to be loaded in to the Domain Id
       * editor.
       *
       * @private
       * @returns {baja.OrderedMap}
       */

    }, {
      key: "$getLengthPatternMap",
      value: function $getLengthPatternMap() {
        var map = new baja.OrderedMap();
        map.put(escapeHtml("0"), "0");
        map.put(escapeHtml("1"), "1");
        map.put(escapeHtml("3"), "3");
        map.put(escapeHtml("6"), "6");
        return map;
      }
      /**
       * @private
       * @returns {module:bajaux/Widget}
       */

    }, {
      key: "$getLengthEditor",
      value: function $getLengthEditor() {
        return Widget["in"](this.$getLengthElement());
      }
      /**
       * @private
       * @returns {JQuery}
       */

    }, {
      key: "$getLengthElement",
      value: function $getLengthElement() {
        return this.jq().find('.domainIdLength');
      }
      /**
       * @private
       * @returns {module:bajaux/Widget}
       */

    }, {
      key: "$getIdEditor",
      value: function $getIdEditor() {
        return Widget["in"](this.$getIdElement());
      }
      /**
       * @private
       * @returns {JQuery}
       */

    }, {
      key: "$getIdElement",
      value: function $getIdElement() {
        return this.jq().find('.domainIdValue');
      }
      /**
       * Function is used to make the Domain Id Label and Id editor visible and change
       * the width of the Id editor as per the length in the Domain Id Length editor
       *
       * @param {JQuery} idElement - Domain Id element
       * @param {number } length - Domain Id Length
       */

    }, {
      key: "$styleIdEditor",
      value: function $styleIdEditor(idElement, length) {
        this.jq().find('.domainIdValue-label').css("visibility", "visible");
        idElement.css("visibility", "visible");
        idElement.find("input").css("width", getWidth(length));
      }
    }]);

    return DomainIdEditor;
  }(BaseEditor);
  /**
   * Function gets the width of the Domain Id string editor based on the length
   * of the Domain Id length
   * @param length
   * @returns {string}
   */


  function getWidth(length) {
    switch (length) {
      case 1:
        return "4em";

      case 3:
        return "7em";

      case 6:
        return "13em";

      default:
        return "6em";
    }
  }

  return DomainIdEditor;
});
