function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Shivani Jakhmola
 */

/**
 * API Status: **Private**
 * @module nmodule/lonworks/rc/baja/DomainId
 */
define(['baja!', 'lex!lonworks', 'nmodule/webEditors/rc/util/byteUtils'], function (baja, lexs, byteUtils) {
  "use strict";

  var _lexs = _slicedToArray(lexs, 1),
      lonworksLex = _lexs[0];
  /**
   * A javascript based implementation of lonworks:DomainId
   *
   * @class
   * @alias module:nmodule/lonworks/rc/baja/DomainId
   * @extends baja.Simple
   */


  var DomainId = /*#__PURE__*/function (_baja$Simple) {
    _inherits(DomainId, _baja$Simple);

    var _super = _createSuper(DomainId);

    /**
     * Constructs a DomainId with the given byte array of the specified length.
     *
     * @param {number} len - The length of the domain Id.It can take a value of 0,1,3 and 6.NaN, +inf, -inf are invalid values.
     * @param {Array.<number>} id - The domain id value
     */
    function DomainId(len, id) {
      var _this;

      _classCallCheck(this, DomainId);

      _this = _super.call(this);

      if (!isValidLength(len)) {
        throw new Error(lonworksLex.get('domainId.length.error', len));
      }

      if (isInvalidDomainId(id)) {
        throw new Error(lonworksLex.get('domainId.id.error', id));
      }

      _this.$domainLength = len; //copying id to domainId

      _this.$domainId = id.slice(0, len);
      return _this;
    }
    /**
     * Make a domainId with passed length and Id
     *
     * @example
     * //creates a domain ID with specified length as 3 and domain Id value
     * let domainId=DomainId.make(3,[10,28,110]);
     *
     * @example
     * //creates a domain ID with specified len as 6 and domain Id value
     * let domainId=DomainId.make(6,[10,28,110,78,90,23]);
     *
     * @param {number} len
     * @param {Array.<number>} id
     * @returns {module:nmodule/lonworks/rc/baja/DomainId}
     */


    _createClass(DomainId, [{
      key: "make",

      /**
       * Make a domainId with passed length and Id
       *
       * @param {number} len
       * @param {Array.<number>} id
       * @returns {module:nmodule/lonworks/rc/baja/DomainId}
       */
      value: function make(len, id) {
        return new DomainId(len, id);
      }
      /**
       * Encodes the domainId length and id value to string with
       * len=domainIdlength:id
       *
       * @returns {string}
       */

    }, {
      key: "encodeToString",
      value: function encodeToString() {
        return "len=" + this.$domainLength + ":" + byteUtils.byteArrayToString(this.$domainId, '.', this.$domainLength, 16);
      }
      /**
       * Converts a string value into a domainId tuple. Throws an error if the string is not in the valid format.
       *
       * @param {string} string
       * @returns {module:nmodule/lonworks/rc/baja/DomainId}
       */

    }, {
      key: "decodeFromString",
      value: function decodeFromString(string) {
        if (string.length === 0) {
          return DomainId.DEFAULT;
        }

        var slen = string.substring(string.indexOf('=') + 1, string.indexOf(':')).trim();
        var len = parseInt(slen);

        if (len === 0) {
          return DomainId.DEFAULT;
        }

        if (!isValidLength(len)) {
          throw new Error(lonworksLex.get('domainId.length.error', len));
        }

        var id = string.substring(string.indexOf(':') + 1);
        var domId = byteUtils.stringToByteArray(id, len);
        return new DomainId(len, domId);
      }
      /**
       * Get the length of the domain Id
       *
       * @returns {number}
       */

    }, {
      key: "getDomainIdLength",
      value: function getDomainIdLength() {
        return this.$domainLength;
      }
      /**
       * Get the byte array of the domain Id value
       *
       * @returns {Array.<number>|null}
       */

    }, {
      key: "getDomainId",
      value: function getDomainId() {
        return this.$domainId.slice();
      }
    }], [{
      key: "make",
      value: function make(len, id) {
        return new DomainId(len, id);
      }
    }]);

    return DomainId;
  }(baja.Simple);

  DomainId.DEFAULT = new DomainId(0, []);
  /**
   * Function to check if the domain id length is valid. Only acceptable values are 0,1,3 and 6
   * @param len
   * @returns {boolean}
   */

  function isValidLength(len) {
    switch (len) {
      case 0:
      case 1:
      case 3:
      case 6:
        return true;
    }

    return false;
  }
  /**
   * Function checks if the domain Id is invalid. Negative infinity, NaN and Positive infinity are not valid.
   * @param id
   * @returns {boolean}
   */


  function isInvalidDomainId(id) {
    for (var i = 0; i < id.length; i++) {
      if (!isFinite(id[i])) {
        return true;
      }
    }

    return false;
  }

  return DomainId;
});
