/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/**
 * A module defining `TabularThermistorConversionEditor`.
 * API Status: **Private**
 * @module nmodule/ndio/rc/fe/TabularThermistorConversionEditor
 */
define([
  'nmodule/driver/rc/fe/BaseTabularConversionEditor',
  'jquery',
  'Promise',
  'baja!',
  'lex!ndio',
  'nmodule/driver/rc/fe/XYPointEditor',
  'nmodule/driver/rc/baja/XYPoint',
  'nmodule/ndio/rc/baja/TabularThermistorConversion',
  'underscore'
], function
  (BaseTabularConversionEditor,
   $,
   Promise,
   baja,
   lexs,
   XYPointEditor,
   XYPoint,
   TabularThermistorConversion,
   _) {

  'use strict';

  var ndioLex = lexs[0];

  /**
   * Bajaux for Tabular conversion
   *
   * @class
   * @extends module:bajaux/Widget
   * @alias module:nmodule/ndio/rc/fe/TabularThermistorConversionEditor
   */
  var TabularThermistorConversionEditor = function TabularThermistorConversionEditor() {
    var that = this;
    BaseTabularConversionEditor.apply(that, arguments);
  };

  //extend and set up prototype chain
  TabularThermistorConversionEditor.prototype = Object.create(BaseTabularConversionEditor.prototype);
  TabularThermistorConversionEditor.prototype.constructor = TabularThermistorConversionEditor;

  /**
   * @see BaseTabularConversionEditor.getInitDomProps
   */
  TabularThermistorConversionEditor.prototype.getInitDomProps = function () {
    return {
      labels: {
        desc: ndioLex.get("tabularDialog.descriptionLabel"),
        source: ndioLex.get("tabularDialog.ohmsColumnLabel"),
        result: ndioLex.get("tabularDialog.celsiusColumnLabel")
      }
    };
  };

  /**
   * Reads the editor data into a TabularThermistorConversion object
   * @returns {Promise} promise to be resolved with the current value
   */
  TabularThermistorConversionEditor.prototype.doRead = function () {
    return Promise.join(
      this.$getDescEditor().read(),
      this.getBuilder().readAll()
    ).spread(function (desc, points) {
        return TabularThermistorConversion.make(desc, points);
      });
  };

  return TabularThermistorConversionEditor;
});
